/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.proxy.Interceptor;
/*     */ import org.jboss.proxy.ejb.handle.StatelessHandleImpl;
/*     */ 
/*     */ public class StatelessSessionInterceptor extends GenericEJBInterceptor
/*     */ {
/*     */   private static final long serialVersionUID = -8807189798153718350L;
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  63 */     InvocationContext ctx = invocation.getInvocationContext();
/*  64 */     Method m = invocation.getMethod();
/*     */ 
/*  67 */     if (m.equals(TO_STRING))
/*     */     {
/*  69 */       return toString(ctx);
/*     */     }
/*  71 */     if (m.equals(EQUALS))
/*     */     {
/*  73 */       Object[] args = invocation.getArguments();
/*  74 */       String argsString = args[0] != null ? args[0].toString() : "";
/*  75 */       String thisString = toString(ctx);
/*  76 */       return new Boolean(thisString.equals(argsString));
/*     */     }
/*  78 */     if (m.equals(HASH_CODE))
/*     */     {
/*  82 */       return new Integer(hashCode());
/*     */     }
/*     */ 
/*  85 */     if (m.equals(GET_HANDLE))
/*     */     {
/*  87 */       return new StatelessHandleImpl((String)ctx.getValue(InvocationKey.JNDI_NAME));
/*     */     }
/*     */ 
/*  90 */     if (m.equals(GET_PRIMARY_KEY))
/*     */     {
/*  92 */       throw new RemoteException("Call to getPrimaryKey not allowed on session bean");
/*     */     }
/*  94 */     if (m.equals(GET_EJB_HOME))
/*     */     {
/*  96 */       return getEJBHome(invocation);
/*     */     }
/*  98 */     if (m.equals(IS_IDENTICAL))
/*     */     {
/* 102 */       Object[] args = invocation.getArguments();
/* 103 */       String argsString = args[0].toString();
/* 104 */       String thisString = toString(ctx);
/* 105 */       return new Boolean(thisString.equals(argsString));
/*     */     }
/*     */ 
/* 110 */     invocation.setType(InvocationType.REMOTE);
/*     */ 
/* 112 */     return getNext().invoke(invocation);
/*     */   }
/*     */ 
/*     */   private String toString(InvocationContext ctx)
/*     */   {
/* 123 */     return ctx.getValue(InvocationKey.JNDI_NAME) + ":Stateless";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.StatelessSessionInterceptor
 * JD-Core Version:    0.6.0
 */