/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.ServiceUnavailableException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.NamingContextFactory;
/*     */ import org.jboss.proxy.Interceptor;
/*     */ 
/*     */ public class RetryInterceptor extends Interceptor
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private static final int EXTERNAL_VERSION = 1;
/*  69 */   private static Logger log = Logger.getLogger(RetryInterceptor.class);
/*     */   private static Properties retryEnv;
/*     */   private transient boolean retry;
/*     */   private transient boolean trace;
/*  78 */   private transient int maxRetries = -1;
/*     */ 
/*  80 */   private transient long sleepTime = 1000L;
/*     */ 
/*     */   public static void setRetryEnv(Properties env)
/*     */   {
/*  88 */     retryEnv = env;
/*     */   }
/*     */ 
/*     */   public RetryInterceptor()
/*     */   {
/*     */   }
/*     */ 
/*     */   protected RetryInterceptor(int maxRetries, long sleepTime)
/*     */   {
/* 107 */     this.maxRetries = maxRetries;
/* 108 */     this.sleepTime = sleepTime;
/*     */   }
/*     */ 
/*     */   public void setRetry(boolean flag)
/*     */   {
/* 115 */     this.retry = flag;
/*     */   }
/*     */ 
/*     */   public boolean getRetry() {
/* 119 */     return this.retry;
/*     */   }
/*     */ 
/*     */   public int getMaxRetries()
/*     */   {
/* 127 */     return this.maxRetries;
/*     */   }
/*     */ 
/*     */   public void setMaxRetries(int maxRetries)
/*     */   {
/* 138 */     this.maxRetries = maxRetries;
/*     */   }
/*     */ 
/*     */   public long getSleepTime()
/*     */   {
/* 146 */     return this.sleepTime;
/*     */   }
/*     */ 
/*     */   public void setSleepTime(long sleepTime)
/*     */   {
/* 154 */     this.sleepTime = sleepTime;
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 165 */     Object result = null;
/* 166 */     InvocationContext ctx = invocation.getInvocationContext();
/* 167 */     this.retry = true;
/* 168 */     int retryCount = 0;
/* 169 */     while (this.retry == true)
/*     */     {
/* 171 */       Interceptor next = getNext();
/*     */       try
/*     */       {
/* 174 */         if (this.trace)
/* 175 */           log.trace("invoke, method=" + invocation.getMethod());
/* 176 */         result = next.invoke(invocation);
/*     */       }
/*     */       catch (ServiceUnavailableException e)
/*     */       {
/* 181 */         if (this.trace) {
/* 182 */           log.trace("Invocation failed", e);
/*     */         }
/* 184 */         InvocationType type = invocation.getType();
/* 185 */         if (((this.maxRetries > -1) && (retryCount >= this.maxRetries)) || (!reestablishInvokerProxy(ctx, type)))
/*     */         {
/* 188 */           throw e;
/*     */         }
/* 190 */         retryCount++;
/*     */       }
/*     */     }
/* 193 */     return result;
/*     */   }
/*     */ 
/*     */   private boolean reestablishInvokerProxy(InvocationContext ctx, InvocationType type)
/*     */   {
/* 211 */     if (this.trace) {
/* 212 */       log.trace("Begin reestablishInvokerProxy");
/*     */     }
/* 214 */     boolean isRemote = type == InvocationType.REMOTE;
/* 215 */     String jndiName = (String)ctx.getValue(InvocationKey.JNDI_NAME);
/* 216 */     if (isRemote == true)
/* 217 */       jndiName = jndiName + "-RemoteInvoker";
/*     */     else
/* 219 */       jndiName = jndiName + "-HomeInvoker";
/* 220 */     Hashtable retryProps = retryEnv;
/* 221 */     if (retryProps == null)
/*     */     {
/* 223 */       retryProps = (Hashtable)NamingContextFactory.lastInitialContextEnv.get();
/* 224 */       if (this.trace)
/*     */       {
/* 226 */         if (retryProps != null)
/* 227 */           log.trace("Using retry properties from NamingContextFactory");
/*     */         else
/* 229 */           log.trace("No retry properties available");
/*     */       }
/*     */     }
/* 232 */     else if (this.trace)
/*     */     {
/* 234 */       log.trace("Using static retry properties");
/*     */     }
/*     */ 
/* 237 */     int retryCount = 0;
/* 238 */     Invoker newInvoker = null;
/* 239 */     while (this.retry == true)
/*     */     {
/*     */       try
/*     */       {
/* 243 */         Thread.sleep(this.sleepTime);
/* 244 */         InitialContext namingCtx = new InitialContext(retryProps);
/* 245 */         if (this.trace)
/* 246 */           log.trace("Looking for invoker: " + jndiName);
/* 247 */         newInvoker = (Invoker)namingCtx.lookup(jndiName);
/* 248 */         if (this.trace)
/* 249 */           log.trace("Found invoker: " + newInvoker);
/* 250 */         ctx.setInvoker(newInvoker);
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 255 */         retryCount++;
/* 256 */         if (this.trace) {
/* 257 */           log.trace("Retry attempt " + retryCount + ": Failed to lookup proxy", t);
/*     */         }
/* 259 */         if ((this.maxRetries > -1) && (retryCount >= this.maxRetries))
/*     */         {
/* 261 */           if (this.trace) {
/* 262 */             log.trace("Maximum retry attempts made");
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 267 */     if (this.trace) {
/* 268 */       log.trace("End reestablishInvokerProxy");
/*     */     }
/* 270 */     return newInvoker != null;
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 279 */     super.writeExternal(out);
/*     */ 
/* 281 */     out.writeInt(1);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 291 */     super.readExternal(in);
/*     */ 
/* 293 */     int version = in.readInt();
/* 294 */     if (version == 1);
/* 299 */     this.trace = log.isTraceEnabled();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.RetryInterceptor
 * JD-Core Version:    0.6.0
 */