/*    */ package org.jboss.proxy.ejb;
/*    */ 
/*    */ import java.rmi.RemoteException;
/*    */ import javax.transaction.Transaction;
/*    */ import org.jboss.ejb.Container;
/*    */ import org.jboss.ejb.Interceptor;
/*    */ import org.jboss.ejb.plugins.AbstractInterceptor;
/*    */ import org.jboss.invocation.Invocation;
/*    */ import org.jboss.metadata.BeanMetaData;
/*    */ 
/*    */ public class NoTxPropagationInterceptor extends AbstractInterceptor
/*    */ {
/*    */   public Object invokeHome(Invocation mi)
/*    */     throws Exception
/*    */   {
/* 43 */     checkNoTxPropagation(mi);
/* 44 */     return getNext().invokeHome(mi);
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation mi) throws Exception
/*    */   {
/* 49 */     checkNoTxPropagation(mi);
/* 50 */     return getNext().invoke(mi);
/*    */   }
/*    */ 
/*    */   protected void checkNoTxPropagation(Invocation mi)
/*    */     throws Exception
/*    */   {
/* 56 */     if (mi.isLocal()) {
/* 57 */       return;
/*    */     }
/*    */ 
/* 60 */     Transaction tx = mi.getTransaction();
/* 61 */     if ((tx == null) || (!(tx instanceof ForeignTransaction))) {
/* 62 */       return;
/*    */     }
/* 64 */     byte txType = this.container.getBeanMetaData().getTransactionMethod(mi.getMethod(), mi.getType());
/* 65 */     if ((txType != 0) && (txType != 3)) {
/* 66 */       throw new RemoteException("TxPropagation is not supported: " + this.container.getJmxName() + " method=" + mi.getMethod());
/*    */     }
/*    */ 
/* 69 */     mi.setTransaction(null);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.NoTxPropagationInterceptor
 * JD-Core Version:    0.6.0
 */