/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.management.ObjectName;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import javax.rmi.CORBA.Stub;
/*     */ import javax.rmi.PortableRemoteObject;
/*     */ import org.jacorb.ssl.SSLPolicyValue;
/*     */ import org.jacorb.ssl.SSLPolicyValueHelper;
/*     */ import org.jboss.ejb.Container;
/*     */ import org.jboss.ejb.EJBProxyFactory;
/*     */ import org.jboss.ejb.EJBProxyFactoryContainer;
/*     */ import org.jboss.ejb.EntityContainer;
/*     */ import org.jboss.ejb.StatefulSessionContainer;
/*     */ import org.jboss.ejb.StatelessSessionContainer;
/*     */ import org.jboss.iiop.CorbaNamingService;
/*     */ import org.jboss.iiop.CorbaORBService;
/*     */ import org.jboss.iiop.rmi.AttributeAnalysis;
/*     */ import org.jboss.iiop.rmi.InterfaceAnalysis;
/*     */ import org.jboss.iiop.rmi.OperationAnalysis;
/*     */ import org.jboss.iiop.rmi.ir.InterfaceRepository;
/*     */ import org.jboss.iiop.rmi.marshal.strategy.SkeletonStrategy;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.iiop.ReferenceFactory;
/*     */ import org.jboss.invocation.iiop.ServantRegistries;
/*     */ import org.jboss.invocation.iiop.ServantRegistry;
/*     */ import org.jboss.invocation.iiop.ServantRegistryKind;
/*     */ import org.jboss.invocation.iiop.ServantWithMBeanServer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.BeanMetaData;
/*     */ import org.jboss.metadata.EntityMetaData;
/*     */ import org.jboss.metadata.InvokerProxyBindingMetaData;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData;
/*     */ import org.jboss.metadata.IorSecurityConfigMetaData.TransportConfig;
/*     */ import org.jboss.metadata.MetaData;
/*     */ import org.jboss.metadata.SessionMetaData;
/*     */ import org.jboss.naming.Util;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.web.WebClassLoader;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.InterfaceDef;
/*     */ import org.omg.CORBA.InterfaceDefHelper;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.Policy;
/*     */ import org.omg.CORBA.Repository;
/*     */ import org.omg.CosNaming.NameComponent;
/*     */ import org.omg.CosNaming.NamingContext;
/*     */ import org.omg.CosNaming.NamingContextExt;
/*     */ import org.omg.CosNaming.NamingContextExtHelper;
/*     */ import org.omg.CosNaming.NamingContextHelper;
/*     */ import org.omg.CosNaming.NamingContextPackage.CannotProceed;
/*     */ import org.omg.CosNaming.NamingContextPackage.InvalidName;
/*     */ import org.omg.CosNaming.NamingContextPackage.NotFound;
/*     */ import org.omg.PortableServer.Current;
/*     */ import org.omg.PortableServer.CurrentHelper;
/*     */ import org.omg.PortableServer.POA;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ public class IORFactory
/*     */   implements EJBProxyFactory
/*     */ {
/* 113 */   private static final Logger staticLogger = Logger.getLogger(IORFactory.class);
/*     */   private ORB orb;
/*     */   private Container container;
/*     */   private String jndiName;
/*     */   private boolean useJNPContext;
/*     */   private String jnpName;
/*     */   private EJBMetaDataImplIIOP ejbMetaData;
/*     */   private Map beanMethodMap;
/*     */   private Map homeMethodMap;
/*     */   private String[] beanRepositoryIds;
/*     */   private String[] homeRepositoryIds;
/*     */   private ServantRegistry homeServantRegistry;
/*     */   private ServantRegistry beanServantRegistry;
/*     */   private ReferenceFactory homeReferenceFactory;
/*     */   private ReferenceFactory beanReferenceFactory;
/*     */   private Current poaCurrent;
/*     */   private Policy codebasePolicy;
/*     */   private Policy csiv2Policy;
/*     */   private Policy sslPolicy;
/*     */   private EJBHome ejbHome;
/*     */   private InvokerProxyBindingMetaData invokerMetaData;
/*     */   private ServantRegistries servantRegistries;
/*     */   private InterfaceRepository iri;
/*     */   private POA irPoa;
/* 244 */   private Logger logger = staticLogger;
/*     */ 
/*     */   public void setContainer(Container container)
/*     */   {
/* 250 */     this.container = container;
/* 251 */     if (container != null) {
/* 252 */       String loggerName = IORFactory.class.getName() + '.' + container.getBeanMetaData().getJndiName();
/*     */ 
/* 254 */       this.logger = Logger.getLogger(loggerName);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void create() throws Exception
/*     */   {
/*     */     try
/*     */     {
/* 262 */       this.orb = ((ORB)new InitialContext().lookup("java:/" + CorbaORBService.ORB_NAME));
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 266 */       throw new Exception("Cannot lookup java:/" + CorbaORBService.ORB_NAME + ": " + e);
/*     */     }
/*     */     try
/*     */     {
/* 270 */       this.irPoa = ((POA)new InitialContext().lookup("java:/" + CorbaORBService.IR_POA_NAME));
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 274 */       throw new Exception("Cannot lookup java:/" + CorbaORBService.IR_POA_NAME + ": " + e);
/*     */     }
/*     */ 
/* 279 */     Element proxyFactoryConfig = this.invokerMetaData.getProxyFactoryConfig();
/* 280 */     boolean interfaceRepositorySupported = MetaData.getOptionalChildBooleanContent(proxyFactoryConfig, "interface-repository-supported");
/*     */ 
/* 284 */     if (interfaceRepositorySupported)
/*     */     {
/* 286 */       this.iri = new InterfaceRepository(this.orb, this.irPoa, this.jndiName);
/*     */ 
/* 289 */       this.iri.mapClass(((EJBProxyFactoryContainer)this.container).getRemoteClass());
/* 290 */       this.iri.mapClass(((EJBProxyFactoryContainer)this.container).getHomeClass());
/* 291 */       this.iri.finishBuild();
/*     */ 
/* 293 */       this.logger.info("CORBA interface repository for " + this.jndiName + ": " + this.orb.object_to_string(this.iri.getReference()));
/*     */     }
/*     */ 
/* 298 */     this.logger.debug("Bean methods:");
/*     */ 
/* 300 */     InterfaceAnalysis interfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(((EJBProxyFactoryContainer)this.container).getRemoteClass());
/*     */ 
/* 304 */     this.beanMethodMap = new HashMap();
/*     */ 
/* 306 */     AttributeAnalysis[] attrs = interfaceAnalysis.getAttributes();
/* 307 */     for (int i = 0; i < attrs.length; i++) {
/* 308 */       OperationAnalysis op = attrs[i].getAccessorAnalysis();
/*     */ 
/* 310 */       this.logger.debug("    " + op.getJavaName() + "\n                " + op.getIDLName());
/*     */ 
/* 312 */       this.beanMethodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
/*     */ 
/* 314 */       op = attrs[i].getMutatorAnalysis();
/* 315 */       if (op != null) {
/* 316 */         this.logger.debug("    " + op.getJavaName() + "\n                " + op.getIDLName());
/*     */ 
/* 318 */         this.beanMethodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 323 */     OperationAnalysis[] ops = interfaceAnalysis.getOperations();
/* 324 */     for (int i = 0; i < ops.length; i++) {
/* 325 */       this.logger.debug("    " + ops[i].getJavaName() + "\n                " + ops[i].getIDLName());
/*     */ 
/* 327 */       this.beanMethodMap.put(ops[i].getIDLName(), new SkeletonStrategy(ops[i].getMethod()));
/*     */     }
/*     */ 
/* 332 */     this.beanRepositoryIds = interfaceAnalysis.getAllTypeIds();
/*     */ 
/* 335 */     this.logger.debug("Home methods:");
/*     */ 
/* 337 */     interfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(((EJBProxyFactoryContainer)this.container).getHomeClass());
/*     */ 
/* 341 */     this.homeMethodMap = new HashMap();
/*     */ 
/* 343 */     attrs = interfaceAnalysis.getAttributes();
/* 344 */     for (int i = 0; i < attrs.length; i++) {
/* 345 */       OperationAnalysis op = attrs[i].getAccessorAnalysis();
/*     */ 
/* 347 */       this.logger.debug("    " + op.getJavaName() + "\n                " + op.getIDLName());
/*     */ 
/* 349 */       this.homeMethodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
/*     */ 
/* 351 */       op = attrs[i].getMutatorAnalysis();
/* 352 */       if (op != null) {
/* 353 */         this.logger.debug("    " + op.getJavaName() + "\n                " + op.getIDLName());
/*     */ 
/* 355 */         this.homeMethodMap.put(op.getIDLName(), new SkeletonStrategy(op.getMethod()));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 360 */     ops = interfaceAnalysis.getOperations();
/* 361 */     for (int i = 0; i < ops.length; i++) {
/* 362 */       this.logger.debug("    " + ops[i].getJavaName() + "\n                " + ops[i].getIDLName());
/*     */ 
/* 364 */       this.homeMethodMap.put(ops[i].getIDLName(), new SkeletonStrategy(ops[i].getMethod()));
/*     */     }
/*     */ 
/* 369 */     this.homeRepositoryIds = interfaceAnalysis.getAllTypeIds();
/*     */ 
/* 372 */     this.logger.debug("container classloader: " + this.container.getClassLoader() + "\ncontainer parent classloader: " + this.container.getClassLoader().getParent());
/*     */ 
/* 375 */     WebClassLoader wcl = (WebClassLoader)this.container.getWebClassLoader();
/*     */     String codebaseString;
/* 377 */     if ((wcl != null) && ((codebaseString = wcl.getCodebaseString()) != null))
/*     */     {
/* 379 */       Any codebase = this.orb.create_any();
/* 380 */       codebase.insert_string(codebaseString);
/* 381 */       this.codebasePolicy = this.orb.create_policy(305419896, codebase);
/* 382 */       this.logger.debug("codebasePolicy: " + this.codebasePolicy);
/*     */     }
/*     */     else
/*     */     {
/* 386 */       this.logger.debug("Not setting codebase policy, codebase is null");
/*     */     }
/*     */ 
/* 391 */     Any secPolicy = this.orb.create_any();
/* 392 */     IorSecurityConfigMetaData iorSecurityConfigMetaData = this.container.getBeanMetaData().getIorSecurityConfigMetaData();
/*     */ 
/* 394 */     secPolicy.insert_Value(iorSecurityConfigMetaData);
/* 395 */     this.csiv2Policy = this.orb.create_policy(-2023406815, secPolicy);
/*     */ 
/* 400 */     boolean sslRequired = false;
/* 401 */     if (iorSecurityConfigMetaData != null) {
/* 402 */       IorSecurityConfigMetaData.TransportConfig tc = iorSecurityConfigMetaData.getTransportConfig();
/*     */ 
/* 404 */       sslRequired = (tc.getIntegrity() == "REQUIRED") || (tc.getConfidentiality() == "REQUIRED") || (tc.getEstablishTrustInClient() == "REQUIRED");
/*     */     }
/*     */ 
/* 412 */     Any sslPolicyValue = this.orb.create_any();
/* 413 */     SSLPolicyValueHelper.insert(sslPolicyValue, sslRequired ? SSLPolicyValue.SSL_REQUIRED : SSLPolicyValue.SSL_NOT_REQUIRED);
/*     */ 
/* 417 */     this.sslPolicy = this.orb.create_policy(101, sslPolicyValue);
/* 418 */     this.logger.debug("container's SSL policy: " + this.sslPolicy);
/*     */ 
/* 421 */     this.poaCurrent = CurrentHelper.narrow(this.orb.resolve_initial_references("POACurrent"));
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 430 */     ObjectName oname = new ObjectName(this.invokerMetaData.getInvokerMBean());
/* 431 */     this.servantRegistries = ((ServantRegistries)Registry.lookup(oname));
/* 432 */     if (this.servantRegistries == null) {
/* 433 */       throw new Exception("invoker is null: " + oname);
/*     */     }
/* 435 */     Policy[] policies = null;
/* 436 */     if (this.codebasePolicy == null)
/* 437 */       policies = new Policy[] { this.sslPolicy, this.csiv2Policy };
/*     */     else {
/* 439 */       policies = new Policy[] { this.codebasePolicy, this.sslPolicy, this.csiv2Policy };
/*     */     }
/*     */ 
/* 445 */     Element proxyFactoryConfig = this.invokerMetaData.getProxyFactoryConfig();
/* 446 */     String poaUsageModel = MetaData.getOptionalChildContent(proxyFactoryConfig, "poa");
/*     */     ServantRegistryKind registryWithPersistentPOA;
/* 448 */     if ((poaUsageModel == null) || (poaUsageModel.equals("shared"))) {
/* 449 */       ServantRegistryKind registryWithTransientPOA = ServantRegistryKind.SHARED_TRANSIENT_POA;
/* 450 */       registryWithPersistentPOA = ServantRegistryKind.SHARED_PERSISTENT_POA;
/*     */     }
/*     */     else
/*     */     {
/*     */       ServantRegistryKind registryWithPersistentPOA;
/* 452 */       if (poaUsageModel.equals("per-servant")) {
/* 453 */         ServantRegistryKind registryWithTransientPOA = ServantRegistryKind.TRANSIENT_POA_PER_SERVANT;
/*     */ 
/* 455 */         registryWithPersistentPOA = ServantRegistryKind.PERSISTENT_POA_PER_SERVANT;
/*     */       }
/*     */       else
/*     */       {
/* 459 */         throw new Exception("invalid poa element in proxy factory config: " + poaUsageModel);
/*     */       }
/*     */     }
/*     */     ServantRegistryKind registryWithPersistentPOA;
/*     */     ServantRegistryKind registryWithTransientPOA;
/* 465 */     InterfaceDef homeInterfaceDef = null;
/* 466 */     if (this.iri != null) {
/* 467 */       Repository ir = this.iri.getReference();
/* 468 */       homeInterfaceDef = InterfaceDefHelper.narrow(ir.lookup_id(this.homeRepositoryIds[0]));
/*     */     }
/*     */ 
/* 474 */     this.homeServantRegistry = this.servantRegistries.getServantRegistry(registryWithPersistentPOA);
/*     */ 
/* 478 */     String homeServantLoggerName = EjbHomeCorbaServant.class.getName() + '.' + this.jndiName;
/*     */ 
/* 481 */     ServantWithMBeanServer homeServant = new EjbHomeCorbaServant(this.container.getJmxName(), this.container.getClassLoader(), this.homeMethodMap, this.homeRepositoryIds, homeInterfaceDef, Logger.getLogger(homeServantLoggerName));
/*     */ 
/* 489 */     this.homeReferenceFactory = this.homeServantRegistry.bind(homeServantName(this.jndiName), homeServant, policies);
/*     */ 
/* 491 */     org.omg.CORBA.Object corbaRef = this.homeReferenceFactory.createReference(this.homeRepositoryIds[0]);
/*     */ 
/* 493 */     this.ejbHome = ((EJBHome)PortableRemoteObject.narrow(corbaRef, EJBHome.class));
/* 494 */     ((EjbHomeCorbaServant)homeServant).setHomeHandle(new HomeHandleImplIIOP(this.ejbHome));
/*     */ 
/* 498 */     if ((this.container.getBeanMetaData() instanceof EntityMetaData))
/*     */     {
/* 501 */       this.beanServantRegistry = this.servantRegistries.getServantRegistry(registryWithPersistentPOA);
/*     */ 
/* 505 */       EntityMetaData metaData = (EntityMetaData)this.container.getBeanMetaData();
/* 506 */       String pkClassName = metaData.getPrimaryKeyClass();
/*     */       Class pkClass;
/*     */       try
/*     */       {
/*     */         Class pkClass;
/* 508 */         if (pkClassName != null)
/* 509 */           pkClass = this.container.getClassLoader().loadClass(pkClassName);
/*     */         else {
/* 511 */           pkClass = this.container.getClassLoader().loadClass(metaData.getEjbClass()).getField(metaData.getPrimKeyField()).getClass();
/*     */         }
/*     */       }
/*     */       catch (NoSuchFieldException e)
/*     */       {
/* 516 */         this.logger.error("Unable to identify Bean's Primary Key class! Did you specify a primary key class and/or field? Does that field exist?");
/*     */ 
/* 519 */         throw new Exception("Primary Key Problem");
/*     */       }
/*     */       catch (NullPointerException e) {
/* 522 */         this.logger.error("Unable to identify Bean's Primary Key class! Did you specify a primary key class and/or field? Does that field exist?");
/*     */ 
/* 525 */         throw new Exception("Primary Key Problem");
/*     */       }
/*     */ 
/* 528 */       this.ejbMetaData = new EJBMetaDataImplIIOP(((EJBProxyFactoryContainer)this.container).getRemoteClass(), ((EJBProxyFactoryContainer)this.container).getHomeClass(), pkClass, false, false, this.ejbHome);
/*     */     }
/*     */     else
/*     */     {
/* 539 */       this.beanServantRegistry = this.servantRegistries.getServantRegistry(registryWithTransientPOA);
/*     */ 
/* 542 */       if (((SessionMetaData)this.container.getBeanMetaData()).isStateless())
/*     */       {
/* 545 */         this.ejbMetaData = new EJBMetaDataImplIIOP(((EJBProxyFactoryContainer)this.container).getRemoteClass(), ((EJBProxyFactoryContainer)this.container).getHomeClass(), null, true, true, this.ejbHome);
/*     */       }
/*     */       else
/*     */       {
/* 557 */         this.ejbMetaData = new EJBMetaDataImplIIOP(((EJBProxyFactoryContainer)this.container).getRemoteClass(), ((EJBProxyFactoryContainer)this.container).getHomeClass(), null, true, false, this.ejbHome);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 569 */     InterfaceDef beanInterfaceDef = null;
/* 570 */     if (this.iri != null) {
/* 571 */       Repository ir = this.iri.getReference();
/* 572 */       beanInterfaceDef = InterfaceDefHelper.narrow(ir.lookup_id(this.beanRepositoryIds[0]));
/*     */     }
/*     */ 
/* 576 */     String beanServantLoggerName = EjbObjectCorbaServant.class.getName() + '.' + this.jndiName;
/*     */ 
/* 579 */     ServantWithMBeanServer beanServant = new EjbObjectCorbaServant(this.container.getJmxName(), this.container.getClassLoader(), this.poaCurrent, this.beanMethodMap, this.beanRepositoryIds, beanInterfaceDef, Logger.getLogger(beanServantLoggerName));
/*     */ 
/* 588 */     this.beanReferenceFactory = this.beanServantRegistry.bind(beanServantName(this.jndiName), beanServant, policies);
/*     */ 
/* 591 */     this.logger.info("EJBHome reference for " + this.jndiName + ":\n" + this.orb.object_to_string((org.omg.CORBA.Object)this.ejbHome));
/*     */ 
/* 595 */     this.useJNPContext = MetaData.getOptionalChildBooleanContent(proxyFactoryConfig, "register-ejbs-in-jnp-context");
/*     */ 
/* 598 */     Context initialContext = new InitialContext();
/*     */ 
/* 600 */     if (this.useJNPContext) {
/* 601 */       String jnpContext = MetaData.getOptionalChildContent(proxyFactoryConfig, "jnp-context");
/*     */ 
/* 604 */       if ((jnpContext != null) && (!jnpContext.equals(""))) {
/* 605 */         this.jnpName = (jnpContext + "/" + this.jndiName);
/*     */       }
/*     */       else {
/* 608 */         this.jnpName = this.jndiName;
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 613 */         Util.rebind(initialContext, this.jnpName, new Reference("javax.ejb.EJBHome", new StringRefAddr("IOR", this.orb.object_to_string((org.omg.CORBA.Object)this.ejbHome)), IIOPHomeFactory.class.getName(), null));
/*     */ 
/* 622 */         this.logger.info("Home IOR for " + this.container.getBeanMetaData().getEjbName() + " bound to " + this.jnpName + " in JNP naming service");
/*     */       }
/*     */       catch (NamingException e)
/*     */       {
/* 626 */         throw new Exception("Cannot bind EJBHome in JNDI:\n" + e);
/*     */       }
/*     */     }
/*     */ 
/* 630 */     NamingContextExt corbaContext = null;
/*     */     try
/*     */     {
/* 633 */       corbaContext = NamingContextExtHelper.narrow((org.omg.CORBA.Object)initialContext.lookup("java:/" + CorbaNamingService.NAMING_NAME));
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/* 638 */       throw new Exception("Cannot lookup java:/" + CorbaNamingService.NAMING_NAME + ":\n" + e);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 644 */       rebind(corbaContext, this.jndiName, (org.omg.CORBA.Object)this.ejbHome);
/* 645 */       this.logger.info("Home IOR for " + this.container.getBeanMetaData().getEjbName() + " bound to " + this.jndiName + " in CORBA naming service");
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 649 */       this.logger.error("Cannot bind EJBHome in CORBA naming service:", e);
/* 650 */       throw new Exception("Cannot bind EJBHome in CORBA naming service:\n" + e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */     try
/*     */     {
/* 660 */       Context initialContext = new InitialContext();
/*     */ 
/* 662 */       if (this.useJNPContext) {
/*     */         try
/*     */         {
/* 665 */           initialContext.unbind(this.jnpName);
/*     */         }
/*     */         catch (NamingException namingException) {
/* 668 */           this.logger.error("Cannot unbind EJBHome from JNDI", namingException);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 673 */       NamingContextExt corbaContext = NamingContextExtHelper.narrow((org.omg.CORBA.Object)initialContext.lookup("java:/" + CorbaNamingService.NAMING_NAME));
/*     */       try
/*     */       {
/* 680 */         NameComponent[] name = corbaContext.to_name(this.jndiName);
/* 681 */         corbaContext.unbind(name);
/*     */       }
/*     */       catch (InvalidName invalidName) {
/* 684 */         this.logger.error("Cannot unregister EJBHome from CORBA naming service", invalidName);
/*     */       }
/*     */       catch (NotFound notFound)
/*     */       {
/* 688 */         this.logger.error("Cannot unregister EJBHome from CORBA naming service", notFound);
/*     */       }
/*     */       catch (CannotProceed cannotProceed)
/*     */       {
/* 692 */         this.logger.error("Cannot unregister EJBHome from CORBA naming service", cannotProceed);
/*     */       }
/*     */     }
/*     */     catch (NamingException namingException)
/*     */     {
/* 697 */       this.logger.error("Unexpected error in JNDI lookup", namingException);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 702 */       this.homeServantRegistry.unbind(homeServantName(this.jndiName));
/*     */     }
/*     */     catch (Exception e) {
/* 705 */       this.logger.error("Cannot deactivate home servant", e);
/*     */     }
/*     */     try {
/* 708 */       this.beanServantRegistry.unbind(beanServantName(this.jndiName));
/*     */     }
/*     */     catch (Exception e) {
/* 711 */       this.logger.error("Cannot deactivate bean servant", e);
/*     */     }
/*     */ 
/* 714 */     if (this.iri != null)
/*     */     {
/* 716 */       this.iri.shutdown();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void destroy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public void setInvokerMetaData(InvokerProxyBindingMetaData imd)
/*     */   {
/* 728 */     this.invokerMetaData = imd;
/*     */   }
/*     */ 
/*     */   public void setInvokerBinding(String binding)
/*     */   {
/* 733 */     this.jndiName = binding;
/*     */   }
/*     */ 
/*     */   public boolean isIdentical(Container container, Invocation mi)
/*     */   {
/* 738 */     EJBObject other = (EJBObject)mi.getArguments()[0];
/* 739 */     if (other == null)
/* 740 */       return false;
/*     */     EJBObject me;
/* 742 */     if ((container instanceof StatelessSessionContainer)) {
/* 743 */       me = (EJBObject)getStatelessSessionEJBObject();
/*     */     }
/*     */     else
/*     */     {
/*     */       EJBObject me;
/* 744 */       if ((container instanceof StatefulSessionContainer)) {
/* 745 */         me = (EJBObject)getStatefulSessionEJBObject(mi.getId());
/*     */       }
/*     */       else
/*     */       {
/*     */         EJBObject me;
/* 746 */         if ((container instanceof EntityContainer))
/* 747 */           me = (EJBObject)getEntityEJBObject(mi.getId());
/*     */         else
/* 749 */           return false;
/*     */       }
/*     */     }
/*     */     EJBObject me;
/* 751 */     Stub meStub = (Stub)me;
/* 752 */     Stub otherStub = (Stub)other;
/* 753 */     return meStub._is_equivalent(otherStub);
/*     */   }
/*     */ 
/*     */   public EJBMetaData getEJBMetaData()
/*     */   {
/* 758 */     return this.ejbMetaData;
/*     */   }
/*     */ 
/*     */   public java.lang.Object getEJBHome()
/*     */   {
/* 763 */     return this.ejbHome;
/*     */   }
/*     */ 
/*     */   public java.lang.Object getStatelessSessionEJBObject()
/*     */   {
/*     */     try {
/* 769 */       return (EJBObject)PortableRemoteObject.narrow(this.beanReferenceFactory.createReference(this.beanRepositoryIds[0]), EJBObject.class);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 774 */     throw new RuntimeException("Unable to create reference to EJBObject\n" + e);
/*     */   }
/*     */ 
/*     */   public java.lang.Object getStatefulSessionEJBObject(java.lang.Object id)
/*     */   {
/*     */     try
/*     */     {
/* 782 */       return (EJBObject)PortableRemoteObject.narrow(this.beanReferenceFactory.createReferenceWithId(id, this.beanRepositoryIds[0]), EJBObject.class);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/*     */ 
/* 789 */     throw new RuntimeException("Unable to create reference to EJBObject\n" + e);
/*     */   }
/*     */ 
/*     */   public java.lang.Object getEntityEJBObject(java.lang.Object id)
/*     */   {
/* 796 */     if (this.logger.isTraceEnabled()) {
/* 797 */       this.logger.trace("getEntityEJBObject(), id class is " + id.getClass().getName());
/*     */     }
/*     */     try
/*     */     {
/* 801 */       java.lang.Object ejbObject = id == null ? null : (EJBObject)PortableRemoteObject.narrow(this.beanReferenceFactory.createReferenceWithId(id, this.beanRepositoryIds[0]), EJBObject.class);
/*     */ 
/* 805 */       return ejbObject;
/*     */     } catch (Exception e) {
/*     */     }
/* 808 */     throw new RuntimeException("Unable to create reference to EJBObject\n" + e);
/*     */   }
/*     */ 
/*     */   public Collection getEntityCollection(Collection ids)
/*     */   {
/* 815 */     if (this.logger.isTraceEnabled()) {
/* 816 */       this.logger.trace("entering getEntityCollection()");
/*     */     }
/* 818 */     Collection collection = new ArrayList(ids.size());
/* 819 */     Iterator idEnum = ids.iterator();
/* 820 */     while (idEnum.hasNext()) {
/* 821 */       collection.add(getEntityEJBObject(idEnum.next()));
/*     */     }
/* 823 */     if (this.logger.isTraceEnabled()) {
/* 824 */       this.logger.trace("leaving getEntityCollection()");
/*     */     }
/* 826 */     return collection;
/*     */   }
/*     */ 
/*     */   public static String rmiRepositoryId(Class clz)
/*     */   {
/* 836 */     return "RMI:" + clz.getName() + ":0000000000000000";
/*     */   }
/*     */ 
/*     */   public static void rebind(NamingContextExt ctx, String strName, org.omg.CORBA.Object obj)
/*     */     throws Exception
/*     */   {
/* 847 */     NameComponent[] name = ctx.to_name(strName);
/* 848 */     NamingContext intermediateCtx = ctx;
/*     */ 
/* 850 */     for (int i = 0; i < name.length - 1; i++) {
/* 851 */       NameComponent[] relativeName = { name[i] };
/*     */       try {
/* 853 */         intermediateCtx = NamingContextHelper.narrow(intermediateCtx.resolve(relativeName));
/*     */       }
/*     */       catch (NotFound e)
/*     */       {
/* 857 */         intermediateCtx = intermediateCtx.bind_new_context(relativeName);
/*     */       }
/*     */     }
/* 860 */     intermediateCtx.rebind(new NameComponent[] { name[(name.length - 1)] }, obj);
/*     */   }
/*     */ 
/*     */   private static String homeServantName(String jndiName)
/*     */   {
/* 870 */     return "EJBHome/" + jndiName;
/*     */   }
/*     */ 
/*     */   private static String beanServantName(String jndiName)
/*     */   {
/* 879 */     return "EJBObject/" + jndiName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.IORFactory
 * JD-Core Version:    0.6.0
 */