/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.proxy.Interceptor;
/*     */ 
/*     */ public abstract class GenericEJBInterceptor extends Interceptor
/*     */   implements Externalizable
/*     */ {
/*     */   private static final long serialVersionUID = 3844706474734439975L;
/*     */   protected static final Method TO_STRING;
/*     */   protected static final Method HASH_CODE;
/*     */   protected static final Method EQUALS;
/*     */   protected static final Method GET_PRIMARY_KEY;
/*     */   protected static final Method GET_HANDLE;
/*     */   protected static final Method GET_EJB_HOME;
/*     */   protected static final Method IS_IDENTICAL;
/*     */ 
/*     */   protected EJBHome getEJBHome(Invocation invocation)
/*     */     throws NamingException
/*     */   {
/*  98 */     InvocationContext ctx = invocation.getInvocationContext();
/*  99 */     EJBHome home = (EJBHome)ctx.getValue(InvocationKey.EJB_HOME);
/*     */ 
/* 101 */     if (home == null)
/*     */     {
/* 103 */       String jndiName = (String)ctx.getValue(InvocationKey.JNDI_NAME);
/* 104 */       InitialContext iniCtx = new InitialContext();
/* 105 */       home = (EJBHome)iniCtx.lookup(jndiName);
/*     */     }
/* 107 */     return home;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  65 */       Class[] empty = new Class[0];
/*  66 */       Class type = Object.class;
/*     */ 
/*  68 */       TO_STRING = type.getMethod("toString", empty);
/*  69 */       HASH_CODE = type.getMethod("hashCode", empty);
/*  70 */       EQUALS = type.getMethod("equals", new Class[] { type });
/*     */ 
/*  73 */       type = EJBObject.class;
/*     */ 
/*  75 */       GET_PRIMARY_KEY = type.getMethod("getPrimaryKey", empty);
/*  76 */       GET_HANDLE = type.getMethod("getHandle", empty);
/*  77 */       GET_EJB_HOME = type.getMethod("getEJBHome", empty);
/*  78 */       IS_IDENTICAL = type.getMethod("isIdentical", new Class[] { type });
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  82 */       e.printStackTrace();
/*  83 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.GenericEJBInterceptor
 * JD-Core Version:    0.6.0
 */