/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationContext;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.proxy.Interceptor;
/*     */ import org.jboss.proxy.ejb.handle.EntityHandleImpl;
/*     */ 
/*     */ public class EntityInterceptor extends GenericEJBInterceptor
/*     */ {
/*     */   private static final long serialVersionUID = 4399705304832568350L;
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  63 */     InvocationContext ctx = invocation.getInvocationContext();
/*     */ 
/*  65 */     Method m = invocation.getMethod();
/*     */ 
/*  68 */     if (m.equals(TO_STRING))
/*     */     {
/*  70 */       return toString(ctx);
/*     */     }
/*  72 */     if (m.equals(EQUALS))
/*     */     {
/*  74 */       Object[] args = invocation.getArguments();
/*  75 */       String argsString = args[0] != null ? args[0].toString() : "";
/*  76 */       String thisString = toString(ctx);
/*  77 */       return new Boolean(thisString.equals(argsString));
/*     */     }
/*  79 */     if (m.equals(HASH_CODE))
/*     */     {
/*  81 */       return new Integer(ctx.getCacheId().hashCode());
/*     */     }
/*     */ 
/*  84 */     if (m.equals(GET_HANDLE))
/*     */     {
/*  86 */       String jndiName = (String)ctx.getValue(InvocationKey.JNDI_NAME);
/*  87 */       Object id = ctx.getCacheId();
/*  88 */       return new EntityHandleImpl(jndiName, id);
/*     */     }
/*  90 */     if (m.equals(GET_PRIMARY_KEY))
/*     */     {
/*  92 */       return ctx.getCacheId();
/*     */     }
/*  94 */     if (m.equals(GET_EJB_HOME))
/*     */     {
/*  96 */       return getEJBHome(invocation);
/*     */     }
/*  98 */     if (m.equals(IS_IDENTICAL))
/*     */     {
/* 100 */       Object[] args = invocation.getArguments();
/* 101 */       String argsString = args[0].toString();
/* 102 */       String thisString = toString(ctx);
/* 103 */       return new Boolean(thisString.equals(argsString));
/*     */     }
/*     */ 
/* 109 */     invocation.setType(InvocationType.REMOTE);
/*     */ 
/* 111 */     invocation.setId(ctx.getCacheId());
/* 112 */     return getNext().invoke(invocation);
/*     */   }
/*     */ 
/*     */   private String toString(InvocationContext ctx)
/*     */   {
/* 121 */     return ctx.getValue(InvocationKey.JNDI_NAME) + ":" + ctx.getCacheId().toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.EntityInterceptor
 * JD-Core Version:    0.6.0
 */