/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.rmi.PortableRemoteObject;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.iiop.CorbaORB;
/*     */ import org.jboss.iiop.csiv2.SASCurrent;
/*     */ import org.jboss.iiop.rmi.RmiIdlUtil;
/*     */ import org.jboss.iiop.rmi.marshal.strategy.SkeletonStrategy;
/*     */ import org.jboss.iiop.tm.InboundTransactionCurrent;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.invocation.PayloadKey;
/*     */ import org.jboss.invocation.iiop.ReferenceData;
/*     */ import org.jboss.invocation.iiop.ServantWithMBeanServer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.ENCFactory;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.omg.CORBA.BAD_OPERATION;
/*     */ import org.omg.CORBA.InterfaceDef;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.ORBPackage.InvalidName;
/*     */ import org.omg.CORBA.portable.InvokeHandler;
/*     */ import org.omg.CORBA.portable.ResponseHandler;
/*     */ import org.omg.CORBA.portable.UnknownException;
/*     */ import org.omg.PortableServer.Current;
/*     */ import org.omg.PortableServer.POA;
/*     */ 
/*     */ public class EjbObjectCorbaServant extends ServantWithMBeanServer
/*     */   implements InvokeHandler, LocalIIOPInvoker
/*     */ {
/*     */   private final ObjectName containerName;
/*     */   private final ClassLoader containerClassLoader;
/*     */   private final Current poaCurrent;
/*     */   private final Map methodInvokerMap;
/*     */   private final String[] repositoryIds;
/*     */   private final InterfaceDef interfaceDef;
/*     */   private final Logger logger;
/*     */   private final boolean traceEnabled;
/*     */   private MBeanServer mbeanServer;
/*     */   private SASCurrent sasCurrent;
/*     */   private InboundTransactionCurrent inboundTxCurrent;
/*     */ 
/*     */   public EjbObjectCorbaServant(ObjectName containerName, ClassLoader containerClassLoader, Current poaCurrent, Map methodInvokerMap, String[] repositoryIds, InterfaceDef interfaceDef, Logger logger)
/*     */   {
/* 144 */     this.containerName = containerName;
/* 145 */     this.containerClassLoader = containerClassLoader;
/* 146 */     this.poaCurrent = poaCurrent;
/* 147 */     this.methodInvokerMap = methodInvokerMap;
/* 148 */     this.repositoryIds = repositoryIds;
/* 149 */     this.interfaceDef = interfaceDef;
/* 150 */     this.logger = logger;
/* 151 */     this.traceEnabled = logger.isTraceEnabled();
/*     */     try
/*     */     {
/* 154 */       this.sasCurrent = ((SASCurrent)CorbaORB.getInstance().resolve_initial_references("SASCurrent"));
/*     */     }
/*     */     catch (InvalidName invalidName)
/*     */     {
/* 159 */       this.sasCurrent = null;
/*     */     }
/*     */     try
/*     */     {
/* 163 */       this.inboundTxCurrent = ((InboundTransactionCurrent)CorbaORB.getInstance().resolve_initial_references("InboundTransactionCurrent"));
/*     */     }
/*     */     catch (InvalidName invalidName)
/*     */     {
/* 168 */       this.inboundTxCurrent = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMBeanServer(MBeanServer mbeanServer)
/*     */   {
/* 179 */     this.mbeanServer = mbeanServer;
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.Object _get_interface_def()
/*     */   {
/* 189 */     if (this.interfaceDef != null) {
/* 190 */       return this.interfaceDef;
/*     */     }
/* 192 */     return super._get_interface_def();
/*     */   }
/*     */ 
/*     */   public String[] _all_interfaces(POA poa, byte[] objectId)
/*     */   {
/* 203 */     return (String[])(String[])this.repositoryIds.clone();
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.portable.OutputStream _invoke(String opName, org.omg.CORBA.portable.InputStream in, ResponseHandler handler)
/*     */   {
/* 216 */     if (this.traceEnabled)
/*     */     {
/* 218 */       this.logger.trace("EJBObject invocation: " + opName);
/*     */     }
/*     */ 
/* 221 */     ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/* 222 */     Thread.currentThread().setContextClassLoader(this.containerClassLoader);
/*     */     try
/*     */     {
/* 225 */       SkeletonStrategy op = (SkeletonStrategy)this.methodInvokerMap.get(opName);
/* 226 */       if (op == null)
/*     */       {
/* 228 */         this.logger.debug("Unable to find opname '" + opName + "' valid operations:" + this.methodInvokerMap.keySet());
/* 229 */         throw new BAD_OPERATION(opName);
/*     */       }
/*     */       java.lang.Object id;
/*     */       try
/*     */       {
/* 235 */         id = ReferenceData.extractObjectId(this.poaCurrent.get_object_id());
/* 236 */         if ((this.traceEnabled) && (id != null)) {
/* 237 */           this.logger.trace("                      id class is " + id.getClass().getName());
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 242 */         this.logger.error("Error getting EJBObject id", e);
/* 243 */         throw new UnknownException(e);
/*     */       }
/*     */ 
/* 247 */       ENCFactory.pushContextId(this.containerName);
/*     */       org.omg.CORBA_2_3.portable.OutputStream out;
/*     */       try
/*     */       {
/*     */         java.lang.Object retVal;
/*     */         java.lang.Object retVal;
/* 254 */         if (opName.equals("_get_handle"))
/*     */         {
/* 256 */           EJBObject obj = (EJBObject)PortableRemoteObject.narrow(_this_object(), EJBObject.class);
/*     */ 
/* 258 */           retVal = new HandleImplIIOP(obj);
/*     */         }
/*     */         else
/*     */         {
/* 262 */           Transaction tx = null;
/* 263 */           if (this.inboundTxCurrent != null)
/* 264 */             tx = this.inboundTxCurrent.getCurrentTransaction();
/* 265 */           SimplePrincipal principal = null;
/* 266 */           char[] password = null;
/* 267 */           if (this.sasCurrent != null)
/*     */           {
/* 269 */             byte[] username = this.sasCurrent.get_incoming_username();
/* 270 */             byte[] credential = this.sasCurrent.get_incoming_password();
/* 271 */             String name = new String(username, "UTF-8");
/* 272 */             int domainIndex = name.indexOf('@');
/* 273 */             if (domainIndex > 0)
/* 274 */               name = name.substring(0, domainIndex);
/* 275 */             if (name.length() == 0)
/*     */             {
/* 277 */               byte[] incomingName = this.sasCurrent.get_incoming_principal_name();
/*     */ 
/* 279 */               if (incomingName.length > 0)
/*     */               {
/* 281 */                 name = new String(incomingName, "UTF-8");
/* 282 */                 domainIndex = name.indexOf('@');
/* 283 */                 if (domainIndex > 0)
/* 284 */                   name = name.substring(0, domainIndex);
/* 285 */                 principal = new SimplePrincipal(name);
/*     */ 
/* 288 */                 password = name.toCharArray();
/*     */               }
/*     */             }
/*     */             else
/*     */             {
/* 293 */               principal = new SimplePrincipal(name);
/* 294 */               password = new String(credential, "UTF-8").toCharArray();
/*     */             }
/*     */           }
/*     */ 
/* 298 */           java.lang.Object[] params = op.readParams((org.omg.CORBA_2_3.portable.InputStream)in);
/*     */ 
/* 300 */           Invocation inv = new Invocation(id, op.getMethod(), params, tx, principal, password);
/*     */ 
/* 306 */           inv.setValue(InvocationKey.INVOKER_PROXY_BINDING, "iiop", PayloadKey.AS_IS);
/*     */ 
/* 309 */           inv.setType(InvocationType.REMOTE);
/* 310 */           retVal = this.mbeanServer.invoke(this.containerName, "invoke", new java.lang.Object[] { inv }, Invocation.INVOKE_SIGNATURE);
/*     */         }
/*     */ 
/* 316 */         out = (org.omg.CORBA_2_3.portable.OutputStream)handler.createReply();
/*     */ 
/* 318 */         if (op.isNonVoid())
/*     */         {
/* 320 */           op.writeRetval(out, retVal);
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 325 */         if (this.traceEnabled)
/*     */         {
/* 327 */           this.logger.trace("Exception in EJBObject invocation", e);
/*     */         }
/* 329 */         if ((e instanceof MBeanException))
/*     */         {
/* 331 */           e = ((MBeanException)e).getTargetException();
/*     */         }
/* 333 */         RmiIdlUtil.rethrowIfCorbaSystemException(e);
/* 334 */         out = (org.omg.CORBA_2_3.portable.OutputStream)handler.createExceptionReply();
/*     */ 
/* 336 */         op.writeException(out, e);
/*     */       }
/* 338 */       e = out;
/*     */       return e;
/*     */     }
/*     */     finally
/*     */     {
/* 343 */       ENCFactory.popContextId();
/* 344 */       Thread.currentThread().setContextClassLoader(oldCl); } throw localObject1;
/*     */   }
/*     */ 
/*     */   public java.lang.Object invoke(String opName, java.lang.Object[] arguments, Transaction tx, Principal identity, java.lang.Object credential)
/*     */     throws Exception
/*     */   {
/* 363 */     if (this.traceEnabled)
/*     */     {
/* 365 */       this.logger.trace("EJBObject local invocation: " + opName);
/*     */     }
/*     */ 
/* 368 */     ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/* 369 */     Thread.currentThread().setContextClassLoader(this.containerClassLoader);
/*     */     try
/*     */     {
/* 373 */       SkeletonStrategy op = (SkeletonStrategy)this.methodInvokerMap.get(opName);
/* 374 */       if (op == null)
/*     */       {
/* 376 */         throw new BAD_OPERATION(opName);
/*     */       }
/*     */       java.lang.Object id;
/*     */       try
/*     */       {
/* 382 */         id = ReferenceData.extractObjectId(this.poaCurrent.get_object_id());
/* 383 */         if ((this.traceEnabled) && (id != null))
/*     */         {
/* 385 */           this.logger.trace("                      id class is " + id.getClass().getName());
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 391 */         this.logger.error("Error getting EJBObject id", e);
/* 392 */         throw new UnknownException(e);
/*     */       }
/*     */ 
/* 395 */       Invocation inv = new Invocation(id, op.getMethod(), arguments, tx, null, null);
/*     */ 
/* 401 */       inv.setValue(InvocationKey.INVOKER_PROXY_BINDING, "iiop", PayloadKey.AS_IS);
/*     */ 
/* 404 */       inv.setType(InvocationType.REMOTE);
/* 405 */       java.lang.Object localObject1 = this.mbeanServer.invoke(this.containerName, "invoke", new java.lang.Object[] { inv }, Invocation.INVOKE_SIGNATURE);
/*     */       return localObject1;
/*     */     }
/*     */     catch (MBeanException e)
/*     */     {
/* 412 */       throw e.getTargetException();
/*     */     }
/*     */     finally
/*     */     {
/* 416 */       Thread.currentThread().setContextClassLoader(oldCl); } throw localObject2;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.EjbObjectCorbaServant
 * JD-Core Version:    0.6.0
 */