/*     */ package org.jboss.proxy.ejb;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import java.util.Map;
/*     */ import javax.ejb.HomeHandle;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.iiop.CorbaORB;
/*     */ import org.jboss.iiop.csiv2.SASCurrent;
/*     */ import org.jboss.iiop.rmi.RmiIdlUtil;
/*     */ import org.jboss.iiop.rmi.marshal.strategy.SkeletonStrategy;
/*     */ import org.jboss.iiop.tm.InboundTransactionCurrent;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationKey;
/*     */ import org.jboss.invocation.InvocationType;
/*     */ import org.jboss.invocation.PayloadKey;
/*     */ import org.jboss.invocation.iiop.ServantWithMBeanServer;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.ENCFactory;
/*     */ import org.jboss.security.SimplePrincipal;
/*     */ import org.omg.CORBA.BAD_OPERATION;
/*     */ import org.omg.CORBA.InterfaceDef;
/*     */ import org.omg.CORBA.ORB;
/*     */ import org.omg.CORBA.ORBPackage.InvalidName;
/*     */ import org.omg.CORBA.portable.InvokeHandler;
/*     */ import org.omg.CORBA.portable.ResponseHandler;
/*     */ import org.omg.PortableServer.POA;
/*     */ 
/*     */ public class EjbHomeCorbaServant extends ServantWithMBeanServer
/*     */   implements InvokeHandler, LocalIIOPInvoker
/*     */ {
/*     */   private final ObjectName containerName;
/*     */   private final ClassLoader containerClassLoader;
/*     */   private final Map methodInvokerMap;
/*     */   private final String[] repositoryIds;
/*     */   private final InterfaceDef interfaceDef;
/*     */   private final Logger logger;
/*     */   private final boolean traceEnabled;
/* 109 */   private HomeHandle homeHandle = null;
/*     */   private MBeanServer mbeanServer;
/*     */   private SASCurrent sasCurrent;
/*     */   private InboundTransactionCurrent inboundTxCurrent;
/*     */ 
/*     */   public EjbHomeCorbaServant(ObjectName containerName, ClassLoader containerClassLoader, Map methodInvokerMap, String[] repositoryIds, InterfaceDef interfaceDef, Logger logger)
/*     */   {
/* 138 */     this.containerName = containerName;
/* 139 */     this.containerClassLoader = containerClassLoader;
/* 140 */     this.methodInvokerMap = methodInvokerMap;
/* 141 */     this.repositoryIds = repositoryIds;
/* 142 */     this.interfaceDef = interfaceDef;
/* 143 */     this.logger = logger;
/* 144 */     this.traceEnabled = logger.isTraceEnabled();
/*     */     try
/*     */     {
/* 147 */       this.sasCurrent = ((SASCurrent)CorbaORB.getInstance().resolve_initial_references("SASCurrent"));
/*     */     }
/*     */     catch (InvalidName invalidName)
/*     */     {
/* 152 */       this.sasCurrent = null;
/*     */     }
/*     */     try
/*     */     {
/* 156 */       this.inboundTxCurrent = ((InboundTransactionCurrent)CorbaORB.getInstance().resolve_initial_references("InboundTransactionCurrent"));
/*     */     }
/*     */     catch (InvalidName invalidName)
/*     */     {
/* 161 */       this.inboundTxCurrent = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setHomeHandle(HomeHandle homeHandle)
/*     */   {
/* 167 */     this.homeHandle = homeHandle;
/*     */   }
/*     */ 
/*     */   public void setMBeanServer(MBeanServer mbeanServer)
/*     */   {
/* 177 */     this.mbeanServer = mbeanServer;
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.Object _get_interface_def()
/*     */   {
/* 187 */     if (this.interfaceDef != null) {
/* 188 */       return this.interfaceDef;
/*     */     }
/* 190 */     return super._get_interface_def();
/*     */   }
/*     */ 
/*     */   public String[] _all_interfaces(POA poa, byte[] objectId)
/*     */   {
/* 201 */     return (String[])(String[])this.repositoryIds.clone();
/*     */   }
/*     */ 
/*     */   public org.omg.CORBA.portable.OutputStream _invoke(String opName, org.omg.CORBA.portable.InputStream in, ResponseHandler handler)
/*     */   {
/* 212 */     if (this.traceEnabled) {
/* 213 */       this.logger.trace("EJBHome invocation: " + opName);
/*     */     }
/*     */ 
/* 216 */     ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/* 217 */     Thread.currentThread().setContextClassLoader(this.containerClassLoader);
/*     */ 
/* 220 */     ENCFactory.pushContextId(this.containerName);
/*     */     try
/*     */     {
/* 224 */       SkeletonStrategy op = (SkeletonStrategy)this.methodInvokerMap.get(opName);
/* 225 */       if (op == null) {
/* 226 */         this.logger.debug("Unable to find opname '" + opName + "' valid operations:" + this.methodInvokerMap.keySet());
/* 227 */         throw new BAD_OPERATION(opName);
/*     */       }
/*     */       org.omg.CORBA_2_3.portable.OutputStream out;
/*     */       try
/*     */       {
/*     */         java.lang.Object retVal;
/*     */         java.lang.Object retVal;
/* 240 */         if (opName.equals("_get_homeHandle"))
/*     */         {
/* 242 */           retVal = this.homeHandle;
/*     */         }
/*     */         else
/*     */         {
/* 246 */           Transaction tx = null;
/* 247 */           if (this.inboundTxCurrent != null)
/* 248 */             tx = this.inboundTxCurrent.getCurrentTransaction();
/* 249 */           SimplePrincipal principal = null;
/* 250 */           char[] password = null;
/* 251 */           if (this.sasCurrent != null)
/*     */           {
/* 253 */             byte[] username = this.sasCurrent.get_incoming_username();
/* 254 */             byte[] credential = this.sasCurrent.get_incoming_password();
/* 255 */             String name = new String(username, "UTF-8");
/* 256 */             int domainIndex = name.indexOf('@');
/* 257 */             if (domainIndex > 0)
/* 258 */               name = name.substring(0, domainIndex);
/* 259 */             if (name.length() == 0)
/*     */             {
/* 261 */               byte[] incomingName = this.sasCurrent.get_incoming_principal_name();
/*     */ 
/* 263 */               if (incomingName.length > 0)
/*     */               {
/* 265 */                 name = new String(incomingName, "UTF-8");
/* 266 */                 domainIndex = name.indexOf('@');
/* 267 */                 if (domainIndex > 0)
/* 268 */                   name = name.substring(0, domainIndex);
/* 269 */                 principal = new SimplePrincipal(name);
/*     */ 
/* 272 */                 password = name.toCharArray();
/*     */               }
/*     */             }
/*     */             else
/*     */             {
/* 277 */               principal = new SimplePrincipal(name);
/* 278 */               password = new String(credential, "UTF-8").toCharArray();
/*     */             }
/*     */           }
/*     */ 
/* 282 */           java.lang.Object[] params = op.readParams((org.omg.CORBA_2_3.portable.InputStream)in);
/*     */ 
/* 284 */           Invocation inv = new Invocation(null, op.getMethod(), params, tx, principal, password);
/*     */ 
/* 290 */           inv.setValue(InvocationKey.INVOKER_PROXY_BINDING, "iiop", PayloadKey.AS_IS);
/*     */ 
/* 293 */           inv.setType(InvocationType.HOME);
/* 294 */           retVal = this.mbeanServer.invoke(this.containerName, "invoke", new java.lang.Object[] { inv }, Invocation.INVOKE_SIGNATURE);
/*     */         }
/*     */ 
/* 299 */         out = (org.omg.CORBA_2_3.portable.OutputStream)handler.createReply();
/*     */ 
/* 301 */         if (op.isNonVoid())
/* 302 */           op.writeRetval(out, retVal);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 306 */         if (this.traceEnabled) {
/* 307 */           this.logger.trace("Exception in EJBHome invocation", e);
/*     */         }
/* 309 */         if ((e instanceof MBeanException)) {
/* 310 */           e = ((MBeanException)e).getTargetException();
/*     */         }
/* 312 */         RmiIdlUtil.rethrowIfCorbaSystemException(e);
/* 313 */         out = (org.omg.CORBA_2_3.portable.OutputStream)handler.createExceptionReply();
/*     */ 
/* 315 */         op.writeException(out, e);
/*     */       }
/* 317 */       e = out;
/*     */       return e;
/*     */     }
/*     */     finally
/*     */     {
/* 321 */       ENCFactory.popContextId();
/* 322 */       Thread.currentThread().setContextClassLoader(oldCl); } throw localObject1;
/*     */   }
/*     */ 
/*     */   public java.lang.Object invoke(String opName, java.lang.Object[] arguments, Transaction tx, Principal identity, java.lang.Object credential)
/*     */     throws Exception
/*     */   {
/* 339 */     if (this.traceEnabled) {
/* 340 */       this.logger.trace("EJBHome local invocation: " + opName);
/*     */     }
/*     */ 
/* 343 */     ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/* 344 */     Thread.currentThread().setContextClassLoader(this.containerClassLoader);
/*     */     try
/*     */     {
/* 347 */       SkeletonStrategy op = (SkeletonStrategy)this.methodInvokerMap.get(opName);
/*     */ 
/* 349 */       if (op == null) {
/* 350 */         throw new BAD_OPERATION(opName);
/*     */       }
/*     */ 
/* 353 */       Invocation inv = new Invocation(null, op.getMethod(), arguments, tx, null, null);
/*     */ 
/* 359 */       inv.setValue(InvocationKey.INVOKER_PROXY_BINDING, "iiop", PayloadKey.AS_IS);
/*     */ 
/* 362 */       inv.setType(InvocationType.HOME);
/* 363 */       java.lang.Object localObject1 = this.mbeanServer.invoke(this.containerName, "invoke", new java.lang.Object[] { inv }, Invocation.INVOKE_SIGNATURE);
/*     */       return localObject1;
/*     */     }
/*     */     catch (MBeanException e)
/*     */     {
/* 369 */       throw e.getTargetException();
/*     */     }
/*     */     finally {
/* 372 */       Thread.currentThread().setContextClassLoader(oldCl); } throw localObject2;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.ejb.EjbHomeCorbaServant
 * JD-Core Version:    0.6.0
 */