/*     */ package org.jboss.proxy.compiler;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ 
/*     */ public class Runtime extends ClassLoader
/*     */ {
/*     */   public static final String RUNTIME_FN = "runtime";
/*     */   Class[] targetTypes;
/*     */   Method[] methods;
/*     */   ProxyCompiler compiler;
/*     */ 
/*     */   public Runtime(ClassLoader parent)
/*     */   {
/*  57 */     super(parent);
/*     */   }
/*     */ 
/*     */   public Class[] copyTargetTypes()
/*     */   {
/*  70 */     return (Class[])(Class[])this.targetTypes.clone();
/*     */   }
/*     */ 
/*     */   public Object invoke(InvocationHandler invocationHandler, int methodNum, Object[] values)
/*     */     throws Throwable
/*     */   {
/*  76 */     return invocationHandler.invoke(null, this.methods[methodNum], values);
/*     */   }
/*     */ 
/*     */   void makeProxyType(ProxyCompiler compiler)
/*     */     throws Exception
/*     */   {
/*  82 */     this.compiler = compiler;
/*  83 */     byte[] code = compiler.getCode();
/*     */ 
/*  85 */     compiler.proxyType = super.defineClass(compiler.getProxyClassName(), code, 0, code.length);
/*  86 */     super.resolveClass(compiler.proxyType);
/*     */ 
/*  89 */     Field field = compiler.proxyType.getField("runtime");
/*  90 */     field.set(null, this);
/*     */ 
/*  92 */     compiler = null;
/*     */   }
/*     */ 
/*     */   ClassLoader getTargetClassLoader()
/*     */   {
/*  97 */     PrivilegedAction action = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/* 101 */         return Runtime.this.getParent();
/*     */       }
/*     */     };
/* 104 */     return (ClassLoader)AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   public synchronized Class loadClass(String name, boolean resolve)
/*     */     throws ClassNotFoundException
/*     */   {
/* 111 */     if ((name.endsWith("$Proxy")) && (name.equals(this.compiler.getProxyClassName())))
/*     */     {
/* 113 */       return this.compiler.proxyType;
/*     */     }
/*     */ 
/* 117 */     ClassLoader cl = getTargetClassLoader();
/* 118 */     if (cl == null)
/*     */     {
/* 120 */       return super.findSystemClass(name);
/*     */     }
/*     */ 
/* 123 */     return cl.loadClass(name);
/*     */   }
/*     */ 
/*     */   public InputStream getResourceAsStream(String name)
/*     */   {
/* 131 */     ClassLoader cl = getTargetClassLoader();
/*     */ 
/* 133 */     if (cl == null)
/*     */     {
/* 135 */       return ClassLoader.getSystemResourceAsStream(name);
/*     */     }
/*     */ 
/* 138 */     return cl.getResourceAsStream(name);
/*     */   }
/*     */ 
/*     */   public URL getResource(String name)
/*     */   {
/* 146 */     ClassLoader cl = getTargetClassLoader();
/*     */ 
/* 148 */     if (cl == null)
/*     */     {
/* 150 */       return ClassLoader.getSystemResource(name);
/*     */     }
/*     */ 
/* 153 */     return cl.getResource(name);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.compiler.Runtime
 * JD-Core Version:    0.6.0
 */