/*     */ package org.jboss.proxy.compiler;
/*     */ 
/*     */ import org.apache.bcel.classfile.Field;
/*     */ import org.apache.bcel.classfile.Method;
/*     */ import org.apache.bcel.generic.ArrayType;
/*     */ import org.apache.bcel.generic.BasicType;
/*     */ import org.apache.bcel.generic.ClassGen;
/*     */ import org.apache.bcel.generic.ConstantPoolGen;
/*     */ import org.apache.bcel.generic.FieldGen;
/*     */ import org.apache.bcel.generic.InstructionFactory;
/*     */ import org.apache.bcel.generic.InstructionList;
/*     */ import org.apache.bcel.generic.MethodGen;
/*     */ import org.apache.bcel.generic.ObjectType;
/*     */ import org.apache.bcel.generic.PUSH;
/*     */ import org.apache.bcel.generic.ReferenceType;
/*     */ import org.apache.bcel.generic.Type;
/*     */ 
/*     */ public class ProxyImplementationFactory
/*     */ {
/*  53 */   private static final String RUNTIME_CN = Runtime.class.getName();
/*  54 */   private static final String INVOCATION_HANDLER_CN = InvocationHandler.class.getName();
/*  55 */   private static final String STRING_BUFFER_CN = StringBuffer.class.getName();
/*     */ 
/*  58 */   private static final ObjectType RUNTIME_T = (ObjectType)Utility.getType(Runtime.class);
/*  59 */   private static final ObjectType INVOCATION_HANDLER_T = (ObjectType)Utility.getType(InvocationHandler.class);
/*  60 */   private static final ArrayType ARRAY_OF_CLASS_T = new ArrayType("java.lang.Class", 1);
/*  61 */   private static final ObjectType OBJECT_T = new ObjectType("java.lang.Object");
/*  62 */   private static final ArrayType ARRAY_OF_OBJECT_T = new ArrayType("java.lang.Object", 1);
/*  63 */   private static final ObjectType STRING_T = new ObjectType("java.lang.String");
/*  64 */   private static final ObjectType STRING_BUFFER_T = new ObjectType("java.lang.StringBuffer");
/*  65 */   private static final ObjectType PROXY_TARGET_T = new ObjectType(Proxies.ProxyTarget.class.getName());
/*  66 */   private static final Type[] INVOKE_ARGS = { INVOCATION_HANDLER_T, Type.INT, ARRAY_OF_OBJECT_T };
/*     */   private static final String GET_INVOCATION_HANDLER_MN = "getInvocationHandler";
/*     */   private static final String GET_TARGET_TYPES_MN = "getTargetTypes";
/*     */   private static final String TO_STRING_MN = "toString";
/*     */   private static final String APPEND_MN = "append";
/*     */   private static final String CTOR_MN = "<init>";
/*     */   private static final String INVOCATION_HANDLER_FN = "invocationHandler";
/*     */   private static Type PROXY_CLASS_T;
/*  82 */   private InstructionList il = new InstructionList();
/*     */   private String proxyClassName;
/*     */   private String superClassName;
/*     */   private ConstantPoolGen constPool;
/*     */   private InstructionFactory iFactory;
/*     */ 
/*     */   public ProxyImplementationFactory(String superClassName, String proxyClassName, ClassGen cg)
/*     */   {
/*  99 */     this.superClassName = superClassName;
/* 100 */     this.proxyClassName = proxyClassName;
/*     */ 
/* 102 */     PROXY_CLASS_T = new ObjectType(proxyClassName);
/* 103 */     this.constPool = cg.getConstantPool();
/* 104 */     this.iFactory = new InstructionFactory(cg, this.constPool);
/*     */   }
/*     */ 
/*     */   public Method createGetInvocationHandler()
/*     */   {
/* 121 */     MethodGen mg = new MethodGen(1, INVOCATION_HANDLER_T, Type.NO_ARGS, null, "getInvocationHandler", this.proxyClassName, this.il, this.constPool);
/*     */ 
/* 126 */     this.il.append(InstructionFactory.createLoad(PROXY_CLASS_T, 0));
/* 127 */     this.il.append(this.iFactory.createGetField(this.proxyClassName, "invocationHandler", INVOCATION_HANDLER_T));
/* 128 */     this.il.append(InstructionFactory.createReturn(INVOCATION_HANDLER_T));
/*     */ 
/* 130 */     mg.stripAttributes(true);
/* 131 */     mg.setMaxStack();
/* 132 */     mg.setMaxLocals();
/*     */ 
/* 134 */     return getMethodAndTidyup(mg);
/*     */   }
/*     */ 
/*     */   public Method createGetTargetTypes()
/*     */   {
/* 154 */     MethodGen mg = new MethodGen(1, ARRAY_OF_CLASS_T, Type.NO_ARGS, null, "getTargetTypes", this.proxyClassName, this.il, this.constPool);
/*     */ 
/* 163 */     this.il.append(InstructionFactory.createLoad(PROXY_CLASS_T, 0));
/* 164 */     this.il.append(this.iFactory.createGetField(this.proxyClassName, "runtime", RUNTIME_T));
/* 165 */     this.il.append(this.iFactory.createInvoke(RUNTIME_CN, "copyTargetTypes", ARRAY_OF_CLASS_T, Type.NO_ARGS, 182));
/*     */ 
/* 171 */     this.il.append(InstructionFactory.createReturn(ARRAY_OF_CLASS_T));
/*     */ 
/* 173 */     mg.stripAttributes(true);
/* 174 */     mg.setMaxStack(1);
/* 175 */     mg.setMaxLocals();
/*     */ 
/* 177 */     return getMethodAndTidyup(mg);
/*     */   }
/*     */ 
/*     */   public Method createToString()
/*     */   {
/* 197 */     MethodGen mg = new MethodGen(1, STRING_T, Type.NO_ARGS, null, "toString", this.proxyClassName, this.il, this.constPool);
/*     */ 
/* 201 */     this.il.append(this.iFactory.createNew(STRING_BUFFER_T));
/* 202 */     this.il.append(InstructionFactory.createDup(1));
/* 203 */     this.il.append(this.iFactory.createInvoke(STRING_BUFFER_CN, "<init>", Type.VOID, Type.NO_ARGS, 183));
/*     */ 
/* 208 */     this.il.append(new PUSH(this.constPool, "ProxyTarget["));
/* 209 */     this.il.append(this.iFactory.createInvoke(STRING_BUFFER_CN, "append", STRING_BUFFER_T, new Type[] { STRING_T }, 182));
/*     */ 
/* 214 */     this.il.append(InstructionFactory.createLoad(PROXY_CLASS_T, 0));
/* 215 */     this.il.append(this.iFactory.createGetField(this.proxyClassName, "invocationHandler", INVOCATION_HANDLER_T));
/* 216 */     this.il.append(this.iFactory.createInvoke(STRING_BUFFER_CN, "append", STRING_BUFFER_T, new Type[] { OBJECT_T }, 182));
/*     */ 
/* 221 */     this.il.append(new PUSH(this.constPool, "]"));
/* 222 */     this.il.append(this.iFactory.createInvoke(STRING_BUFFER_CN, "append", STRING_BUFFER_T, new Type[] { STRING_T }, 182));
/*     */ 
/* 227 */     this.il.append(this.iFactory.createInvoke(STRING_BUFFER_CN, "toString", STRING_T, Type.NO_ARGS, 182));
/*     */ 
/* 232 */     this.il.append(InstructionFactory.createReturn(STRING_T));
/*     */ 
/* 234 */     mg.stripAttributes(true);
/* 235 */     mg.setMaxStack();
/* 236 */     mg.setMaxLocals();
/*     */ 
/* 238 */     return getMethodAndTidyup(mg);
/*     */   }
/*     */ 
/*     */   public Method createConstructor()
/*     */   {
/* 258 */     MethodGen mg = new MethodGen(1, Type.VOID, new Type[] { INVOCATION_HANDLER_T }, null, "<init>", this.proxyClassName, this.il, this.constPool);
/*     */ 
/* 267 */     this.il.append(InstructionFactory.createLoad(INVOCATION_HANDLER_T, 0));
/* 268 */     this.il.append(this.iFactory.createInvoke(this.superClassName, "<init>", Type.VOID, Type.NO_ARGS, 183));
/*     */ 
/* 273 */     this.il.append(InstructionFactory.createLoad(PROXY_CLASS_T, 0));
/* 274 */     this.il.append(InstructionFactory.createLoad(INVOCATION_HANDLER_T, 1));
/* 275 */     this.il.append(this.iFactory.createPutField(this.proxyClassName, "invocationHandler", INVOCATION_HANDLER_T));
/* 276 */     this.il.append(InstructionFactory.createReturn(Type.VOID));
/*     */ 
/* 278 */     mg.stripAttributes(true);
/* 279 */     mg.setMaxStack();
/* 280 */     mg.setMaxLocals();
/*     */ 
/* 282 */     return getMethodAndTidyup(mg);
/*     */   }
/*     */ 
/*     */   public Method createProxyMethod(String name, int methodNum, Type rType, Type[] pTypes, String[] exceptionNames)
/*     */   {
/* 308 */     MethodGen mg = new MethodGen(1, rType, pTypes, null, name, this.proxyClassName, this.il, this.constPool);
/*     */ 
/* 317 */     for (int j = 0; j < exceptionNames.length; j++) {
/* 318 */       mg.addException(exceptionNames[j]);
/*     */     }
/*     */ 
/* 322 */     this.il.append(this.iFactory.createGetStatic(this.proxyClassName, "runtime", RUNTIME_T));
/* 323 */     this.il.append(InstructionFactory.createLoad(RUNTIME_T, 0));
/*     */ 
/* 326 */     this.il.append(this.iFactory.createGetField(this.proxyClassName, "invocationHandler", INVOCATION_HANDLER_T));
/*     */ 
/* 329 */     this.il.append(new PUSH(this.constPool, methodNum));
/*     */ 
/* 332 */     this.il.append(new PUSH(this.constPool, pTypes.length));
/* 333 */     this.il.append(this.iFactory.createNewArray(OBJECT_T, 1));
/*     */ 
/* 335 */     if (pTypes.length > 0)
/*     */     {
/* 337 */       int i = 1;
/*     */ 
/* 339 */       for (int j = 0; j < pTypes.length; j++) {
/* 340 */         Type t = pTypes[j];
/*     */ 
/* 343 */         this.il.append(InstructionFactory.createDup(1));
/*     */ 
/* 346 */         this.il.append(new PUSH(this.constPool, j));
/*     */ 
/* 349 */         if ((t instanceof BasicType))
/*     */         {
/* 351 */           String wrappedClassName = Utility.getObjectEquivalentClassName((BasicType)t);
/* 352 */           ObjectType wrappedType = new ObjectType(wrappedClassName);
/* 353 */           this.il.append(this.iFactory.createNew(wrappedType));
/*     */ 
/* 356 */           this.il.append(InstructionFactory.createDup(1));
/*     */ 
/* 359 */           this.il.append(InstructionFactory.createLoad(t, i));
/* 360 */           this.il.append(this.iFactory.createInvoke(wrappedClassName, "<init>", Type.VOID, new Type[] { t }, 183));
/*     */ 
/* 367 */           switch (t.getType()) {
/*     */           case 7:
/*     */           case 11:
/* 370 */             i++;
/*     */           }
/*     */ 
/* 374 */           t = wrappedType;
/*     */         }
/*     */         else
/*     */         {
/* 378 */           this.il.append(InstructionFactory.createLoad(t, i));
/*     */         }
/*     */ 
/* 383 */         i++;
/*     */ 
/* 386 */         this.il.append(InstructionFactory.createArrayStore(t));
/*     */       }
/*     */     }
/*     */ 
/* 390 */     this.il.append(this.iFactory.createInvoke(RUNTIME_CN, "invoke", Type.OBJECT, INVOKE_ARGS, 182));
/*     */ 
/* 397 */     if ((rType instanceof ReferenceType)) {
/* 398 */       this.il.append(this.iFactory.createCheckCast((ReferenceType)rType));
/*     */     }
/* 400 */     else if ((rType instanceof BasicType)) {
/* 401 */       if (rType == Type.VOID)
/*     */       {
/* 403 */         this.il.append(InstructionFactory.createPop(1));
/*     */       }
/*     */       else
/*     */       {
/* 409 */         String wrappedClassName = Utility.getObjectEquivalentClassName((BasicType)rType);
/* 410 */         ObjectType wrappedType = new ObjectType(wrappedClassName);
/* 411 */         this.il.append(this.iFactory.createCheckCast(wrappedType));
/*     */ 
/* 413 */         String methodName = Utility.signatureToString(rType.getSignature()) + "Value";
/*     */ 
/* 415 */         this.il.append(this.iFactory.createInvoke(wrappedClassName, methodName, rType, Type.NO_ARGS, 182));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 423 */     this.il.append(InstructionFactory.createReturn(rType));
/*     */ 
/* 425 */     mg.stripAttributes(true);
/* 426 */     mg.setMaxStack();
/* 427 */     mg.setMaxLocals();
/*     */ 
/* 429 */     return getMethodAndTidyup(mg);
/*     */   }
/*     */ 
/*     */   public Field createInvocationHandlerField()
/*     */   {
/* 447 */     FieldGen fg = new FieldGen(2, INVOCATION_HANDLER_T, "invocationHandler", this.constPool);
/*     */ 
/* 451 */     return fg.getField();
/*     */   }
/*     */ 
/*     */   public Field createRuntimeField()
/*     */   {
/* 469 */     FieldGen fg = new FieldGen(9, RUNTIME_T, "runtime", this.constPool);
/*     */ 
/* 473 */     return fg.getField();
/*     */   }
/*     */ 
/*     */   private Method getMethodAndTidyup(MethodGen mg)
/*     */   {
/* 482 */     Method m = mg.getMethod();
/* 483 */     this.il.dispose();
/*     */ 
/* 485 */     return m;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.compiler.ProxyImplementationFactory
 * JD-Core Version:    0.6.0
 */