/*     */ package org.jboss.proxy.compiler;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import org.jboss.iiop.rmi.AttributeAnalysis;
/*     */ import org.jboss.iiop.rmi.ExceptionAnalysis;
/*     */ import org.jboss.iiop.rmi.InterfaceAnalysis;
/*     */ import org.jboss.iiop.rmi.OperationAnalysis;
/*     */ import org.jboss.iiop.rmi.RMIIIOPViolationException;
/*     */ import org.jboss.iiop.rmi.marshal.CDRStream;
/*     */ import org.jboss.iiop.rmi.marshal.strategy.StubStrategy;
/*     */ import org.jboss.proxy.ejb.DynamicIIOPStub;
/*     */ 
/*     */ public class IIOPStubCompiler
/*     */ {
/*  56 */   private static final Class[] stubStrategyParams = { [Ljava.lang.String.class, [Ljava.lang.String.class, [Ljava.lang.String.class, String.class, ClassLoader.class };
/*     */ 
/*  65 */   private static final Class[] invokeParams = { String.class, StubStrategy.class, [Ljava.lang.Object.class };
/*     */ 
/*  73 */   private static final Class[] corbaObjectParam = { org.omg.CORBA.Object.class };
/*     */ 
/*  80 */   private static final Class[] stringParam = { String.class };
/*     */ 
/*  87 */   private static final Class[] noParams = new Class[0];
/*     */ 
/*     */   private static String strategy(int methodIndex)
/*     */   {
/*  96 */     return "$s" + methodIndex;
/*     */   }
/*     */ 
/*     */   private static String init(int methodIndex)
/*     */   {
/* 104 */     return "$i" + methodIndex;
/*     */   }
/*     */ 
/*     */   private static void generateMethodCode(ProxyAssembler asm, Class superclass, Method m, String idlName, String strategyField, String initMethod)
/*     */   {
/* 130 */     String methodName = m.getName();
/* 131 */     Class returnType = m.getReturnType();
/* 132 */     Class[] paramTypes = m.getParameterTypes();
/* 133 */     Class[] exceptions = m.getExceptionTypes();
/*     */ 
/* 136 */     asm.addMember(10, StubStrategy.class, null, strategyField);
/*     */ 
/* 140 */     asm.addMember(17, returnType, methodName, paramTypes, exceptions);
/*     */ 
/* 145 */     asm.pushLocal(0);
/* 146 */     asm.pushConstant(idlName);
/* 147 */     asm.pushField(asm, strategyField);
/*     */ 
/* 149 */     if (paramTypes.length == 0) {
/* 150 */       asm.pushField(Util.class, "NOARGS");
/*     */     } else {
/* 152 */       asm.pushConstant(paramTypes.length);
/* 153 */       asm.pushNewArray(java.lang.Object.class);
/* 154 */       for (int j = 0; j < paramTypes.length; j++) {
/* 155 */         Class t = paramTypes[j];
/* 156 */         asm.dup();
/* 157 */         asm.pushConstant(j);
/* 158 */         asm.pushLocal(1 + j);
/* 159 */         if (t.isPrimitive()) {
/* 160 */           asm.invoke(Util.class, "wrap", new Class[] { t });
/*     */         }
/* 162 */         asm.setElement(java.lang.Object.class);
/*     */       }
/*     */     }
/*     */ 
/* 166 */     String invoke = "invoke";
/* 167 */     if ((returnType.isPrimitive()) && (returnType != Void.TYPE)) {
/* 168 */       String typeName = returnType.getName();
/* 169 */       invoke = invoke + Character.toUpperCase(typeName.charAt(0)) + typeName.substring(1);
/*     */     }
/*     */ 
/* 172 */     asm.invoke(superclass, invoke, invokeParams);
/* 173 */     if ((!returnType.isPrimitive()) && (returnType != java.lang.Object.class)) {
/* 174 */       asm.checkCast(returnType);
/*     */     }
/* 176 */     asm.ret();
/*     */ 
/* 180 */     asm.addMember(10, Void.TYPE, initMethod, noParams, null);
/*     */ 
/* 188 */     int len = paramTypes.length;
/* 189 */     asm.pushConstant(len);
/* 190 */     asm.pushNewArray(String.class);
/* 191 */     for (int i = 0; i < len; i++) {
/* 192 */       asm.dup();
/* 193 */       asm.pushConstant(i);
/* 194 */       asm.pushConstant(CDRStream.abbrevFor(paramTypes[i]));
/* 195 */       asm.setElement(String.class);
/*     */     }
/*     */ 
/* 200 */     len = exceptions.length;
/* 201 */     int n = 0;
/* 202 */     for (i = 0; i < len; i++) {
/* 203 */       if (!RemoteException.class.isAssignableFrom(exceptions[i])) {
/* 204 */         n++;
/*     */       }
/*     */     }
/* 207 */     asm.pushConstant(n);
/* 208 */     asm.pushNewArray(String.class);
/*     */     try {
/* 210 */       int j = 0;
/* 211 */       for (i = 0; i < len; i++)
/* 212 */         if (!RemoteException.class.isAssignableFrom(exceptions[i])) {
/* 213 */           asm.dup();
/* 214 */           asm.pushConstant(j);
/* 215 */           asm.pushConstant(ExceptionAnalysis.getExceptionAnalysis(exceptions[i]).getExceptionRepositoryId());
/*     */ 
/* 218 */           asm.setElement(String.class);
/* 219 */           j++;
/*     */         }
/*     */     }
/*     */     catch (RMIIIOPViolationException e)
/*     */     {
/* 224 */       throw new RuntimeException("Cannot obtain exception repository id for " + exceptions[i].getName() + ":\n" + e);
/*     */     }
/*     */ 
/* 231 */     asm.pushConstant(n);
/* 232 */     asm.pushNewArray(String.class);
/* 233 */     int j = 0;
/* 234 */     for (i = 0; i < len; i++) {
/* 235 */       if (!RemoteException.class.isAssignableFrom(exceptions[i])) {
/* 236 */         asm.dup();
/* 237 */         asm.pushConstant(j);
/* 238 */         asm.pushConstant(exceptions[i].getName());
/* 239 */         asm.setElement(String.class);
/* 240 */         j++;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 246 */     asm.pushConstant(CDRStream.abbrevFor(returnType));
/*     */ 
/* 250 */     asm.pushField(Util.class, "NULLCL");
/*     */ 
/* 253 */     asm.invoke(StubStrategy.class, "forMethod", stubStrategyParams);
/*     */ 
/* 256 */     asm.setField(asm, strategyField);
/*     */ 
/* 258 */     asm.ret();
/*     */   }
/*     */ 
/*     */   private static byte[] generateCode(InterfaceAnalysis interfaceAnalysis, Class superclass, String stubClassName)
/*     */   {
/* 275 */     ProxyAssembler asm = new ProxyAssembler(stubClassName, 17, superclass, new Class[] { interfaceAnalysis.getCls() });
/*     */ 
/* 281 */     int methodIndex = 0;
/*     */ 
/* 283 */     AttributeAnalysis[] attrs = interfaceAnalysis.getAttributes();
/* 284 */     for (int i = 0; i < attrs.length; i++) {
/* 285 */       OperationAnalysis op = attrs[i].getAccessorAnalysis();
/* 286 */       generateMethodCode(asm, superclass, op.getMethod(), op.getIDLName(), strategy(methodIndex), init(methodIndex));
/*     */ 
/* 288 */       methodIndex++;
/* 289 */       op = attrs[i].getMutatorAnalysis();
/* 290 */       if (op != null) {
/* 291 */         generateMethodCode(asm, superclass, op.getMethod(), op.getIDLName(), strategy(methodIndex), init(methodIndex));
/*     */ 
/* 294 */         methodIndex++;
/*     */       }
/*     */     }
/*     */ 
/* 298 */     OperationAnalysis[] ops = interfaceAnalysis.getOperations();
/* 299 */     for (int i = 0; i < ops.length; i++) {
/* 300 */       generateMethodCode(asm, superclass, ops[i].getMethod(), ops[i].getIDLName(), strategy(methodIndex), init(methodIndex));
/*     */ 
/* 303 */       methodIndex++;
/*     */     }
/*     */ 
/* 307 */     asm.addMember(1, Void.TYPE, "<init>", noParams, null);
/*     */ 
/* 309 */     asm.pushLocal(0);
/* 310 */     asm.invoke(superclass, "<init>", noParams);
/* 311 */     asm.ret();
/*     */ 
/* 315 */     String[] ids = interfaceAnalysis.getAllTypeIds();
/* 316 */     asm.addMember(10, [Ljava.lang.String.class, null, "$ids");
/*     */ 
/* 318 */     asm.addMember(17, [Ljava.lang.String.class, "_ids", noParams, null);
/*     */ 
/* 321 */     asm.pushField(asm, "$ids");
/* 322 */     asm.ret();
/*     */ 
/* 326 */     asm.addMember(8, Void.TYPE, "<clinit>", noParams, null);
/*     */ 
/* 332 */     asm.pushConstant(ids.length);
/* 333 */     asm.pushNewArray(String.class);
/* 334 */     for (int i = 0; i < ids.length; i++) {
/* 335 */       asm.dup();
/* 336 */       asm.pushConstant(i);
/* 337 */       asm.pushConstant(ids[i]);
/* 338 */       asm.setElement(String.class);
/*     */     }
/* 340 */     asm.setField(asm, "$ids");
/*     */ 
/* 342 */     int n = methodIndex;
/* 343 */     for (methodIndex = 0; methodIndex < n; methodIndex++) {
/* 344 */       asm.invoke(asm, init(methodIndex), noParams);
/*     */     }
/*     */ 
/* 351 */     asm.ret();
/*     */ 
/* 354 */     return asm.getCode();
/*     */   }
/*     */ 
/*     */   private static byte[] makeCode(InterfaceAnalysis interfaceAnalysis, Class superclass, String stubClassName)
/*     */   {
/* 371 */     byte[] code = generateCode(interfaceAnalysis, superclass, stubClassName);
/*     */ 
/* 383 */     return code;
/*     */   }
/*     */ 
/*     */   public static byte[] compile(Class intf, String stubClassName)
/*     */   {
/* 398 */     InterfaceAnalysis interfaceAnalysis = null;
/*     */     try
/*     */     {
/* 401 */       interfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(intf);
/*     */     }
/*     */     catch (RMIIIOPViolationException e) {
/* 404 */       throw new RuntimeException("RMI/IIOP Violation:\n" + e);
/*     */     }
/* 406 */     return makeCode(interfaceAnalysis, DynamicIIOPStub.class, stubClassName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.compiler.IIOPStubCompiler
 * JD-Core Version:    0.6.0
 */