/*     */ package org.jboss.proxy;
/*     */ 
/*     */ import java.security.Principal;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.security.RunAs;
/*     */ import org.jboss.security.SecurityContext;
/*     */ 
/*     */ public class SecurityInterceptor extends Interceptor
/*     */ {
/*     */   private static final long serialVersionUID = -4206940878404525061L;
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/*  56 */     SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
/*     */ 
/*  58 */     Principal principal = sa.getPrincipal();
/*  59 */     if (principal != null)
/*     */     {
/*  61 */       invocation.setPrincipal(principal);
/*     */     }
/*     */ 
/*  64 */     Object credential = sa.getCredential();
/*  65 */     if (credential != null)
/*     */     {
/*  67 */       invocation.setCredential(credential);
/*     */     }
/*     */ 
/*  70 */     SecurityContext sc = sa.getSecurityContext();
/*  71 */     RunAs callerRAI = sa.getCallerRunAsIdentity();
/*  72 */     SecurityContext newSc = createSecurityContext(invocation);
/*     */ 
/*  74 */     if (callerRAI != null)
/*     */     {
/*  76 */       newSc.setOutgoingRunAs(callerRAI);
/*  77 */       newSc.setIncomingRunAs(callerRAI);
/*     */     }
/*     */ 
/*  82 */     invocation.setSecurityContext(newSc);
/*     */     try
/*     */     {
/*  86 */       localObject1 = getNext().invoke(invocation);
/*     */     }
/*     */     finally
/*     */     {
/*     */       Object localObject1;
/*  90 */       if (sc != null)
/*  91 */         sa.setSecurityContext(sc);
/*     */     }
/*     */   }
/*     */ 
/*     */   private SecurityContext createSecurityContext(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 102 */     SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
/*     */ 
/* 105 */     Principal p = invocation.getPrincipal();
/* 106 */     Object cred = invocation.getCredential();
/*     */ 
/* 110 */     return sa.createSecurityContext(p, cred, "CLIENT_PROXY");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.proxy.SecurityInterceptor
 * JD-Core Version:    0.6.0
 */