/*     */ package org.jboss.profileservice.spi;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class ProfileKey
/*     */   implements Comparable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   public static final String DEFAULT = "default";
/*     */   private String domain;
/*     */   private String server;
/*     */   private String name;
/*     */ 
/*     */   public ProfileKey(String name)
/*     */   {
/*  31 */     this("default", "default", name);
/*     */   }
/*     */ 
/*     */   public ProfileKey(String domain, String server, String name)
/*     */   {
/*  44 */     if (domain == null)
/*  45 */       domain = "default";
/*  46 */     this.domain = domain;
/*  47 */     if (server == null)
/*  48 */       server = "default";
/*  49 */     this.server = server;
/*  50 */     if (name == null)
/*  51 */       name = "default";
/*  52 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  57 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name) {
/*  61 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getDomain()
/*     */   {
/*  66 */     return this.domain;
/*     */   }
/*     */ 
/*     */   public void setDomain(String domain) {
/*  70 */     this.domain = domain;
/*     */   }
/*     */ 
/*     */   public String getServer()
/*     */   {
/*  75 */     return this.server;
/*     */   }
/*     */ 
/*     */   public void setServer(String server) {
/*  79 */     this.server = server;
/*     */   }
/*     */ 
/*     */   public int compareTo(Object o)
/*     */   {
/*  91 */     ProfileKey pk = (ProfileKey)o;
/*  92 */     int compareTo = this.domain.compareTo(pk.domain);
/*  93 */     if (compareTo == 0)
/*     */     {
/*  95 */       compareTo = this.server.compareTo(pk.server);
/*  96 */       if (compareTo == 0)
/*     */       {
/*  98 */         compareTo = this.name.compareTo(pk.name);
/*     */       }
/*     */     }
/* 101 */     return compareTo;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o) {
/* 105 */     return compareTo(o) == 0;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 109 */     int hash = this.domain.hashCode() + this.server.hashCode() + this.name.hashCode();
/* 110 */     return hash;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 115 */     StringBuilder tmp = new StringBuilder(super.toString());
/* 116 */     tmp.append('[');
/* 117 */     tmp.append("domain=");
/* 118 */     tmp.append(this.domain);
/* 119 */     tmp.append(",server=");
/* 120 */     tmp.append(this.server);
/* 121 */     tmp.append(",name=");
/* 122 */     tmp.append(this.name);
/* 123 */     tmp.append(']');
/* 124 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.spi.ProfileKey
 * JD-Core Version:    0.6.0
 */