package org.jboss.profileservice.spi;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import java.util.zip.ZipInputStream;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;

public abstract interface DeploymentRepository
{
  public abstract void create()
    throws Exception;

  public abstract void load()
    throws Exception;

  public abstract void remove()
    throws Exception;

  public abstract URI getDeploymentURI(ManagedDeployment.DeploymentPhase paramDeploymentPhase);

  public abstract void setDeploymentURI(URI paramURI, ManagedDeployment.DeploymentPhase paramDeploymentPhase);

  public abstract Set<String> getDeploymentNames();

  public abstract Set<String> getDeploymentNames(ManagedDeployment.DeploymentPhase paramDeploymentPhase);

  public abstract Set<String> getDeploymentNamesForType(String paramString);

  public abstract void addDeploymentContent(String paramString, ZipInputStream paramZipInputStream, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws IOException;

  public abstract void addDeployment(String paramString, VFSDeployment paramVFSDeployment, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract void updateDeployment(String paramString, VFSDeployment paramVFSDeployment, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract VFSDeployment getDeployment(String paramString, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws NoSuchDeploymentException, Exception;

  public abstract VFSDeployment removeDeployment(String paramString, ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract Collection<VFSDeployment> getDeployments(ManagedDeployment.DeploymentPhase paramDeploymentPhase)
    throws Exception;

  public abstract Collection<VFSDeployment> getDeployments()
    throws Exception;

  public abstract Collection<ModificationInfo> getModifiedDeployments()
    throws Exception;

  public abstract void addManagedObject(String paramString, Attachments paramAttachments)
    throws Exception;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.spi.DeploymentRepository
 * JD-Core Version:    0.6.0
 */