/*     */ package org.jboss.profileservice.remoting;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.aop.Dispatcher;
/*     */ import org.jboss.aop.proxy.Proxy;
/*     */ import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
/*     */ import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
/*     */ import org.jboss.aspects.remoting.Remoting;
/*     */ import org.jboss.aspects.security.SecurityClientInterceptor;
/*     */ import org.jboss.deployers.spi.management.ManagementView;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.profileservice.spi.ProfileService;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class ProxyFactory
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(ProxyFactory.class);
/*  51 */   private String dispatchName = "ProfileService";
/*  52 */   private String jndiName = "ProfileService";
/*     */   private InvokerLocator locator;
/*     */   private ProfileService ps;
/*     */   private ManagementView mgtView;
/*     */   private Proxy psProxy;
/*     */   private Proxy mgtViewProxy;
/*     */ 
/*     */   public String getDispatchName()
/*     */   {
/*  61 */     return this.dispatchName;
/*     */   }
/*     */ 
/*     */   public void setDispatchName(String dispatchName)
/*     */   {
/*  66 */     this.dispatchName = dispatchName;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  71 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/*  76 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public InvokerLocator getLocator()
/*     */   {
/*  81 */     return this.locator;
/*     */   }
/*     */ 
/*     */   public void setLocator(InvokerLocator locator)
/*     */   {
/*  86 */     this.locator = locator;
/*     */   }
/*     */ 
/*     */   public ProfileService getProfileService()
/*     */   {
/*  91 */     return this.ps;
/*     */   }
/*     */ 
/*     */   public void setProfileService(ProfileService ps)
/*     */   {
/*  96 */     this.ps = ps;
/*     */   }
/*     */ 
/*     */   public Proxy getProfileServiceProxy()
/*     */   {
/* 101 */     return this.psProxy;
/*     */   }
/*     */ 
/*     */   public ManagementView getViewManager()
/*     */   {
/* 106 */     return this.mgtView;
/*     */   }
/*     */ 
/*     */   public void setViewManager(ManagementView mgtView) {
/* 110 */     this.mgtView = mgtView;
/*     */   }
/*     */ 
/*     */   public Proxy getManagementViewProxy()
/*     */   {
/* 115 */     return this.mgtViewProxy;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 121 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 122 */     Class[] ifaces = { ProfileService.class };
/*     */ 
/* 125 */     Dispatcher.singleton.registerTarget(this.dispatchName, this.ps);
/*     */ 
/* 127 */     ArrayList interceptors = new ArrayList();
/* 128 */     interceptors.add(SecurityClientInterceptor.singleton);
/* 129 */     interceptors.add(MergeMetaDataInterceptor.singleton);
/* 130 */     interceptors.add(InvokeRemoteInterceptor.singleton);
/*     */ 
/* 132 */     this.psProxy = Remoting.createRemoteProxy(this.dispatchName, loader, ifaces, this.locator, interceptors, "ProfileService");
/* 133 */     InitialContext ctx = new InitialContext();
/* 134 */     Util.bind(ctx, this.jndiName, this.psProxy);
/* 135 */     log.debug("Bound ProfileService proxy");
/*     */ 
/* 138 */     Class[] mvIfaces = { ManagementView.class };
/* 139 */     String mvDispatchName = this.dispatchName + ".ManagementView";
/* 140 */     Dispatcher.singleton.registerTarget(mvDispatchName, this.mgtView);
/* 141 */     this.mgtViewProxy = Remoting.createRemoteProxy(mvDispatchName, loader, mvIfaces, this.locator, interceptors, "ProfileService");
/* 142 */     log.debug("Created ManagementView proxy");
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 148 */     Dispatcher.singleton.unregisterTarget(this.dispatchName);
/* 149 */     String mvDispatchName = this.dispatchName + ".ManagementView";
/* 150 */     Dispatcher.singleton.unregisterTarget(mvDispatchName);
/* 151 */     InitialContext ctx = new InitialContext();
/* 152 */     Util.unbind(ctx, this.jndiName);
/* 153 */     log.debug("Unbound ProfileService proxy");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.remoting.ProxyFactory
 * JD-Core Version:    0.6.0
 */