/*    */ package org.jboss.profileservice.mock.ds;
/*    */ 
/*    */ import java.io.File;
/*    */ import java.io.PrintStream;
/*    */ import javax.xml.parsers.DocumentBuilder;
/*    */ import javax.xml.parsers.DocumentBuilderFactory;
/*    */ import org.jboss.util.xml.DOMUtils;
/*    */ import org.w3c.dom.Document;
/*    */ import org.w3c.dom.Element;
/*    */ import org.w3c.dom.Node;
/*    */ import org.w3c.dom.NodeList;
/*    */ 
/*    */ public class TestParse
/*    */ {
/*    */   public static void main(String[] args)
/*    */     throws Exception
/*    */   {
/* 19 */     DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/* 20 */     DocumentBuilder builder = factory.newDocumentBuilder();
/* 21 */     File tst = new File("/tmp/hsqldb-dsf.xml");
/* 22 */     Document document = builder.parse(tst);
/*    */ 
/* 24 */     NodeList datasources = document.getElementsByTagName("local-tx-datasource");
/* 25 */     System.out.println("Found " + datasources.getLength() + " local-tx-datasources");
/* 26 */     for (int i = 0; i < datasources.getLength(); i++)
/*    */     {
/* 28 */       Node node = datasources.item(i);
/* 29 */       System.out.println(i + ": " + node);
/* 30 */       if (node.getNodeType() != 1)
/*    */         continue;
/* 32 */       Element e = (Element)node;
/* 33 */       System.out.println("ELEMENT_NODE: " + e);
/* 34 */       NodeList tags = node.getChildNodes();
/* 35 */       for (int j = 0; j < tags.getLength(); j++)
/*    */       {
/* 37 */         Node child = tags.item(j);
/* 38 */         if (child.getNodeType() != 1)
/*    */           continue;
/* 40 */         Element ej = (Element)child;
/* 41 */         if (ej.getTagName().equals("jndi-name"))
/*    */         {
/* 43 */           System.out.println("jndi-name: " + DOMUtils.getTextContent(ej));
/*    */         }
/* 45 */         else if (ej.getTagName().equals("user-name"))
/*    */         {
/* 47 */           System.out.println("user-name: " + DOMUtils.getTextContent(ej));
/*    */         }
/* 49 */         else if (ej.getTagName().equals("driver-class"))
/*    */         {
/* 51 */           System.out.println("driver-class: " + DOMUtils.getTextContent(ej));
/*    */         }
/* 53 */         else if (ej.getTagName().equals("password"))
/*    */         {
/* 55 */           System.out.println("password: " + DOMUtils.getTextContent(ej));
/*    */         }
/* 57 */         else if (ej.getTagName().equals("min-pool-size"))
/*    */         {
/* 59 */           System.out.println("min-pool-size: " + DOMUtils.getTextContent(ej));
/*    */         }
/* 61 */         else if (ej.getTagName().equals("max-pool-size"))
/*    */         {
/* 63 */           System.out.println("max-pool-size: " + DOMUtils.getTextContent(ej));
/*    */         }
/* 65 */         else if (ej.getTagName().equals("security-domain"))
/*    */         {
/* 67 */           System.out.println("security-domain: " + DOMUtils.getTextContent(ej));
/*    */         }
/* 69 */         else if (ej.getTagName().equals("metadata"))
/*    */         {
/* 71 */           NodeList tms = ej.getElementsByTagName("type-mapping");
/* 72 */           Element tm = (Element)tms.item(0);
/* 73 */           System.out.println("metadata: " + tm.getTextContent());
/*    */         } else {
/* 75 */           if (!ej.getTagName().equals("depends"))
/*    */             continue;
/* 77 */           System.out.println("depends: " + DOMUtils.getTextContent(ej));
/*    */         }
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.mock.ds.TestParse
 * JD-Core Version:    0.6.0
 */