/*     */ package org.jboss.profileservice.mock.ds;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.deployers.spi.DeploymentException;
/*     */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*     */ import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
/*     */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*     */ import org.jboss.deployers.vfs.spi.deployer.JAXPDeployer;
/*     */ import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ComponentType;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.plugins.DefaultFieldsImpl;
/*     */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*     */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*     */ import org.jboss.managed.plugins.advice.WrapperAdvice;
/*     */ import org.jboss.metatype.api.types.SimpleMetaType;
/*     */ import org.jboss.metatype.api.values.SimpleValueSupport;
/*     */ import org.jboss.profileservice.management.builders.ServiceManagedObject;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceConstructorMetaData;
/*     */ import org.jboss.system.metadata.ServiceDependencyMetaData;
/*     */ import org.jboss.system.metadata.ServiceDeployment;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.system.metadata.ServiceTextValueMetaData;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ import org.w3c.dom.Document;
/*     */ 
/*     */ public class FakeDataSourceDeployer extends JAXPDeployer<ServiceDeployment>
/*     */   implements ManagedObjectCreator
/*     */ {
/*  72 */   private Map<String, String> propertyNameMappings = new HashMap();
/*     */ 
/*     */   public FakeDataSourceDeployer()
/*     */   {
/*  76 */     super(ServiceDeployment.class);
/*  77 */     setSuffix("-dsf.xml");
/*     */   }
/*     */ 
/*     */   public Map<String, String> getPropertyNameMappings()
/*     */   {
/*  82 */     return this.propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public void setPropertyNameMappings(Map<String, String> mangedToMBeanNames)
/*     */   {
/*  88 */     for (String key : mangedToMBeanNames.keySet())
/*     */     {
/*  90 */       String value = (String)mangedToMBeanNames.get(key);
/*  91 */       this.propertyNameMappings.put(value, key);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void build(DeploymentUnit unit, Map<String, ManagedObject> map)
/*     */     throws DeploymentException
/*     */   {
/*  98 */     String name = unit.getSimpleName();
/*  99 */     if (name.endsWith("-dsf.xml"))
/*     */     {
/* 101 */       Map attachments = unit.getTransientManagedObjects().getAttachments();
/* 102 */       this.log.info(name + " attachments: " + attachments);
/* 103 */       ServiceDeployment service = (ServiceDeployment)unit.getAttachment(ServiceDeployment.class);
/* 104 */       if (service == null)
/* 105 */         throw new DeploymentException("Failed to find ServiceDeployment in " + unit.getName());
/* 106 */       List services = service.getServices();
/*     */ 
/* 108 */       if (services.size() != 1)
/* 109 */         throw new DeploymentException("Expected only 1 ServiceMetaData but saw " + services.size() + " in " + unit.getName());
/* 110 */       ServiceMetaData dsMetaData = (ServiceMetaData)services.get(0);
/* 111 */       String attachName = ServiceMetaData.class.getName();
/* 112 */       ManagedObject mo = new ServiceManagedObject(attachName, dsMetaData, this.propertyNameMappings);
/* 113 */       ManagedObject wrapMO = WrapperAdvice.wrapManagedObject(mo);
/* 114 */       map.put(attachName, wrapMO);
/*     */ 
/* 116 */       attachName = "FakeConnectionFactoryDeployer.datasource-type";
/* 117 */       ManagedObjectImpl typeMO = new ManagedObjectImpl(attachName);
/* 118 */       DefaultFieldsImpl f21 = new DefaultFieldsImpl();
/* 119 */       f21.setName("datasource-type");
/* 120 */       f21.setDescription("The type of the DataSource");
/* 121 */       f21.setMandatory(true);
/* 122 */       f21.setValue("local-tx-datasource");
/* 123 */       HashSet values = new HashSet();
/* 124 */       values.add(SimpleValueSupport.wrap("local-tx-datasource"));
/* 125 */       values.add(SimpleValueSupport.wrap("no-tx-datasource"));
/* 126 */       values.add(SimpleValueSupport.wrap("xa-datasource"));
/* 127 */       f21.setLegalValues(values);
/* 128 */       f21.setMetaType(SimpleMetaType.STRING);
/* 129 */       ManagedPropertyImpl dsType = new ManagedPropertyImpl(typeMO, f21);
/* 130 */       typeMO.getProperties().put("datasource-type", dsType);
/* 131 */       wrapMO = WrapperAdvice.wrapManagedObject(typeMO);
/* 132 */       map.put(attachName, wrapMO);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ServiceDeployment parse(VFSDeploymentUnit unit, VirtualFile file, Document document)
/*     */     throws Exception
/*     */   {
/* 139 */     ServiceDeployment deployment = new ServiceDeployment();
/* 140 */     DataSourceDeployment ds = new DataSourceDeployment();
/* 141 */     ds.parse(document);
/*     */ 
/* 143 */     ServiceMetaData dsMbean = createDsServiceMetaData(ds);
/* 144 */     ArrayList services = new ArrayList();
/* 145 */     services.add(dsMbean);
/* 146 */     deployment.setServices(services);
/*     */ 
/* 148 */     ComponentType type = new ComponentType("FakeDataSource", "LocalTx");
/* 149 */     unit.addAttachment(ComponentType.class, type);
/*     */ 
/* 151 */     return deployment;
/*     */   }
/*     */ 
/*     */   protected boolean allowsReparse()
/*     */   {
/* 157 */     return true;
/*     */   }
/*     */ 
/*     */   public ServiceMetaData createDsServiceMetaData(DataSourceDeployment ds)
/*     */     throws Exception
/*     */   {
/* 163 */     ServiceMetaData dsMbean = new ServiceMetaData();
/* 164 */     this.log.info("DataSource settings: " + ds);
/*     */ 
/* 166 */     String jndiName = ds.getJndiName() == null ? "DefaultFakeDS" : ds.getJndiName();
/* 167 */     ObjectName objectName = new ObjectName("jboss.jca:type=FakeDataSourceConn,jndiName=" + jndiName);
/* 168 */     dsMbean.setObjectName(objectName);
/* 169 */     dsMbean.setCode(FakeDataSourceConn.class.getName());
/*     */ 
/* 171 */     ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
/* 172 */     constructor.setSignature(new String[] { DataSourceDeployment.class.getName() });
/* 173 */     constructor.setParameters(new Object[] { ds });
/* 174 */     dsMbean.setConstructor(constructor);
/*     */ 
/* 177 */     List attributes = new ArrayList();
/* 178 */     ServiceAttributeMetaData attribute = new ServiceAttributeMetaData();
/*     */ 
/* 180 */     attribute.setName("JndiName");
/* 181 */     attribute.setReplace(true);
/* 182 */     attribute.setTrim(true);
/* 183 */     attribute.setValue(new ServiceTextValueMetaData(jndiName));
/* 184 */     attributes.add(attribute);
/*     */ 
/* 186 */     attribute = new ServiceAttributeMetaData();
/* 187 */     attribute.setName("JdbcURL");
/* 188 */     if (ds.getJdbcURL() != null)
/* 189 */       attribute.setValue(new ServiceTextValueMetaData(ds.getJdbcURL()));
/* 190 */     attributes.add(attribute);
/*     */ 
/* 192 */     attribute = new ServiceAttributeMetaData();
/* 193 */     attribute.setName("DriverClass");
/* 194 */     if (ds.getDriverClass() != null)
/* 195 */       attribute.setValue(new ServiceTextValueMetaData(ds.getDriverClass()));
/* 196 */     attributes.add(attribute);
/*     */ 
/* 198 */     attribute = new ServiceAttributeMetaData();
/* 199 */     attribute.setName("Username");
/* 200 */     if (ds.getUsername() != null)
/* 201 */       attribute.setValue(new ServiceTextValueMetaData(ds.getUsername()));
/* 202 */     attributes.add(attribute);
/*     */ 
/* 204 */     attribute = new ServiceAttributeMetaData();
/* 205 */     attribute.setName("Password");
/* 206 */     if (ds.getPassword() != null)
/* 207 */       attribute.setValue(new ServiceTextValueMetaData(ds.getPassword()));
/* 208 */     attributes.add(attribute);
/*     */ 
/* 210 */     attribute = new ServiceAttributeMetaData();
/* 211 */     attribute.setName("SecurityDomain");
/* 212 */     if (ds.getSecurityDomain() != null)
/* 213 */       attribute.setValue(new ServiceTextValueMetaData(ds.getSecurityDomain()));
/* 214 */     attributes.add(attribute);
/*     */ 
/* 216 */     attribute = new ServiceAttributeMetaData();
/* 217 */     attribute.setName("MinPoolSize");
/* 218 */     if (ds.getMinPoolSize() != null)
/* 219 */       attribute.setValue(new ServiceTextValueMetaData(ds.getMinPoolSize()));
/* 220 */     attributes.add(attribute);
/*     */ 
/* 222 */     attribute = new ServiceAttributeMetaData();
/* 223 */     attribute.setName("MaxPoolSize");
/* 224 */     if (ds.getMaxPoolSize() != null)
/* 225 */       attribute.setValue(new ServiceTextValueMetaData(ds.getMaxPoolSize()));
/* 226 */     attributes.add(attribute);
/*     */ 
/* 228 */     attribute = new ServiceAttributeMetaData();
/* 229 */     attribute.setName("ConnectionProperties");
/* 230 */     if (ds.getMaxPoolSize() != null)
/* 231 */       attribute.setValue(new ServiceTextValueMetaData(ds.getMaxPoolSize()));
/* 232 */     attributes.add(attribute);
/*     */ 
/* 234 */     dsMbean.setAttributes(attributes);
/*     */ 
/* 237 */     Collection depends = ds.getDepends();
/* 238 */     List dependencies = new ArrayList();
/* 239 */     for (String iDependOn : depends)
/*     */     {
/* 241 */       ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
/* 242 */       sdmd.setIDependOn(iDependOn);
/*     */     }
/* 244 */     dsMbean.setDependencies(dependencies);
/* 245 */     return dsMbean;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.mock.ds.FakeDataSourceDeployer
 * JD-Core Version:    0.6.0
 */