/*     */ package org.jboss.profileservice.mock.ds;
/*     */ 
/*     */ import java.util.List;
/*     */ import java.util.Properties;
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.naming.Util;
/*     */ 
/*     */ public class FakeDataSourceConn
/*     */   implements FakeDataSourceConnMBean
/*     */ {
/*  41 */   private static Logger log = Logger.getLogger(FakeDataSourceConn.class);
/*     */   private DataSourceDeployment ds;
/*     */   private MockDataSource dsConn;
/*     */ 
/*     */   public FakeDataSourceConn(DataSourceDeployment ds)
/*     */   {
/*  47 */     this.ds = ds;
/*     */   }
/*     */ 
/*     */   public List<String> getDepends()
/*     */   {
/*  55 */     return this.ds.getDepends();
/*     */   }
/*     */ 
/*     */   public String getDriverClass()
/*     */   {
/*  63 */     return this.ds.getDriverClass();
/*     */   }
/*     */ 
/*     */   public String getJdbcURL()
/*     */   {
/*  71 */     return this.ds.getJdbcURL();
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  79 */     return this.ds.getJndiName();
/*     */   }
/*     */ 
/*     */   public int getMaxPoolSize()
/*     */   {
/*  87 */     return Integer.parseInt(this.ds.getMaxPoolSize());
/*     */   }
/*     */ 
/*     */   public int getMinPoolSize()
/*     */   {
/*  95 */     return Integer.parseInt(this.ds.getMinPoolSize());
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/* 103 */     return this.ds.getPassword();
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 111 */     return this.ds.getSecurityDomain();
/*     */   }
/*     */ 
/*     */   public String getTypeMapping()
/*     */   {
/* 119 */     return this.ds.getTypeMapping();
/*     */   }
/*     */ 
/*     */   public String getUsername()
/*     */   {
/* 127 */     return this.ds.getUsername();
/*     */   }
/*     */ 
/*     */   public void setDriverClass(String driverClass)
/*     */   {
/* 135 */     log.info("setDriverClass, " + driverClass);
/* 136 */     this.ds.setDriverClass(driverClass);
/*     */   }
/*     */ 
/*     */   public void setJdbcURL(String jdbcURL)
/*     */   {
/* 144 */     log.info("setJdbcURL, " + jdbcURL);
/* 145 */     this.ds.setJdbcURL(jdbcURL);
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/* 153 */     log.info("setJndiName, " + jndiName);
/* 154 */     this.ds.setJndiName(jndiName);
/*     */   }
/*     */ 
/*     */   public void setMaxPoolSize(int maxPoolSize)
/*     */   {
/* 162 */     this.ds.setMaxPoolSize("" + maxPoolSize);
/*     */   }
/*     */ 
/*     */   public void setMinPoolSize(int minPoolSize)
/*     */   {
/* 170 */     this.ds.setMinPoolSize("" + minPoolSize);
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 178 */     this.ds.setPassword(password);
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String securityDomain)
/*     */   {
/* 186 */     this.ds.setSecurityDomain(securityDomain);
/*     */   }
/*     */ 
/*     */   public void setTypeMapping(String typeMapping)
/*     */   {
/* 194 */     this.ds.setTypeMapping(typeMapping);
/*     */   }
/*     */ 
/*     */   public void setUsername(String username)
/*     */   {
/* 202 */     this.ds.setUsername(username);
/*     */   }
/*     */ 
/*     */   public Properties getConnectionProperties()
/*     */   {
/* 207 */     return this.ds.getConnectionProperties();
/*     */   }
/*     */ 
/*     */   public void setConnectionProperties(Properties props) {
/* 211 */     this.ds.setConnectionProperties(props);
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/* 220 */     this.dsConn = new MockDataSource();
/* 221 */     InitialContext ctx = new InitialContext();
/* 222 */     Util.bind(ctx, this.ds.getJndiName(), this.dsConn);
/* 223 */     log.info("Bound MockDataSource under: " + this.ds.getJndiName());
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/* 231 */     InitialContext ctx = new InitialContext();
/* 232 */     Util.unbind(ctx, this.ds.getJndiName());
/* 233 */     log.info("Unbound MockDataSource under: " + this.ds.getJndiName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.mock.ds.FakeDataSourceConn
 * JD-Core Version:    0.6.0
 */