/*     */ package org.jboss.profileservice.mock.ds;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.values.CompositeValue;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ import org.jboss.util.xml.DOMUtils;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class DataSourceDeployment
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  33 */   private static Logger log = Logger.getLogger(DataSourceDeployment.class);
/*     */ 
/*  35 */   private boolean replace = true;
/*     */   private String type;
/*     */   private String jndiName;
/*     */   private String driverClass;
/*     */   private String typeMapping;
/*     */   private String jdbcURL;
/*     */   private String username;
/*     */   private String password;
/*     */   private String securityDomain;
/*     */   private String minPoolSize;
/*     */   private String maxPoolSize;
/*     */   private Properties connProps;
/*  47 */   private ArrayList<String> depends = new ArrayList();
/*     */ 
/*     */   public String getType()
/*     */   {
/*  51 */     return this.type;
/*     */   }
/*     */ 
/*     */   public void setType(String type)
/*     */   {
/*  56 */     this.type = type;
/*     */   }
/*     */ 
/*     */   public String getDriverClass()
/*     */   {
/*  61 */     return this.driverClass;
/*     */   }
/*     */ 
/*     */   public void setDriverClass(String driverClass)
/*     */   {
/*  66 */     this.driverClass = driverClass;
/*     */   }
/*     */ 
/*     */   public String getJdbcURL()
/*     */   {
/*  71 */     return this.jdbcURL;
/*     */   }
/*     */ 
/*     */   public void setJdbcURL(String jdbcURL)
/*     */   {
/*  76 */     this.jdbcURL = jdbcURL;
/*     */   }
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  81 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/*  86 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public String getMaxPoolSize()
/*     */   {
/*  91 */     return this.maxPoolSize;
/*     */   }
/*     */ 
/*     */   public void setMaxPoolSize(String maxPoolSize)
/*     */   {
/*  96 */     this.maxPoolSize = maxPoolSize;
/*     */   }
/*     */ 
/*     */   public String getMinPoolSize()
/*     */   {
/* 101 */     return this.minPoolSize;
/*     */   }
/*     */ 
/*     */   public void setMinPoolSize(String minPoolSize)
/*     */   {
/* 106 */     this.minPoolSize = minPoolSize;
/*     */   }
/*     */ 
/*     */   public String getPassword()
/*     */   {
/* 111 */     return this.password;
/*     */   }
/*     */ 
/*     */   public void setPassword(String password)
/*     */   {
/* 116 */     this.password = password;
/*     */   }
/*     */ 
/*     */   public boolean isReplace()
/*     */   {
/* 121 */     return this.replace;
/*     */   }
/*     */ 
/*     */   public void setReplace(boolean replace)
/*     */   {
/* 126 */     this.replace = replace;
/*     */   }
/*     */ 
/*     */   public String getSecurityDomain()
/*     */   {
/* 131 */     return this.securityDomain;
/*     */   }
/*     */ 
/*     */   public void setSecurityDomain(String securityDomain)
/*     */   {
/* 136 */     this.securityDomain = securityDomain;
/*     */   }
/*     */ 
/*     */   public String getTypeMapping()
/*     */   {
/* 141 */     return this.typeMapping;
/*     */   }
/*     */ 
/*     */   public void setTypeMapping(String typeMapping)
/*     */   {
/* 146 */     this.typeMapping = typeMapping;
/*     */   }
/*     */ 
/*     */   public String getUsername()
/*     */   {
/* 151 */     return this.username;
/*     */   }
/*     */ 
/*     */   public void setUsername(String username)
/*     */   {
/* 156 */     this.username = username;
/*     */   }
/*     */ 
/*     */   public Properties getConnectionProperties()
/*     */   {
/* 161 */     return this.connProps;
/*     */   }
/*     */ 
/*     */   public void setConnectionProperties(Properties connProps)
/*     */   {
/* 166 */     this.connProps = connProps;
/*     */   }
/*     */ 
/*     */   public List<String> getDepends()
/*     */   {
/* 171 */     return this.depends;
/*     */   }
/*     */ 
/*     */   public void parse(Document document)
/*     */   {
/* 176 */     this.type = "local-tx-datasource";
/* 177 */     NodeList datasources = document.getElementsByTagName(this.type);
/* 178 */     for (int i = 0; i < datasources.getLength(); i++)
/*     */     {
/* 180 */       Node node = datasources.item(i);
/* 181 */       if (node.getNodeType() != 1)
/*     */         continue;
/* 183 */       Element e = (Element)node;
/* 184 */       System.out.println("ELEMENT_NODE: " + e);
/* 185 */       NodeList tags = node.getChildNodes();
/* 186 */       for (int j = 0; j < tags.getLength(); j++)
/*     */       {
/* 188 */         Node child = tags.item(j);
/* 189 */         if (child.getNodeType() != 1)
/*     */           continue;
/* 191 */         Element ej = (Element)child;
/* 192 */         if (ej.getTagName().equals("jndi-name"))
/*     */         {
/* 194 */           this.jndiName = getText(ej);
/*     */         }
/* 196 */         else if (ej.getTagName().equals("connection-url"))
/*     */         {
/* 198 */           this.jdbcURL = getText(ej);
/*     */         }
/* 200 */         else if (ej.getTagName().equals("user-name"))
/*     */         {
/* 202 */           this.username = getText(ej);
/*     */         }
/* 204 */         else if (ej.getTagName().equals("driver-class"))
/*     */         {
/* 206 */           this.driverClass = getText(ej);
/*     */         }
/* 208 */         else if (ej.getTagName().equals("password"))
/*     */         {
/* 210 */           this.password = getText(ej);
/* 211 */           if (this.password == null)
/* 212 */             this.password = "";
/*     */         }
/* 214 */         else if (ej.getTagName().equals("min-pool-size"))
/*     */         {
/* 216 */           this.minPoolSize = getText(ej);
/*     */         }
/* 218 */         else if (ej.getTagName().equals("max-pool-size"))
/*     */         {
/* 220 */           this.maxPoolSize = getText(ej);
/*     */         }
/* 222 */         else if (ej.getTagName().equals("security-domain"))
/*     */         {
/* 224 */           this.securityDomain = getText(ej);
/*     */         }
/* 226 */         else if (ej.getTagName().equals("metadata"))
/*     */         {
/* 228 */           NodeList tms = ej.getElementsByTagName("type-mapping");
/* 229 */           Element tm = (Element)tms.item(0);
/* 230 */           this.typeMapping = getText(tm);
/*     */         }
/* 232 */         else if (ej.getTagName().equals("depends"))
/*     */         {
/* 234 */           String depends = getText(ej);
/* 235 */           addDepends(depends);
/*     */         } else {
/* 237 */           if (!ej.getTagName().equals("connection-properties"))
/*     */             continue;
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void parse(Map<String, ManagedProperty> properties)
/*     */   {
/* 256 */     for (ManagedProperty property : properties.values())
/*     */     {
/* 258 */       String name = property.getName();
/* 259 */       Object value = property.getValue();
/* 260 */       if (value == null) {
/*     */         continue;
/*     */       }
/* 263 */       if (name.equals(""))
/*     */       {
/* 265 */         this.type = value.toString();
/*     */       }
/* 267 */       else if (name.equals("jndi-name"))
/*     */       {
/* 269 */         this.jndiName = value.toString();
/*     */       }
/* 271 */       else if (name.equals("connection-url"))
/*     */       {
/* 273 */         this.jdbcURL = value.toString();
/*     */       }
/* 275 */       else if (name.equals("user-name"))
/*     */       {
/* 277 */         this.username = value.toString();
/*     */       }
/* 279 */       else if (name.equals("driver-class"))
/*     */       {
/* 281 */         this.driverClass = value.toString();
/*     */       }
/* 283 */       else if (name.equals("password"))
/*     */       {
/* 285 */         this.password = value.toString();
/* 286 */         if (this.password == null)
/* 287 */           this.password = "";
/*     */       }
/* 289 */       else if (name.equals("min-pool-size"))
/*     */       {
/* 291 */         this.minPoolSize = value.toString();
/*     */       }
/* 293 */       else if (name.equals("max-pool-size"))
/*     */       {
/* 295 */         this.maxPoolSize = value.toString();
/*     */       }
/* 297 */       else if (name.equals("security-domain"))
/*     */       {
/* 299 */         this.securityDomain = value.toString();
/*     */       }
/* 301 */       else if (name.equals("type-mapping"))
/*     */       {
/* 303 */         this.typeMapping = value.toString();
/*     */       }
/* 305 */       else if (name.equals("connection-properties"))
/*     */       {
/* 307 */         CompositeValue cvalue = (CompositeValue)value;
/* 308 */         parseConnProps(cvalue);
/*     */       }
/* 310 */       else if (name.equals("depends"))
/*     */       {
/* 312 */         String depends = value.toString();
/* 313 */         addDepends(depends);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 321 */     StringBuilder tmp = new StringBuilder(super.toString());
/* 322 */     tmp.append('(');
/* 323 */     tmp.append("depends=");
/* 324 */     tmp.append(this.depends);
/* 325 */     tmp.append(",driverClass=");
/* 326 */     tmp.append(this.driverClass);
/* 327 */     tmp.append(",jdbcURL=");
/* 328 */     tmp.append(this.jdbcURL);
/* 329 */     tmp.append(",jndiName=");
/* 330 */     tmp.append(this.jndiName);
/* 331 */     tmp.append(",username=");
/* 332 */     tmp.append(this.username);
/* 333 */     tmp.append(",password=");
/* 334 */     tmp.append(this.password);
/* 335 */     tmp.append(",minPoolSize=");
/* 336 */     tmp.append(this.minPoolSize);
/* 337 */     tmp.append(",maxPoolSize=");
/* 338 */     tmp.append(this.maxPoolSize);
/* 339 */     tmp.append(",securityDomain=");
/* 340 */     tmp.append(this.securityDomain);
/* 341 */     tmp.append(",typeMapping=");
/* 342 */     tmp.append(this.typeMapping);
/* 343 */     tmp.append(",connProps=");
/* 344 */     tmp.append(this.connProps);
/* 345 */     tmp.append(')');
/* 346 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   private void addDepends(String depends)
/*     */   {
/* 351 */     this.depends.add(depends);
/*     */   }
/*     */ 
/*     */   private String getText(Node node)
/*     */   {
/* 356 */     String text = DOMUtils.getTextContent(node);
/* 357 */     if ((text != null) && (this.replace))
/* 358 */       text = StringPropertyReplacer.replaceProperties(text);
/* 359 */     return text;
/*     */   }
/*     */ 
/*     */   private void parseConnProps(CompositeValue cvalue) {
/* 363 */     this.connProps = new Properties();
/* 364 */     for (String key : cvalue.getMetaType().keySet())
/*     */     {
/* 366 */       if (cvalue.containsKey(key))
/*     */       {
/* 368 */         MetaValue value = cvalue.get(key);
/*     */ 
/* 370 */         SimpleValue svalue = (SimpleValue)value;
/* 371 */         this.connProps.setProperty(key, svalue.getValue().toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.mock.ds.DataSourceDeployment
 * JD-Core Version:    0.6.0
 */