/*     */ package org.jboss.profileservice.management.templates;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileWriter;
/*     */ import java.net.URI;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Map;
/*     */ import org.jboss.deployers.spi.management.DeploymentTemplate;
/*     */ import org.jboss.deployers.spi.management.DeploymentTemplateInfo;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.profileservice.mock.ds.DataSourceDeployment;
/*     */ import org.jboss.profileservice.mock.ds.FakeDataSourceDeployer;
/*     */ import org.jboss.system.metadata.ServiceDeployment;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class FakeDsXmlDataSourceTemplate
/*     */   implements DeploymentTemplate
/*     */ {
/*     */   private DeploymentTemplateInfo info;
/*     */   private FakeDataSourceDeployer deployer;
/*     */   private Map<String, String> propertyNameMappings;
/*     */ 
/*     */   public Map<String, String> getPropertyNameMappings()
/*     */   {
/*  62 */     return this.propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public void setPropertyNameMappings(Map<String, String> propertyNameMappings)
/*     */   {
/*  67 */     this.propertyNameMappings = propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public FakeDataSourceDeployer getDeployer()
/*     */   {
/*  72 */     return this.deployer;
/*     */   }
/*     */ 
/*     */   public void setDeployer(FakeDataSourceDeployer deployer)
/*     */   {
/*  77 */     this.deployer = deployer;
/*     */   }
/*     */ 
/*     */   public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/*  88 */     String dsName = deploymentBaseName + "-dsf.xml";
/*  89 */     URI dsXmlURI = new URI(root.toURI() + dsName);
/*  90 */     File dsXml = new File(dsXmlURI.getPath());
/*  91 */     writeTemplate(dsXml, values);
/*  92 */     VirtualFile dsXmlVF = root.findChild(dsName);
/*  93 */     return dsXmlVF;
/*     */   }
/*     */ 
/*     */   public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/* 106 */     ServiceDeployment service = new ServiceDeployment();
/* 107 */     ArrayList services = new ArrayList();
/* 108 */     DataSourceDeployment ds = new DataSourceDeployment();
/* 109 */     ds.parse(values.getProperties());
/* 110 */     ServiceMetaData dsMetaData = this.deployer.createDsServiceMetaData(ds);
/* 111 */     services.add(dsMetaData);
/* 112 */     service.setServices(services);
/*     */   }
/*     */ 
/*     */   public DeploymentTemplateInfo getInfo()
/*     */   {
/* 120 */     return this.info;
/*     */   }
/*     */ 
/*     */   public void setInfo(DeploymentTemplateInfo info) {
/* 124 */     this.info = info;
/*     */   }
/*     */ 
/*     */   protected void writeTemplate(File dsXml, DeploymentTemplateInfo values)
/*     */     throws Exception
/*     */   {
/* 130 */     FileWriter fw = new FileWriter(dsXml);
/* 131 */     Map properties = values.getProperties();
/* 132 */     ManagedProperty type = (ManagedProperty)properties.get("datasource-type");
/* 133 */     String typeTag = "local-tx-datasource";
/* 134 */     if ((type != null) && (type.getValue() != null)) {
/* 135 */       typeTag = type.getValue().toString();
/*     */     }
/*     */ 
/* 141 */     fw.write("<datasources>\n");
/* 142 */     fw.write("<" + typeTag + ">\n");
/* 143 */     fw.write("<jndi-name>default</jndi-name>\n");
/* 144 */     fw.write("<connection-url>jdbc:...</connection-url>\n");
/* 145 */     fw.write("<driver-class>default</driver-class>\n");
/* 146 */     fw.write("<user-name>default</user-name>\n");
/* 147 */     fw.write("<password>default</password>\n");
/* 148 */     fw.write("<min-pool-size>1</min-pool-size>\n");
/* 149 */     fw.write("<max-pool-size>10</max-pool-size>\n");
/* 150 */     fw.write("<security-domain>default</security-domain>\n");
/* 151 */     fw.write("</" + typeTag + ">\n");
/* 152 */     fw.write("</datasources>\n");
/* 153 */     fw.flush();
/* 154 */     fw.close();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.templates.FakeDsXmlDataSourceTemplate
 * JD-Core Version:    0.6.0
 */