/*     */ package org.jboss.profileservice.management.templates;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import org.jboss.managed.api.Fields;
/*     */ import org.jboss.managed.plugins.DefaultFieldsImpl;
/*     */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*     */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.SimpleMetaType;
/*     */ import org.jboss.metatype.api.values.SimpleValueSupport;
/*     */ import org.jboss.profileservice.management.plugins.BasicDeploymentTemplateInfo;
/*     */ 
/*     */ public class DsXmlDataSourceTemplateInfo extends BasicDeploymentTemplateInfo
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private Map<String, String> propertyNameMappings;
/*     */   private String attachmentName;
/*     */   private String dsTypeAttachmentName;
/*     */ 
/*     */   public DsXmlDataSourceTemplateInfo(String name, String description, String attachmentName)
/*     */   {
/*  55 */     this(name, description, attachmentName, attachmentName);
/*     */   }
/*     */ 
/*     */   public DsXmlDataSourceTemplateInfo(String name, String description, String attachmentName, String dsTypeAttachmentName)
/*     */   {
/*  60 */     super(name, description);
/*  61 */     this.attachmentName = attachmentName;
/*  62 */     this.dsTypeAttachmentName = dsTypeAttachmentName;
/*     */   }
/*     */ 
/*     */   public Map<String, String> getPropertyNameMappings()
/*     */   {
/*  67 */     return this.propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public void setPropertyNameMappings(Map<String, String> propertyNameMappings) {
/*  71 */     this.propertyNameMappings = propertyNameMappings;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */   {
/*  76 */     ManagedObjectImpl mo = new ManagedObjectImpl(this.attachmentName);
/*     */ 
/*  78 */     DefaultFieldsImpl f0 = new DefaultFieldsImpl();
/*  79 */     setFieldName("jndi-name", f0);
/*  80 */     f0.setDescription("The jndi name to bind the DataSource under");
/*  81 */     f0.setMandatory(true);
/*  82 */     f0.setMetaType(SimpleMetaType.STRING);
/*  83 */     ManagedPropertyImpl jndiName = new ManagedPropertyImpl(mo, f0);
/*  84 */     super.addProperty(jndiName);
/*     */ 
/*  86 */     DefaultFieldsImpl f1 = new DefaultFieldsImpl();
/*  87 */     setFieldName("connection-url", f1);
/*  88 */     f1.setDescription("The jdbc url of the DataSource");
/*  89 */     f1.setMandatory(true);
/*  90 */     f1.setMetaType(SimpleMetaType.STRING);
/*  91 */     ManagedPropertyImpl conURL = new ManagedPropertyImpl(mo, f1);
/*  92 */     super.addProperty(conURL);
/*     */ 
/*  94 */     DefaultFieldsImpl f2 = new DefaultFieldsImpl();
/*  95 */     setFieldName("user-name", f2);
/*  96 */     f2.setDescription("The username for the connection-url");
/*  97 */     f2.setMandatory(false);
/*  98 */     f2.setMetaType(SimpleMetaType.STRING);
/*  99 */     ManagedPropertyImpl user = new ManagedPropertyImpl(mo, f2);
/* 100 */     super.addProperty(user);
/*     */ 
/* 102 */     DefaultFieldsImpl f3 = new DefaultFieldsImpl();
/* 103 */     setFieldName("password", f3);
/* 104 */     f3.setDescription("The password for the connection-url");
/* 105 */     f3.setMandatory(false);
/* 106 */     f3.setMetaType(SimpleMetaType.STRING);
/* 107 */     ManagedPropertyImpl password = new ManagedPropertyImpl(mo, f3);
/* 108 */     super.addProperty(password);
/*     */ 
/* 110 */     DefaultFieldsImpl f4 = new DefaultFieldsImpl();
/* 111 */     setFieldName("security-domain", f4);
/* 112 */     f4.setDescription("The security-domain used to validate connections");
/* 113 */     f4.setMandatory(false);
/* 114 */     f4.setMetaType(SimpleMetaType.STRING);
/* 115 */     ManagedPropertyImpl secDomain = new ManagedPropertyImpl(mo, f4);
/* 116 */     super.addProperty(secDomain);
/*     */ 
/* 118 */     DefaultFieldsImpl f5 = new DefaultFieldsImpl();
/* 119 */     setFieldName("driver-class", f5);
/* 120 */     f5.setDescription("The jdbc driver class name");
/* 121 */     f5.setMandatory(true);
/* 122 */     f5.setMetaType(SimpleMetaType.STRING);
/* 123 */     ManagedPropertyImpl driverClass = new ManagedPropertyImpl(mo, f5);
/* 124 */     super.addProperty(driverClass);
/*     */ 
/* 126 */     DefaultFieldsImpl f6 = new DefaultFieldsImpl();
/* 127 */     setFieldName("connection-properties", f6);
/* 128 */     f6.setDescription("The jdbc driver connection properties");
/* 129 */     f6.setMandatory(false);
/* 130 */     String[] itemNames = { "conn-prop1", "conn-prop2" };
/* 131 */     String[] itemDescriptions = { "conn-prop1 description", "conn-prop2 description" };
/* 132 */     MetaType[] itemTypes = { SimpleMetaType.STRING, SimpleMetaType.STRING };
/* 133 */     CompositeMetaType propsType = new ImmutableCompositeMetaType("java.lang.Properties", "DS connection properties", itemNames, itemDescriptions, itemTypes);
/*     */ 
/* 135 */     f6.setMetaType(propsType);
/* 136 */     ManagedPropertyImpl connProps = new ManagedPropertyImpl(mo, f6);
/* 137 */     super.addProperty(connProps);
/*     */ 
/* 140 */     ManagedObjectImpl mo2 = new ManagedObjectImpl(this.dsTypeAttachmentName);
/* 141 */     DefaultFieldsImpl f21 = new DefaultFieldsImpl();
/* 142 */     setFieldName("datasource-type", f21);
/* 143 */     f21.setDescription("The type of the DataSource");
/* 144 */     f21.setMandatory(true);
/* 145 */     f21.setValue("local-tx-datasource");
/* 146 */     HashSet values = new HashSet();
/* 147 */     values.add(SimpleValueSupport.wrap("local-tx-datasource"));
/* 148 */     values.add(SimpleValueSupport.wrap("no-tx-datasource"));
/* 149 */     values.add(SimpleValueSupport.wrap("xa-datasource"));
/* 150 */     f21.setLegalValues(values);
/* 151 */     f21.setMetaType(SimpleMetaType.STRING);
/* 152 */     ManagedPropertyImpl dsType = new ManagedPropertyImpl(mo2, f21);
/* 153 */     super.addProperty(dsType);
/*     */   }
/*     */ 
/*     */   protected void setFieldName(String name, Fields f)
/*     */   {
/* 158 */     f.setField("name", name);
/* 159 */     if (this.propertyNameMappings != null)
/*     */     {
/* 161 */       String mappedName = (String)this.propertyNameMappings.get(name);
/* 162 */       if (mappedName != null)
/* 163 */         f.setField("mappedName", mappedName);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.templates.DsXmlDataSourceTemplateInfo
 * JD-Core Version:    0.6.0
 */