/*     */ package org.jboss.profileservice.management.builders;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*     */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*     */ import org.jboss.metatype.api.types.CompositeMetaType;
/*     */ import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.types.SimpleMetaType;
/*     */ import org.jboss.system.metadata.ServiceAttributeMetaData;
/*     */ import org.jboss.system.metadata.ServiceMetaData;
/*     */ 
/*     */ public class ServiceManagedObject extends ManagedObjectImpl
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */ 
/*     */   public ServiceManagedObject(String attachmentName, ServiceMetaData metaData)
/*     */   {
/*  57 */     this(attachmentName, metaData, null);
/*     */   }
/*     */ 
/*     */   public ServiceManagedObject(String attachmentName, ServiceMetaData metaData, Map<String, String> propertyNameMappings)
/*     */   {
/*  71 */     super(attachmentName);
/*     */     try
/*     */     {
/*  74 */       properties = getProperties().values();
/*  75 */       List attributes = metaData.getAttributes();
/*  76 */       for (ServiceAttributeMetaData attr : attributes)
/*     */       {
/*  78 */         String fieldName = attr.getName();
/*  79 */         String mappedName = null;
/*  80 */         if (propertyNameMappings != null)
/*  81 */           mappedName = (String)propertyNameMappings.get(fieldName);
/*  82 */         ServiceAttributeFields attrFields = new ServiceAttributeFields(attr, fieldName, mappedName);
/*     */ 
/*  84 */         if (fieldName.equals("ConnectionProps"))
/*     */         {
/*  86 */           String[] itemNames = { "conn-prop1", "conn-prop2" };
/*  87 */           String[] itemDescriptions = { "conn-prop1 description", "conn-prop2 description" };
/*  88 */           MetaType[] itemTypes = { SimpleMetaType.STRING, SimpleMetaType.STRING };
/*  89 */           CompositeMetaType propsType = new ImmutableCompositeMetaType("java.lang.Properties", "DS connection properties", itemNames, itemDescriptions, itemTypes);
/*     */ 
/*  91 */           attrFields.setMetaType(propsType);
/*     */         }
/*  93 */         properties.add(new ManagedPropertyImpl(this, attrFields));
/*     */       }
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*     */       Collection properties;
/*  98 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 102 */       throw new RuntimeException("Error creating ServiceManagedObject", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 110 */     StringBuilder tmp = new StringBuilder("ServiceManagedObject{");
/* 111 */     tmp.append(super.getProperties());
/* 112 */     tmp.append('}');
/* 113 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.builders.ServiceManagedObject
 * JD-Core Version:    0.6.0
 */