/*    */ package org.jboss.profileservice.management.builders;
/*    */ 
/*    */ import java.util.HashMap;
/*    */ import java.util.HashSet;
/*    */ import java.util.List;
/*    */ import java.util.Map;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*    */ import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.managed.api.ManagedObject;
/*    */ import org.jboss.managed.plugins.DefaultFieldsImpl;
/*    */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*    */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*    */ import org.jboss.managed.plugins.advice.WrapperAdvice;
/*    */ import org.jboss.metatype.api.types.SimpleMetaType;
/*    */ import org.jboss.metatype.api.values.SimpleValueSupport;
/*    */ import org.jboss.system.metadata.ServiceDeployment;
/*    */ import org.jboss.system.metadata.ServiceMetaData;
/*    */ 
/*    */ public class FakeConnectionFactoryDeployerManagedObjectBuilder
/*    */   implements ManagedObjectCreator
/*    */ {
/* 54 */   private static Logger log = Logger.getLogger(ConnectionFactoryDeployerManagedObjectBuilder.class);
/*    */ 
/* 58 */   private Map<String, String> propertyNameMappings = new HashMap();
/*    */ 
/*    */   public Map<String, String> getPropertyNameMappings()
/*    */   {
/* 62 */     return this.propertyNameMappings;
/*    */   }
/*    */ 
/*    */   public void setPropertyNameMappings(Map<String, String> mangedToMBeanNames)
/*    */   {
/* 68 */     for (String key : mangedToMBeanNames.keySet())
/*    */     {
/* 70 */       String value = (String)mangedToMBeanNames.get(key);
/* 71 */       this.propertyNameMappings.put(value, key);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void build(DeploymentUnit unit, Map<String, ManagedObject> map)
/*    */     throws DeploymentException
/*    */   {
/* 78 */     String name = unit.getSimpleName();
/* 79 */     if (name.endsWith("-dsf.xml"))
/*    */     {
/* 81 */       Map attachments = unit.getTransientManagedObjects().getAttachments();
/* 82 */       log.info(name + " attachments: " + attachments);
/* 83 */       ServiceDeployment service = (ServiceDeployment)unit.getAttachment(ServiceDeployment.class);
/* 84 */       if (service == null)
/* 85 */         throw new DeploymentException("Failed to find ServiceDeployment in " + unit.getName());
/* 86 */       List services = service.getServices();
/*    */ 
/* 88 */       if (services.size() != 1)
/* 89 */         throw new DeploymentException("Expected only 1 ServiceMetaData but saw " + services.size() + " in " + unit.getName());
/* 90 */       ServiceMetaData dsMetaData = (ServiceMetaData)services.get(0);
/* 91 */       String attachName = ServiceMetaData.class.getName();
/* 92 */       ManagedObject mo = new ServiceManagedObject(attachName, dsMetaData, this.propertyNameMappings);
/* 93 */       ManagedObject wrapMO = WrapperAdvice.wrapManagedObject(mo);
/* 94 */       map.put(attachName, wrapMO);
/*    */ 
/* 96 */       attachName = "FakeConnectionFactoryDeployer.datasource-type";
/* 97 */       ManagedObjectImpl typeMO = new ManagedObjectImpl(attachName);
/* 98 */       DefaultFieldsImpl f21 = new DefaultFieldsImpl();
/* 99 */       f21.setName("datasource-type");
/* 100 */       f21.setDescription("The type of the DataSource");
/* 101 */       f21.setMandatory(true);
/* 102 */       f21.setValue("local-tx-datasource");
/* 103 */       HashSet values = new HashSet();
/* 104 */       values.add(SimpleValueSupport.wrap("local-tx-datasource"));
/* 105 */       values.add(SimpleValueSupport.wrap("no-tx-datasource"));
/* 106 */       values.add(SimpleValueSupport.wrap("xa-datasource"));
/* 107 */       f21.setLegalValues(values);
/* 108 */       f21.setMetaType(SimpleMetaType.STRING);
/* 109 */       ManagedPropertyImpl dsType = new ManagedPropertyImpl(typeMO, f21);
/* 110 */       typeMO.getProperties().put("datasource-type", dsType);
/* 111 */       wrapMO = WrapperAdvice.wrapManagedObject(typeMO);
/* 112 */       map.put(attachName, wrapMO);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.builders.FakeConnectionFactoryDeployerManagedObjectBuilder
 * JD-Core Version:    0.6.0
 */