/*     */ package org.jboss.profileservice.management.builders;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*     */ import org.jboss.managed.plugins.ManagedPropertyImpl;
/*     */ import org.jboss.metatype.api.types.SimpleMetaType;
/*     */ import org.jboss.metatype.api.values.SimpleValueSupport;
/*     */ import org.jboss.util.xml.DOMWriter;
/*     */ import org.w3c.dom.DOMImplementation;
/*     */ import org.w3c.dom.Document;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class DomDataSourceManagedObject extends ManagedObjectImpl
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  54 */   private static String[] dsTypes = { "local-tx-datasource", "no-tx-datasource", "xa-datasource" };
/*     */   private Document document;
/*     */ 
/*     */   public DomDataSourceManagedObject(String attachmentName, Document document)
/*     */   {
/*  64 */     super(attachmentName);
/*  65 */     this.document = document;
/*     */     Element element;
/*     */     Element element;
/*  67 */     if (document == null)
/*     */     {
/*     */       try
/*     */       {
/*  72 */         DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
/*  73 */         DocumentBuilder builder = factory.newDocumentBuilder();
/*  74 */         DOMImplementation impl = builder.getDOMImplementation();
/*  75 */         document = impl.createDocument(null, null, null);
/*     */ 
/*  77 */         element = document.createElement("datasources");
/*  78 */         document.appendChild(element);
/*     */ 
/*  80 */         Element child = document.createElement("local-tx-datasource");
/*  81 */         element.appendChild(child);
/*  82 */         element = child;
/*     */       }
/*     */       catch (RuntimeException e)
/*     */       {
/*  86 */         throw e;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  90 */         throw new RuntimeException("Error creating dom", e);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/*  95 */       NodeList dses = document.getElementsByTagName("datasources");
/*  96 */       if (dses.getLength() == 0)
/*     */       {
/*  98 */         element = document.createElement("datasources");
/*  99 */         document.appendChild(element);
/*     */       }
/*     */       else
/*     */       {
/* 103 */         element = (Element)dses.item(0);
/*     */       }
/* 105 */       NodeList dsType = null;
/* 106 */       for (String type : dsTypes)
/*     */       {
/* 108 */         dsType = element.getElementsByTagName(type);
/* 109 */         if (dsType.getLength() > 0) {
/*     */           break;
/*     */         }
/*     */       }
/* 113 */       if ((dsType == null) || (dsType.getLength() == 0))
/*     */       {
/* 116 */         Element child = document.createElement("local-tx-datasource");
/* 117 */         element.appendChild(child);
/* 118 */         element = child;
/*     */       }
/*     */       else
/*     */       {
/* 122 */         element = (Element)dsType.item(0);
/*     */       }
/*     */     }
/*     */ 
/* 126 */     Collection properties = getProperties().values();
/*     */ 
/* 128 */     DomFields dsType = new DomFields(element, "datasource-type");
/* 129 */     dsType.setField("description", "The type of DataSource");
/* 130 */     dsType.setField("mandatory", Boolean.TRUE);
/* 131 */     dsType.setField("metaType", SimpleMetaType.STRING);
/* 132 */     HashSet values = new HashSet();
/* 133 */     values.add(SimpleValueSupport.wrap("local-tx-datasource"));
/* 134 */     values.add(SimpleValueSupport.wrap("no-tx-datasource"));
/* 135 */     values.add(SimpleValueSupport.wrap("xa-datasource"));
/* 136 */     dsType.setLegalValues(values);
/*     */ 
/* 139 */     DomFields jndiName = new DomFields(element, "jndi-name");
/* 140 */     jndiName.setField("description", "The jndi name to bind the DataSource under");
/* 141 */     jndiName.setField("mandatory", Boolean.TRUE);
/* 142 */     jndiName.setField("metaType", SimpleMetaType.STRING);
/*     */ 
/* 144 */     DomFields driverClass = new DomFields(element, "driver-class");
/* 145 */     driverClass.setField("description", "The jdbc driver class DataSource");
/* 146 */     driverClass.setField("mandatory", Boolean.TRUE);
/* 147 */     driverClass.setField("metaType", SimpleMetaType.STRING);
/*     */ 
/* 149 */     DomFields connURL = new DomFields(element, "connection-url");
/* 150 */     connURL.setField("description", "The jdbc url of the DataSource");
/* 151 */     connURL.setField("mandatory", Boolean.TRUE);
/* 152 */     connURL.setField("metaType", SimpleMetaType.STRING);
/*     */ 
/* 154 */     DomFields user = new DomFields(element, "user-name");
/* 155 */     user.setField("description", "The username for the connection-url");
/* 156 */     user.setField("mandatory", Boolean.FALSE);
/* 157 */     user.setField("metaType", SimpleMetaType.STRING);
/*     */ 
/* 159 */     DomFields password = new DomFields(element, "password", false);
/* 160 */     password.setField("description", "The password for the connection-url");
/* 161 */     password.setField("mandatory", Boolean.FALSE);
/* 162 */     password.setField("metaType", SimpleMetaType.STRING);
/*     */ 
/* 164 */     DomFields minPoolSize = new DomFields(element, "min-pool-size");
/* 165 */     password.setField("description", "The min pool size");
/* 166 */     password.setField("mandatory", Boolean.FALSE);
/* 167 */     password.setField("metaType", SimpleMetaType.INTEGER);
/*     */ 
/* 169 */     DomFields maxPoolSize = new DomFields(element, "max-pool-size");
/* 170 */     password.setField("description", "The max pool size");
/* 171 */     password.setField("mandatory", Boolean.FALSE);
/* 172 */     password.setField("metaType", SimpleMetaType.INTEGER);
/*     */ 
/* 175 */     DomFields secDomain = new DomFields(element, "security-domain");
/* 176 */     secDomain.setField("description", "The security-domain used to validate connections");
/* 177 */     secDomain.setField("mandatory", Boolean.FALSE);
/* 178 */     secDomain.setField("metaType", SimpleMetaType.STRING);
/*     */ 
/* 180 */     DomFields psCacheSize = new DomFields(element, "prepared-statement-cache-size");
/* 181 */     secDomain.setField("description", "The prepared statement cache size");
/* 182 */     secDomain.setField("mandatory", Boolean.FALSE);
/* 183 */     secDomain.setField("metaType", SimpleMetaType.INTEGER);
/*     */ 
/* 186 */     properties.add(new ManagedPropertyImpl(this, dsType));
/* 187 */     properties.add(new ManagedPropertyImpl(this, jndiName));
/* 188 */     properties.add(new ManagedPropertyImpl(this, driverClass));
/* 189 */     properties.add(new ManagedPropertyImpl(this, connURL));
/* 190 */     properties.add(new ManagedPropertyImpl(this, user));
/* 191 */     properties.add(new ManagedPropertyImpl(this, password));
/* 192 */     properties.add(new ManagedPropertyImpl(this, minPoolSize));
/* 193 */     properties.add(new ManagedPropertyImpl(this, maxPoolSize));
/* 194 */     properties.add(new ManagedPropertyImpl(this, secDomain));
/* 195 */     properties.add(new ManagedPropertyImpl(this, psCacheSize));
/*     */   }
/*     */ 
/*     */   public String prettyPrint()
/*     */   {
/* 201 */     StringBuffer tmp = new StringBuffer(super.toString());
/* 202 */     tmp.append('[');
/* 203 */     tmp.append(DOMWriter.printNode(this.document, true));
/* 204 */     tmp.append(']');
/* 205 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 211 */     return prettyPrint();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.builders.DomDataSourceManagedObject
 * JD-Core Version:    0.6.0
 */