/*    */ package org.jboss.profileservice.management.builders;
/*    */ 
/*    */ import java.util.Map;
/*    */ import org.jboss.deployers.spi.DeploymentException;
/*    */ import org.jboss.deployers.spi.attachments.MutableAttachments;
/*    */ import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
/*    */ import org.jboss.deployers.structure.spi.DeploymentUnit;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.managed.api.ManagedObject;
/*    */ import org.jboss.managed.plugins.advice.WrapperAdvice;
/*    */ import org.w3c.dom.Document;
/*    */ 
/*    */ public class ConnectionFactoryDeployerManagedObjectBuilder
/*    */   implements ManagedObjectCreator
/*    */ {
/* 44 */   private static Logger log = Logger.getLogger(ConnectionFactoryDeployerManagedObjectBuilder.class);
/*    */ 
/*    */   public void build(DeploymentUnit unit, Map<String, ManagedObject> map)
/*    */     throws DeploymentException
/*    */   {
/* 49 */     String name = unit.getSimpleName();
/* 50 */     if (name.endsWith("-ds.xml"))
/*    */     {
/* 52 */       Map attachments = unit.getTransientManagedObjects().getAttachments();
/* 53 */       log.debug(name + " attachments: " + attachments);
/* 54 */       String attachName = Document.class.getName();
/* 55 */       Document document = (Document)unit.getAttachment(attachName, Document.class);
/* 56 */       ManagedObject mo = new DomDataSourceManagedObject(attachName, document);
/* 57 */       ManagedObject wrapMO = WrapperAdvice.wrapManagedObject(mo);
/* 58 */       map.put(attachName, wrapMO);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.builders.ConnectionFactoryDeployerManagedObjectBuilder
 * JD-Core Version:    0.6.0
 */