/*     */ package org.jboss.profileservice.management;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.text.MessageFormat;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Locale;
/*     */ import java.util.Map;
/*     */ import java.util.ResourceBundle;
/*     */ import java.util.Set;
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ import org.jboss.aop.Dispatcher;
/*     */ import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
/*     */ import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
/*     */ import org.jboss.aspects.remoting.Remoting;
/*     */ import org.jboss.aspects.security.SecurityClientInterceptor;
/*     */ import org.jboss.deployers.client.spi.Deployment;
/*     */ import org.jboss.deployers.client.spi.main.MainDeployer;
/*     */ import org.jboss.deployers.spi.management.DeploymentTemplate;
/*     */ import org.jboss.deployers.spi.management.DeploymentTemplateInfo;
/*     */ import org.jboss.deployers.spi.management.ManagementView;
/*     */ import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeployment;
/*     */ import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.managed.api.ComponentType;
/*     */ import org.jboss.managed.api.ManagedComponent;
/*     */ import org.jboss.managed.api.ManagedDeployment;
/*     */ import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
/*     */ import org.jboss.managed.api.ManagedObject;
/*     */ import org.jboss.managed.api.ManagedOperation;
/*     */ import org.jboss.managed.api.ManagedOperation.Impact;
/*     */ import org.jboss.managed.api.ManagedParameter;
/*     */ import org.jboss.managed.api.ManagedProperty;
/*     */ import org.jboss.managed.api.annotation.ManagementComponent;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementObjectID;
/*     */ import org.jboss.managed.api.annotation.ManagementObjectRef;
/*     */ import org.jboss.managed.plugins.ManagedComponentImpl;
/*     */ import org.jboss.managed.plugins.ManagedObjectImpl;
/*     */ import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
/*     */ import org.jboss.metatype.api.types.ArrayMetaType;
/*     */ import org.jboss.metatype.api.types.CollectionMetaType;
/*     */ import org.jboss.metatype.api.types.MetaType;
/*     */ import org.jboss.metatype.api.values.ArrayValue;
/*     */ import org.jboss.metatype.api.values.CollectionValue;
/*     */ import org.jboss.metatype.api.values.GenericValue;
/*     */ import org.jboss.metatype.api.values.MetaValue;
/*     */ import org.jboss.metatype.api.values.MetaValueFactory;
/*     */ import org.jboss.metatype.api.values.SimpleValue;
/*     */ import org.jboss.metatype.api.values.SimpleValueSupport;
/*     */ import org.jboss.profileservice.spi.AttachmentsSerializer;
/*     */ import org.jboss.profileservice.spi.NoSuchDeploymentException;
/*     */ import org.jboss.profileservice.spi.NoSuchProfileException;
/*     */ import org.jboss.profileservice.spi.Profile;
/*     */ import org.jboss.profileservice.spi.ProfileKey;
/*     */ import org.jboss.profileservice.spi.ProfileService;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.virtual.VirtualFile;
/*     */ 
/*     */ public class ManagementViewImpl
/*     */   implements ManagementView
/*     */ {
/*  97 */   private static Logger log = Logger.getLogger(ManagementViewImpl.class);
/*     */   private static final String BUNDLE_NAME = "org.jboss.profileservice.management.messages";
/* 101 */   private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
/*     */   private ProfileService ps;
/*     */   private Profile activeProfile;
/*     */   private MainDeployer mainDeployer;
/*     */   private AttachmentsSerializer serializer;
/*     */   private InvokerLocator locator;
/* 114 */   private HashMap<String, DeploymentTemplate> templates = new HashMap();
/*     */   private ResourceBundle i18n;
/*     */   private Locale currentLocale;
/* 120 */   private MessageFormat formatter = new MessageFormat("");
/*     */ 
/* 122 */   private HashMap<ComponentType, Set<ManagedComponent>> compByCompType = new HashMap();
/*     */ 
/* 124 */   private Map<String, ManagedObject> moRegistry = new HashMap();
/*     */ 
/* 126 */   private Map<String, ManagedDeployment> managedDeployments = new HashMap();
/*     */ 
/* 128 */   private Map<String, Set<ManagedProperty>> unresolvedRefs = new HashMap();
/*     */ 
/* 132 */   private Map<String, ManagedObject> runtimeMOs = new HashMap();
/*     */   private RuntimeComponentDispatcher dispatcher;
/*     */ 
/*     */   public ManagementViewImpl()
/*     */   {
/* 138 */     this.currentLocale = Locale.getDefault();
/* 139 */     this.formatter.setLocale(this.currentLocale);
/* 140 */     this.i18n = ResourceBundle.getBundle("org.jboss.profileservice.management.messages", this.currentLocale);
/*     */   }
/*     */ 
/*     */   public void loadProfile(ProfileKey key)
/*     */     throws Exception
/*     */   {
/* 153 */     this.activeProfile = this.ps.getProfile(key);
/* 154 */     if (this.activeProfile == null)
/*     */     {
/* 156 */       this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchProfileException"));
/* 157 */       Object[] args = { key };
/* 158 */       String msg = this.formatter.format(args);
/* 159 */       throw new NoSuchProfileException(msg);
/*     */     }
/*     */ 
/* 163 */     Set deploymentNames = this.activeProfile.getDeploymentNames();
/* 164 */     for (String name : deploymentNames)
/*     */     {
/*     */       try
/*     */       {
/* 168 */         ManagedDeployment md = this.mainDeployer.getManagedDeployment(name);
/* 169 */         processManagedDeployment(md, 0, log.isTraceEnabled());
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 173 */         log.warn("Failed to create ManagedDeployment for: " + name, e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processManagedDeployment(ManagedDeployment md, int level, boolean trace)
/*     */     throws Exception
/*     */   {
/* 188 */     String name = md.getName();
/* 189 */     if (trace)
/* 190 */       log.trace(name + " ManagedDeployment_" + level + ": " + md);
/* 191 */     Map mos = md.getManagedObjects();
/* 192 */     if (trace)
/* 193 */       log.trace(name + " ManagedObjects_ " + level + ": " + mos);
/* 194 */     for (ManagedObject mo : mos.values())
/*     */     {
/* 196 */       processManagedObject(mo, md);
/*     */     }
/* 198 */     this.managedDeployments.put(name, md);
/* 199 */     List mdChildren = md.getChildren();
/* 200 */     if ((mdChildren != null) && (!mdChildren.isEmpty()))
/*     */     {
/* 202 */       for (ManagedDeployment mdChild : mdChildren)
/*     */       {
/* 204 */         processManagedDeployment(mdChild, level + 1, trace);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void processManagedObject(ManagedObject mo, ManagedDeployment md)
/*     */     throws Exception
/*     */   {
/* 218 */     String key = mo.getName() + "/" + mo.getNameType();
/* 219 */     log.debug("ID for ManagedObject: " + key + ", attachmentName: " + mo.getAttachmentName());
/*     */ 
/* 222 */     Map moAnns = mo.getAnnotations();
/* 223 */     ManagementObject managementObject = (ManagementObject)moAnns.get(ManagementObject.class.getName());
/* 224 */     if (managementObject.isRuntime())
/*     */     {
/* 227 */       ManagedObject parentMO = (ManagedObject)this.moRegistry.get(key);
/* 228 */       if (parentMO == null)
/*     */       {
/* 231 */         this.runtimeMOs.put(key, mo);
/*     */       }
/*     */       else
/*     */       {
/* 235 */         mergeRuntimeMO(parentMO, mo);
/* 236 */         this.runtimeMOs.remove(key);
/*     */       }
/*     */ 
/* 239 */       return;
/*     */     }
/*     */ 
/* 244 */     ManagedObject runtimeMO = (ManagedObject)this.runtimeMOs.get(key);
/* 245 */     if (runtimeMO != null)
/*     */     {
/* 247 */       mergeRuntimeMO(mo, runtimeMO);
/* 248 */       this.runtimeMOs.remove(key);
/*     */     }
/*     */ 
/* 253 */     ManagedObject prevMO = (ManagedObject)this.moRegistry.put(key, mo);
/* 254 */     if (prevMO != null)
/*     */     {
/* 257 */       log.debug("Duplicate mo for key: " + key + ", prevMO: " + prevMO);
/*     */     }
/*     */ 
/* 260 */     checkForReferences(key, mo);
/*     */ 
/* 263 */     ManagementComponent mc = (ManagementComponent)moAnns.get(ManagementComponent.class.getName());
/* 264 */     if (mc != null)
/*     */     {
/* 266 */       log.debug("Processing ManagementComponent: " + mc);
/* 267 */       ComponentType type = new ComponentType(mc.type(), mc.subtype());
/* 268 */       ManagedComponentImpl comp = new ManagedComponentImpl(type, md, mo);
/* 269 */       md.addComponent(mo.getName(), comp);
/* 270 */       Set typeComps = (Set)this.compByCompType.get(type);
/* 271 */       if (typeComps == null)
/*     */       {
/* 273 */         typeComps = new HashSet();
/* 274 */         this.compByCompType.put(type, typeComps);
/*     */       }
/* 276 */       typeComps.add(comp);
/*     */     }
/*     */ 
/* 280 */     for (ManagedProperty prop : mo.getProperties().values())
/*     */     {
/* 282 */       log.debug("Checking property: " + prop);
/*     */ 
/* 284 */       Map pannotations = prop.getAnnotations();
/* 285 */       if ((pannotations != null) && (!pannotations.isEmpty()))
/*     */       {
/* 287 */         ManagementObjectID id = (ManagementObjectID)pannotations.get(ManagementObjectID.class.getName());
/* 288 */         if (id != null)
/*     */         {
/* 290 */           Object refName = getRefName(prop.getValue());
/* 291 */           if (refName == null)
/* 292 */             refName = id.name();
/* 293 */           String propKey = refName + "/" + id.type();
/* 294 */           log.debug("ManagedProperty level ID for ManagedObject: " + propKey + ", attachmentName: " + mo.getAttachmentName());
/* 295 */           this.moRegistry.put(propKey, mo);
/* 296 */           checkForReferences(propKey, mo);
/*     */         }
/*     */ 
/* 299 */         ManagementObjectRef ref = (ManagementObjectRef)pannotations.get(ManagementObjectRef.class.getName());
/* 300 */         if (ref != null)
/*     */         {
/* 303 */           log.debug("Property(" + prop.getName() + ") references: " + ref);
/* 304 */           Object refName = getRefName(prop.getValue());
/* 305 */           if (refName == null)
/* 306 */             refName = ref.name();
/* 307 */           String targetKey = refName + "/" + ref.type();
/* 308 */           ManagedObject target = (ManagedObject)this.moRegistry.get(targetKey);
/* 309 */           if (target != null)
/*     */           {
/* 311 */             log.debug("Resolved property(" + prop.getName() + ") reference to: " + targetKey);
/* 312 */             prop.setTargetManagedObject(target);
/*     */           }
/*     */           else
/*     */           {
/* 316 */             Set referers = (Set)this.unresolvedRefs.get(targetKey);
/* 317 */             if (referers == null)
/*     */             {
/* 319 */               referers = new HashSet();
/* 320 */               this.unresolvedRefs.put(targetKey, referers);
/*     */             }
/* 322 */             referers.add(prop);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 327 */       MetaType propType = prop.getMetaType();
/* 328 */       if (propType == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE)
/*     */       {
/* 330 */         processGenericValue((GenericValue)prop.getValue(), md);
/*     */       }
/* 332 */       else if (propType.isArray())
/*     */       {
/* 334 */         ArrayMetaType amt = (ArrayMetaType)propType;
/* 335 */         MetaType etype = amt.getElementType();
/* 336 */         if (etype == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE)
/*     */         {
/* 338 */           ArrayValue avalue = (ArrayValue)prop.getValue();
/* 339 */           int length = avalue != null ? avalue.getLength() : 0;
/* 340 */           for (int n = 0; n < length; n++)
/* 341 */             processGenericValue((GenericValue)avalue.getValue(n), md);
/*     */         }
/*     */       }
/* 344 */       else if (propType.isCollection())
/*     */       {
/* 346 */         CollectionMetaType amt = (CollectionMetaType)propType;
/* 347 */         MetaType etype = amt.getElementType();
/* 348 */         if (etype == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE)
/*     */         {
/* 350 */           CollectionValue avalue = (CollectionValue)prop.getValue();
/* 351 */           if (avalue != null)
/*     */           {
/* 353 */             MetaValue[] elements = avalue.getElements();
/* 354 */             for (int n = 0; n < avalue.getSize(); n++)
/*     */             {
/* 356 */               GenericValue gv = (GenericValue)elements[n];
/* 357 */               ManagedObject propMO = (ManagedObject)gv.getValue();
/* 358 */               if (propMO != null)
/* 359 */                 processManagedObject(propMO, md);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object getRefName(Object value)
/*     */   {
/* 375 */     if ((value instanceof MetaValue))
/*     */     {
/* 377 */       MetaValue metaValue = (MetaValue)value;
/* 378 */       if (!metaValue.getMetaType().isSimple())
/* 379 */         throw new IllegalArgumentException("Can only get ref from simple value: " + value);
/* 380 */       return ((SimpleValue)metaValue).getValue();
/*     */     }
/* 382 */     return value;
/*     */   }
/*     */ 
/*     */   protected void processGenericValue(GenericValue genericValue, ManagedDeployment md)
/*     */     throws Exception
/*     */   {
/* 395 */     if (genericValue != null)
/*     */     {
/* 397 */       ManagedObject propMO = (ManagedObject)genericValue.getValue();
/*     */ 
/* 399 */       if (propMO != null)
/* 400 */         processManagedObject(propMO, md);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Map<String, Set<ManagedProperty>> getUnresolvedRefs()
/*     */   {
/* 406 */     return this.unresolvedRefs;
/*     */   }
/*     */ 
/*     */   public ProfileService getProfileService()
/*     */   {
/* 411 */     return this.ps;
/*     */   }
/*     */ 
/*     */   public void setProfileService(ProfileService ps)
/*     */   {
/* 416 */     this.ps = ps;
/* 417 */     log.debug("setProfileService: " + ps);
/*     */   }
/*     */ 
/*     */   public InvokerLocator getLocator()
/*     */   {
/* 422 */     return this.locator;
/*     */   }
/*     */ 
/*     */   public void setLocator(InvokerLocator locator)
/*     */   {
/* 427 */     this.locator = locator;
/*     */   }
/*     */ 
/*     */   public AttachmentsSerializer getSerializer()
/*     */   {
/* 432 */     return this.serializer;
/*     */   }
/*     */ 
/*     */   public void setSerializer(AttachmentsSerializer serializer)
/*     */   {
/* 437 */     this.serializer = serializer;
/*     */   }
/*     */ 
/*     */   public MainDeployer getMainDeployer()
/*     */   {
/* 442 */     return this.mainDeployer;
/*     */   }
/*     */ 
/*     */   public void setMainDeployer(MainDeployer mainDeployer)
/*     */   {
/* 447 */     this.mainDeployer = mainDeployer;
/* 448 */     log.debug("setMainDeployer: " + mainDeployer);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 453 */     return getClass().getName();
/*     */   }
/*     */ 
/*     */   public void setDispatcher(RuntimeComponentDispatcher dispatcher)
/*     */   {
/* 458 */     this.dispatcher = dispatcher;
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNames()
/*     */   {
/* 466 */     return this.activeProfile.getDeploymentNames();
/*     */   }
/*     */ 
/*     */   public Set<String> getDeploymentNamesForType(String type)
/*     */   {
/* 477 */     return this.activeProfile.getDeploymentNamesForType(type);
/*     */   }
/*     */ 
/*     */   public Set<String> getMatchingDeploymentName(String regex)
/*     */     throws NoSuchDeploymentException
/*     */   {
/* 483 */     Set names = getDeploymentNames();
/* 484 */     HashSet matches = new HashSet();
/* 485 */     Pattern p = Pattern.compile(regex);
/* 486 */     for (String name : names)
/*     */     {
/* 488 */       Matcher m = p.matcher(name);
/* 489 */       if (m.matches())
/* 490 */         matches.add(name);
/*     */     }
/* 492 */     if (matches.size() == 0)
/*     */     {
/* 494 */       this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
/* 495 */       Object[] args = { regex };
/* 496 */       String msg = this.formatter.format(args);
/* 497 */       throw new NoSuchDeploymentException(msg);
/*     */     }
/* 499 */     return matches;
/*     */   }
/*     */ 
/*     */   public Set<String> getTemplateNames()
/*     */   {
/* 504 */     return new HashSet(this.templates.keySet());
/*     */   }
/*     */ 
/*     */   public void addTemplate(DeploymentTemplate template)
/*     */   {
/* 509 */     this.templates.put(template.getInfo().getName(), template);
/* 510 */     log.debug("addTemplate: " + template);
/*     */   }
/*     */ 
/*     */   public void removeTemplate(DeploymentTemplate template)
/*     */   {
/* 515 */     this.templates.remove(template.getInfo().getName());
/* 516 */     log.debug("removeTemplate: " + template);
/*     */   }
/*     */ 
/*     */   public ManagedDeployment getDeployment(String name, ManagedDeployment.DeploymentPhase phase)
/*     */     throws NoSuchDeploymentException, Exception
/*     */   {
/* 528 */     Deployment ctx = this.activeProfile.getDeployment(name, phase);
/* 529 */     ManagedDeployment md = getManagedDeployment(ctx);
/* 530 */     log.debug("getDeployment, name=" + name + ", md=" + md);
/* 531 */     return md;
/*     */   }
/*     */ 
/*     */   public Set<ManagedDeployment> getDeploymentsForType(String type)
/*     */     throws Exception
/*     */   {
/* 544 */     Set names = getDeploymentNamesForType(type);
/* 545 */     HashSet mds = new HashSet();
/* 546 */     for (String name : names)
/*     */     {
/* 548 */       Deployment ctx = this.activeProfile.getDeployment(name, null);
/* 549 */       ManagedDeployment md = getManagedDeployment(ctx);
/* 550 */       mds.add(md);
/*     */     }
/* 552 */     return mds;
/*     */   }
/*     */ 
/*     */   public Set<ManagedComponent> getComponentsForType(ComponentType type)
/*     */     throws Exception
/*     */   {
/* 565 */     return (Set)this.compByCompType.get(type);
/*     */   }
/*     */ 
/*     */   public DeploymentTemplateInfo getTemplate(String name)
/*     */     throws NoSuchDeploymentException
/*     */   {
/* 571 */     DeploymentTemplate template = (DeploymentTemplate)this.templates.get(name);
/* 572 */     if (template == null)
/*     */     {
/* 574 */       this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
/* 575 */       Object[] args = { name };
/* 576 */       String msg = this.formatter.format(args);
/* 577 */       throw new IllegalStateException(msg);
/*     */     }
/*     */ 
/* 580 */     DeploymentTemplateInfo info = template.getInfo();
/* 581 */     log.debug("getTemplate, " + info);
/* 582 */     return info;
/*     */   }
/*     */ 
/*     */   public void applyTemplate(ManagedDeployment.DeploymentPhase phase, String deploymentBaseName, DeploymentTemplateInfo info)
/*     */     throws Exception
/*     */   {
/* 588 */     DeploymentTemplate template = (DeploymentTemplate)this.templates.get(info.getName());
/* 589 */     if (template == null)
/*     */     {
/* 591 */       this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
/* 592 */       Object[] args = { info.getName() };
/* 593 */       String msg = this.formatter.format(args);
/* 594 */       throw new IllegalStateException(msg);
/*     */     }
/*     */ 
/* 598 */     VirtualFile root = this.activeProfile.getRootFile(phase);
/* 599 */     if (log.isTraceEnabled())
/* 600 */       log.trace("applyTemplate, profile=" + this.activeProfile + ", deploymentBaseName=" + deploymentBaseName + ", phase=" + phase + ", info=" + info);
/* 601 */     VirtualFile vf = template.applyTemplate(root, deploymentBaseName, info);
/* 602 */     VFSDeployment ctx = this.deploymentFactory.createVFSDeployment(vf);
/* 603 */     this.activeProfile.addDeployment(ctx, phase);
/* 604 */     this.mainDeployer.addDeployment(ctx);
/* 605 */     template.updateTemplateDeployment(ctx, info);
/* 606 */     this.mainDeployer.process();
/*     */ 
/* 609 */     Map mos = this.mainDeployer.getManagedObjects(ctx.getName());
/* 610 */     log.debug("applyTemplate, profile=" + this.activeProfile + ", deploymentBaseName=" + deploymentBaseName + ", phase=" + phase + ", :" + mos);
/* 611 */     for (ManagedProperty prop : info.getProperties().values())
/*     */     {
/* 614 */       if (prop.getValue() == null) {
/*     */         continue;
/*     */       }
/* 617 */       ManagedObject mo = prop.getManagedObject();
/* 618 */       ManagedObject ctxMO = (ManagedObject)mos.get(mo.getName());
/* 619 */       if (ctxMO == null)
/*     */       {
/* 621 */         this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplateKey"));
/* 622 */         Object[] args = { mo.getName() };
/* 623 */         String msg = this.formatter.format(args);
/* 624 */         throw new IllegalArgumentException(msg);
/*     */       }
/* 626 */       ManagedProperty ctxProp = ctxMO.getProperty(prop.getName());
/*     */ 
/* 628 */       if (ctxProp == null)
/*     */       {
/* 630 */         String mappedName = prop.getMappedName();
/* 631 */         if (mappedName != null)
/* 632 */           ctxProp = ctxMO.getProperty(mappedName);
/*     */       }
/* 634 */       if (ctxProp == null)
/*     */       {
/* 636 */         this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplateProperty"));
/* 637 */         Object[] args = { prop.getName() };
/* 638 */         String msg = this.formatter.format(args);
/* 639 */         throw new IllegalArgumentException(msg);
/*     */       }
/*     */ 
/* 646 */       Object value = prop.getValue();
/*     */       Serializable serializable;
/*     */       Serializable serializable;
/*     */       MetaValue metaValue;
/* 647 */       if ((value instanceof MetaValue))
/*     */       {
/* 649 */         MetaValue metaValue = (MetaValue)value;
/* 650 */         MetaType metaType = metaValue.getMetaType();
/*     */         Serializable serializable;
/* 651 */         if (metaType.isSimple()) {
/* 652 */           serializable = ((SimpleValue)metaValue).getValue();
/*     */         }
/*     */         else
/*     */         {
/*     */           Serializable serializable;
/* 653 */           if (metaType.isGeneric())
/* 654 */             serializable = ((GenericValue)metaValue).getValue();
/*     */           else
/* 656 */             serializable = null;
/*     */         }
/*     */       }
/*     */       else {
/* 660 */         serializable = (Serializable)value;
/* 661 */         metaValue = MetaValueFactory.getInstance().create(value);
/*     */       }
/*     */ 
/* 664 */       if (serializable != null) {
/* 665 */         ctxProp.setValue(serializable);
/*     */       }
/* 667 */       Object componentName = getComponentName(ctxProp);
/* 668 */       if (componentName != null)
/* 669 */         this.dispatcher.set(componentName, ctxProp.getName(), metaValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void removeDeployment(String deploymentName, ManagedDeployment.DeploymentPhase phase)
/*     */     throws NoSuchProfileException, NoSuchDeploymentException, Exception
/*     */   {
/* 676 */     Deployment ctx = this.activeProfile.removeDeployment(deploymentName, phase);
/* 677 */     if (ctx == null)
/*     */     {
/* 679 */       this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
/* 680 */       Object[] args = { deploymentName };
/* 681 */       String msg = this.formatter.format(args);
/* 682 */       throw new NoSuchDeploymentException(msg);
/*     */     }
/*     */ 
/* 685 */     if (!this.mainDeployer.removeDeployment(ctx.getName()))
/* 686 */       throw new NoSuchDeploymentException("MainDeployer failed to remove: " + ctx.getName());
/*     */   }
/*     */ 
/*     */   public void process()
/*     */     throws Exception
/*     */   {
/* 696 */     this.mainDeployer.process();
/* 697 */     this.mainDeployer.checkComplete();
/*     */   }
/*     */ 
/*     */   public void updateComponent(ManagedComponent comp)
/*     */     throws Exception
/*     */   {
/* 704 */     ManagedDeployment md = comp.getDeployment();
/* 705 */     while (md.getParent() != null)
/* 706 */       md = md.getParent();
/* 707 */     String name = md.getName();
/* 708 */     ManagedDeployment.DeploymentPhase phase = md.getDeploymentPhase();
/* 709 */     Deployment mdCtx = this.activeProfile.getDeployment(name, phase);
/* 710 */     if (mdCtx == null)
/*     */     {
/* 712 */       this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
/* 713 */       Object[] args = { name };
/* 714 */       String msg = this.formatter.format(args);
/* 715 */       throw new NoSuchDeploymentException(msg);
/*     */     }
/*     */ 
/* 719 */     ManagedDeployment compMD = (ManagedDeployment)this.managedDeployments.get(md.getName());
/* 720 */     log.debug("updateComponent, profile=" + this.activeProfile + ", deploymentName=" + name + ", phase=" + phase + ", :" + compMD);
/* 721 */     ManagedComponent serverComp = compMD.getComponent(comp.getName());
/* 722 */     for (ManagedProperty prop : comp.getProperties().values())
/*     */     {
/* 725 */       if (prop.getValue() == null) {
/*     */         continue;
/*     */       }
/* 728 */       ManagedProperty ctxProp = (ManagedProperty)serverComp.getProperties().get(prop.getName());
/*     */ 
/* 730 */       if (ctxProp == null)
/*     */       {
/* 732 */         String mappedName = prop.getMappedName();
/* 733 */         if (mappedName != null)
/* 734 */           ctxProp = (ManagedProperty)serverComp.getProperties().get(mappedName);
/*     */       }
/* 736 */       if (ctxProp == null)
/*     */       {
/* 738 */         this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplateProperty"));
/* 739 */         Object[] args = { prop.getName() };
/* 740 */         String msg = this.formatter.format(args);
/* 741 */         throw new IllegalArgumentException(msg);
/*     */       }
/*     */ 
/* 748 */       Object value = prop.getValue();
/*     */       Serializable serializable;
/*     */       Serializable serializable;
/*     */       MetaValue metaValue;
/* 749 */       if ((value instanceof MetaValue))
/*     */       {
/* 751 */         MetaValue metaValue = (MetaValue)value;
/* 752 */         MetaType metaType = metaValue.getMetaType();
/*     */         Serializable serializable;
/* 753 */         if (metaType.isSimple()) {
/* 754 */           serializable = ((SimpleValue)metaValue).getValue();
/*     */         }
/*     */         else
/*     */         {
/*     */           Serializable serializable;
/* 755 */           if (metaType.isGeneric())
/* 756 */             serializable = ((GenericValue)metaValue).getValue();
/*     */           else
/* 758 */             serializable = null;
/*     */         }
/*     */       }
/*     */       else {
/* 762 */         serializable = (Serializable)value;
/* 763 */         metaValue = SimpleValueSupport.wrap(serializable);
/*     */       }
/* 765 */       ctxProp.setValue(serializable);
/* 766 */       Object componentName = getComponentName(ctxProp);
/* 767 */       if (componentName != null)
/* 768 */         this.dispatcher.set(componentName, ctxProp.getName(), metaValue);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Object getComponentName(ManagedProperty property)
/*     */   {
/* 781 */     ManagedObject targetObject = property.getTargetManagedObject();
/* 782 */     if (targetObject != null) {
/* 783 */       return targetObject.getComponentName();
/*     */     }
/*     */ 
/* 786 */     targetObject = property.getManagedObject();
/* 787 */     return targetObject != null ? targetObject.getComponentName() : null;
/*     */   }
/*     */ 
/*     */   protected void checkForReferences(String key, ManagedObject mo)
/*     */   {
/* 792 */     Set referers = (Set)this.unresolvedRefs.get(key);
/* 793 */     log.debug("checkForReferences, " + key + " has referers: " + referers);
/* 794 */     if (referers != null)
/*     */     {
/* 796 */       for (ManagedProperty prop : referers)
/*     */       {
/* 798 */         prop.setTargetManagedObject(mo);
/*     */       }
/* 800 */       this.unresolvedRefs.remove(key);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void mergeRuntimeMO(ManagedObject mo, ManagedObject runtimeMO)
/*     */     throws Exception
/*     */   {
/* 813 */     Map moProps = mo.getProperties();
/* 814 */     Set moOps = mo.getOperations();
/* 815 */     HashMap props = new HashMap(moProps);
/* 816 */     HashSet ops = new HashSet(moOps);
/*     */ 
/* 818 */     Map runtimeProps = runtimeMO.getProperties();
/* 819 */     Set runtimeOps = runtimeMO.getOperations();
/*     */ 
/* 821 */     if (runtimeProps != null)
/* 822 */       props.putAll(runtimeProps);
/* 823 */     if (runtimeOps != null)
/*     */     {
/* 825 */       runtimeOps = createOperationProxies(runtimeMO, runtimeOps);
/* 826 */       ops.addAll(runtimeOps);
/*     */     }
/*     */ 
/* 829 */     ManagedObjectImpl moi = (ManagedObjectImpl)mo;
/* 830 */     moi.setProperties(props);
/* 831 */     moi.setOperations(ops);
/*     */   }
/*     */ 
/*     */   protected Set<ManagedOperation> createOperationProxies(ManagedObject mo, Set<ManagedOperation> ops)
/*     */     throws Exception
/*     */   {
/* 847 */     if (this.dispatcher == null) {
/* 848 */       throw new IllegalArgumentException("Missing RuntimeComponentDispatcher.");
/*     */     }
/* 850 */     ClassLoader loader = getClass().getClassLoader();
/* 851 */     ArrayList interceptors = new ArrayList();
/* 852 */     interceptors.add(SecurityClientInterceptor.singleton);
/* 853 */     interceptors.add(MergeMetaDataInterceptor.singleton);
/* 854 */     interceptors.add(InvokeRemoteInterceptor.singleton);
/*     */ 
/* 857 */     HashSet opProxies = new HashSet();
/* 858 */     Class[] ifaces = { ManagedOperation.class };
/* 859 */     for (ManagedOperation op : ops)
/*     */     {
/* 861 */       String dispatchName = "ProfileService.ManagedOperation@" + System.identityHashCode(op);
/* 862 */       Dispatcher.singleton.registerTarget(dispatchName, new ManagedOperationDelegate(op, mo));
/* 863 */       ManagedOperation opProxy = (ManagedOperation)Remoting.createRemoteProxy(dispatchName, loader, ifaces, this.locator, interceptors, "ProfileService");
/*     */ 
/* 865 */       opProxies.add(opProxy);
/*     */     }
/* 867 */     return opProxies;
/*     */   }
/*     */ 
/*     */   private ManagedDeployment getManagedDeployment(Deployment ctx)
/*     */     throws Exception
/*     */   {
/* 873 */     return this.mainDeployer.getManagedDeployment(ctx.getName());
/*     */   }
/*     */ 
/*     */   public class ManagedOperationDelegate implements ManagedOperation {
/*     */     private ManagedOperation delegate;
/*     */     private ManagedObject managedObject;
/*     */ 
/*     */     public ManagedOperationDelegate(ManagedOperation delegate, ManagedObject managedObject) {
/* 883 */       if (delegate == null)
/* 884 */         throw new IllegalArgumentException("Null delegate.");
/* 885 */       this.delegate = delegate;
/* 886 */       if (managedObject == null)
/* 887 */         throw new IllegalArgumentException("Null managed object.");
/* 888 */       this.managedObject = managedObject;
/*     */     }
/*     */ 
/*     */     public Object invoke(MetaValue[] metaValues)
/*     */     {
/* 893 */       Object componentName = this.managedObject.getComponentName();
/* 894 */       if (componentName != null) {
/* 895 */         return ManagementViewImpl.this.dispatcher.invoke(componentName, this.delegate.getName(), metaValues);
/*     */       }
/* 897 */       return null;
/*     */     }
/*     */ 
/*     */     public String getDescription()
/*     */     {
/* 902 */       return this.delegate.getDescription();
/*     */     }
/*     */ 
/*     */     public String getName()
/*     */     {
/* 907 */       return this.delegate.getName();
/*     */     }
/*     */ 
/*     */     public ManagedOperation.Impact getImpact()
/*     */     {
/* 912 */       return this.delegate.getImpact();
/*     */     }
/*     */ 
/*     */     public MetaType getReturnType()
/*     */     {
/* 917 */       return this.delegate.getReturnType();
/*     */     }
/*     */ 
/*     */     public ManagedParameter[] getParameters()
/*     */     {
/* 922 */       return this.delegate.getParameters();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.ManagementViewImpl
 * JD-Core Version:    0.6.0
 */