/*    */ package org.jboss.profileservice.management;
/*    */ 
/*    */ import java.lang.reflect.UndeclaredThrowableException;
/*    */ import org.jboss.kernel.spi.registry.KernelBus;
/*    */ import org.jboss.metatype.api.values.MetaValue;
/*    */ import org.jboss.metatype.api.values.MetaValueFactory;
/*    */ 
/*    */ public class KernelBusRuntimeComponentDispatcher extends AbstractRuntimeComponentDispatcher
/*    */ {
/*    */   private KernelBus bus;
/*    */ 
/*    */   public KernelBusRuntimeComponentDispatcher(KernelBus bus)
/*    */   {
/* 41 */     this(bus, null);
/*    */   }
/*    */ 
/*    */   public KernelBusRuntimeComponentDispatcher(KernelBus bus, MetaValueFactory valueFactory)
/*    */   {
/* 46 */     super(valueFactory);
/* 47 */     if (bus == null)
/* 48 */       throw new IllegalArgumentException("Null kernel bus.");
/* 49 */     this.bus = bus;
/*    */   }
/*    */ 
/*    */   public MetaValue get(Object componentName, String propertyName)
/*    */   {
/*    */     try
/*    */     {
/* 56 */       return create(this.bus.get(componentName, propertyName));
/*    */     }
/*    */     catch (Throwable t) {
/*    */     }
/* 60 */     throw new UndeclaredThrowableException(t);
/*    */   }
/*    */ 
/*    */   public void set(Object componentName, String propertyName, MetaValue value)
/*    */   {
/*    */     try
/*    */     {
/* 68 */       this.bus.set(componentName, propertyName, unwrap(value));
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 72 */       throw new UndeclaredThrowableException(t);
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object invoke(Object componentName, String methodName, MetaValue[] param)
/*    */   {
/*    */     try
/*    */     {
/* 80 */       return this.bus.invoke(componentName, methodName, toArguments(param), toSignature(param));
/*    */     }
/*    */     catch (Throwable t) {
/*    */     }
/* 84 */     throw new UndeclaredThrowableException(t);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.management.KernelBusRuntimeComponentDispatcher
 * JD-Core Version:    0.6.0
 */