/*     */ package org.jboss.profileservice.aop;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
/*     */ import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
/*     */ import org.jboss.deployers.spi.attachments.Attachments;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class TrackingAdvice
/*     */ {
/*  43 */   private static Logger log = Logger.getLogger(TrackingAdvice.class);
/*  44 */   private static ConcurrentHashMap<Object, Map<String, Object>> attachmentsByTarget = new ConcurrentHashMap();
/*     */ 
/*  46 */   private static boolean trace = true;
/*     */ 
/*     */   public static Attachments wrapAttachments(Attachments attachments)
/*     */   {
/*  50 */     return (Attachments)createProxy(attachments, Attachments.class);
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation inv)
/*     */     throws Throwable
/*     */   {
/*  56 */     if (trace)
/*  57 */       log.trace("invoke, " + inv);
/*  58 */     return inv.invokeNext();
/*     */   }
/*     */ 
/*     */   public Object addAttachment(MethodInvocation mi)
/*     */     throws Throwable
/*     */   {
/*  64 */     if (trace)
/*  65 */       log.trace(mi);
/*  66 */     Object target = mi.getTargetObject();
/*  67 */     Object[] args = mi.getArguments();
/*  68 */     Object value = mi.invokeNext();
/*     */     Object attachment;
/*     */     String name;
/*     */     Object attachment;
/*  72 */     if ((args[0] instanceof Class))
/*     */     {
/*  74 */       Class c = (Class)Class.class.cast(args[0]);
/*  75 */       String name = c.getName();
/*  76 */       attachment = args[1];
/*     */     }
/*     */     else
/*     */     {
/*  82 */       name = (String)String.class.cast(args[0]);
/*  83 */       attachment = args[1];
/*     */     }
/*  85 */     addAttachment(target, name, attachment);
/*  86 */     return value;
/*     */   }
/*     */ 
/*     */   public static Object removeAttachment(MethodInvocation mi)
/*     */     throws Throwable
/*     */   {
/*  92 */     Object target = mi.getTargetObject();
/*  93 */     Object[] args = mi.getArguments();
/*  94 */     Object value = mi.invokeNext();
/*     */     String name;
/*     */     String name;
/*  97 */     if ((args[0] instanceof Class))
/*     */     {
/*  99 */       Class c = (Class)Class.class.cast(args[0]);
/* 100 */       name = c.getName();
/*     */     }
/*     */     else
/*     */     {
/* 106 */       name = (String)String.class.cast(args[0]);
/*     */     }
/* 108 */     removeAttachment(target, name);
/* 109 */     return value;
/*     */   }
/*     */ 
/*     */   public static Map<String, Object> getAttachmentsForTarget(Object key)
/*     */   {
/* 114 */     Map attachments = (Map)attachmentsByTarget.get(key);
/* 115 */     return attachments;
/*     */   }
/*     */ 
/*     */   public static Map<String, Object> clearAttachmentsForTarget(Object key) {
/* 119 */     Map attachments = (Map)attachmentsByTarget.remove(key);
/* 120 */     if (trace)
/* 121 */       log.trace("clearAttachmentsForTarget, target=" + key + " :" + attachments);
/* 122 */     return attachments;
/*     */   }
/*     */ 
/*     */   private static void addAttachment(Object target, String name, Object attachment)
/*     */   {
/* 127 */     Map attachments = (Map)attachmentsByTarget.get(target);
/* 128 */     if (attachments == null)
/*     */     {
/* 130 */       attachments = new HashMap();
/* 131 */       attachmentsByTarget.put(target, attachments);
/*     */     }
/* 133 */     attachments.put(name, attachment);
/* 134 */     if (trace)
/* 135 */       log.trace("addAttachment, target=" + target + ", name=" + name + ", attachment=" + attachment);
/*     */   }
/*     */ 
/*     */   private static void removeAttachment(Object target, String name) {
/* 139 */     Map attachments = (Map)attachmentsByTarget.get(target);
/* 140 */     if (attachments != null)
/*     */     {
/* 142 */       attachments.remove(name);
/* 143 */       if (attachments.size() == 0)
/* 144 */         attachmentsByTarget.remove(target);
/*     */     }
/* 146 */     if (trace)
/* 147 */       log.trace("removeAttachment, target=" + target + ", name=" + name);
/*     */   }
/*     */ 
/*     */   public static <T> T createProxy(T target, Class<T> interfaceClass)
/*     */   {
/* 160 */     if (target == null) {
/* 161 */       return null;
/*     */     }
/* 163 */     GeneratedAOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
/* 164 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 165 */     params.setInterfaces(new Class[] { interfaceClass });
/* 166 */     params.setObjectAsSuperClass(true);
/* 167 */     params.setTarget(target);
/* 168 */     Object proxy = proxyFactory.createAdvisedProxy(params);
/* 169 */     if (trace)
/* 170 */       log.trace("Created proxy: " + proxy.getClass() + "@" + System.identityHashCode(proxy) + " target: " + target.getClass());
/* 171 */     return interfaceClass.cast(proxy);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.profileservice.aop.TrackingAdvice
 * JD-Core Version:    0.6.0
 */