/*     */ package org.jboss.net.sockets;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.rmi.server.RMIServerSocketFactory;
/*     */ 
/*     */ public class TimeoutServerSocketFactory
/*     */   implements RMIServerSocketFactory, Serializable
/*     */ {
/*     */   static final long serialVersionUID = 7006964274840965634L;
/*     */   protected transient InetAddress bindAddress;
/*  44 */   protected int backlog = 200;
/*     */ 
/*     */   public TimeoutServerSocketFactory()
/*     */   {
/*  52 */     this(null, 200);
/*     */   }
/*     */ 
/*     */   public TimeoutServerSocketFactory(InetAddress bindAddress)
/*     */   {
/*  60 */     this(bindAddress, 200);
/*     */   }
/*     */ 
/*     */   public TimeoutServerSocketFactory(int backlog)
/*     */   {
/*  68 */     this(null, backlog);
/*     */   }
/*     */ 
/*     */   public TimeoutServerSocketFactory(InetAddress bindAddress, int backlog)
/*     */   {
/*  76 */     this.bindAddress = bindAddress;
/*  77 */     this.backlog = backlog;
/*     */   }
/*     */ 
/*     */   public String getBindAddress()
/*     */   {
/*  82 */     String address = null;
/*  83 */     if (this.bindAddress != null)
/*  84 */       address = this.bindAddress.getHostAddress();
/*  85 */     return address;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(String host) throws UnknownHostException
/*     */   {
/*  90 */     this.bindAddress = InetAddress.getByName(host);
/*     */   }
/*     */ 
/*     */   public void setBindAddress(InetAddress bindAddress) {
/*  94 */     this.bindAddress = bindAddress;
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port)
/*     */     throws IOException
/*     */   {
/* 109 */     ServerSocket activeSocket = new TimeoutServerSocket(port, this.backlog, this.bindAddress);
/* 110 */     return activeSocket;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 115 */     return obj instanceof TimeoutServerSocketFactory;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 120 */     return getClass().getName().hashCode();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.sockets.TimeoutServerSocketFactory
 * JD-Core Version:    0.6.0
 */