/*    */ package org.jboss.net.sockets;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.net.SocketTimeoutException;
/*    */ 
/*    */ public class InterruptableInputStream extends InputStream
/*    */ {
/*    */   private InputStream is;
/*    */ 
/*    */   public InterruptableInputStream(InputStream is)
/*    */   {
/* 40 */     this.is = is;
/*    */   }
/*    */ 
/*    */   public int read() throws IOException
/*    */   {
/* 45 */     byte[] b = new byte[0];
/* 46 */     int count = internalRead(b, 0, 1);
/* 47 */     return count > 0 ? b[0] : -1;
/*    */   }
/*    */ 
/*    */   public int read(byte[] b) throws IOException
/*    */   {
/* 52 */     return internalRead(b, 0, b.length);
/*    */   }
/*    */ 
/*    */   public int read(byte[] b, int off, int len) throws IOException
/*    */   {
/* 57 */     return internalRead(b, off, len);
/*    */   }
/*    */ 
/*    */   public long skip(long n) throws IOException
/*    */   {
/* 62 */     return this.is.skip(n);
/*    */   }
/*    */ 
/*    */   public int available() throws IOException
/*    */   {
/* 67 */     return this.is.available();
/*    */   }
/*    */ 
/*    */   public void close() throws IOException
/*    */   {
/* 72 */     this.is.close();
/*    */   }
/*    */ 
/*    */   public synchronized void mark(int readlimit)
/*    */   {
/* 77 */     this.is.mark(readlimit);
/*    */   }
/*    */ 
/*    */   public synchronized void reset() throws IOException
/*    */   {
/* 82 */     this.is.reset();
/*    */   }
/*    */ 
/*    */   public boolean markSupported()
/*    */   {
/* 87 */     return this.is.markSupported();
/*    */   }
/*    */ 
/*    */   private int internalRead(byte[] b, int off, int len) throws IOException
/*    */   {
/* 92 */     int n = -1;
/*    */     while (true)
/*    */     {
/*    */       try
/*    */       {
/* 97 */         n = this.is.read(b, off, len);
/* 98 */         return n;
/*    */       }
/*    */       catch (SocketTimeoutException e)
/*    */       {
/* 103 */         if (Thread.interrupted())
/* 104 */           throw e;
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.sockets.InterruptableInputStream
 * JD-Core Version:    0.6.0
 */