/*     */ package org.jboss.net.sockets;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.ServerSocket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.rmi.server.RMIServerSocketFactory;
/*     */ import javax.net.ServerSocketFactory;
/*     */ 
/*     */ public class DefaultSocketFactory extends ServerSocketFactory
/*     */   implements RMIServerSocketFactory, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -7626239955727142958L;
/*     */   private transient InetAddress bindAddress;
/*  43 */   private int backlog = 200;
/*     */ 
/*     */   public DefaultSocketFactory()
/*     */   {
/*  50 */     this(null, 200);
/*     */   }
/*     */ 
/*     */   public DefaultSocketFactory(InetAddress bindAddress)
/*     */   {
/*  56 */     this(bindAddress, 200);
/*     */   }
/*     */ 
/*     */   public DefaultSocketFactory(int backlog)
/*     */   {
/*  62 */     this(null, backlog);
/*     */   }
/*     */ 
/*     */   public DefaultSocketFactory(InetAddress bindAddress, int backlog)
/*     */   {
/*  68 */     this.bindAddress = bindAddress;
/*  69 */     this.backlog = backlog;
/*     */   }
/*     */ 
/*     */   public String getBindAddress()
/*     */   {
/*  74 */     String address = null;
/*  75 */     if (this.bindAddress != null)
/*  76 */       address = this.bindAddress.getHostAddress();
/*  77 */     return address;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(String host) throws UnknownHostException {
/*  81 */     this.bindAddress = InetAddress.getByName(host);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port)
/*     */     throws IOException
/*     */   {
/*  95 */     return createServerSocket(port, this.backlog, this.bindAddress);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog)
/*     */     throws IOException
/*     */   {
/* 107 */     return createServerSocket(port, backlog, null);
/*     */   }
/*     */ 
/*     */   public ServerSocket createServerSocket(int port, int backlog, InetAddress inetAddress)
/*     */     throws IOException
/*     */   {
/* 120 */     ServerSocket activeSocket = new ServerSocket(port, backlog, this.bindAddress);
/* 121 */     return activeSocket;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 126 */     boolean equals = obj instanceof DefaultSocketFactory;
/* 127 */     if ((equals) && (this.bindAddress != null))
/*     */     {
/* 129 */       DefaultSocketFactory dsf = (DefaultSocketFactory)obj;
/* 130 */       InetAddress dsfa = dsf.bindAddress;
/* 131 */       if (dsfa != null)
/* 132 */         equals = this.bindAddress.equals(dsfa);
/*     */       else
/* 134 */         equals = false;
/*     */     }
/* 136 */     return equals;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 140 */     int hashCode = getClass().getName().hashCode();
/* 141 */     if (this.bindAddress != null)
/* 142 */       hashCode += this.bindAddress.toString().hashCode();
/* 143 */     return hashCode;
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 147 */     StringBuffer tmp = new StringBuffer(super.toString());
/* 148 */     tmp.append('[');
/* 149 */     tmp.append("bindAddress=");
/* 150 */     tmp.append(this.bindAddress);
/* 151 */     tmp.append(']');
/* 152 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.sockets.DefaultSocketFactory
 * JD-Core Version:    0.6.0
 */