/*     */ package org.jboss.net.sockets;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Serializable;
/*     */ import java.net.InetAddress;
/*     */ import java.net.Socket;
/*     */ import java.net.UnknownHostException;
/*     */ import java.rmi.server.RMIClientSocketFactory;
/*     */ 
/*     */ public class DefaultClientSocketFactory
/*     */   implements RMIClientSocketFactory, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -920483051658660269L;
/*     */   private InetAddress bindAddress;
/*     */ 
/*     */   public String getBindAddress()
/*     */   {
/*  51 */     String address = null;
/*  52 */     if (this.bindAddress != null)
/*  53 */       address = this.bindAddress.getHostAddress();
/*  54 */     return address;
/*     */   }
/*     */ 
/*     */   public void setBindAddress(String host) throws UnknownHostException {
/*  58 */     this.bindAddress = InetAddress.getByName(host);
/*     */   }
/*     */ 
/*     */   public Socket createSocket(String host, int port)
/*     */     throws IOException
/*     */   {
/*  72 */     InetAddress addr = null;
/*  73 */     if (this.bindAddress != null)
/*  74 */       addr = this.bindAddress;
/*     */     else
/*  76 */       addr = InetAddress.getByName(host);
/*  77 */     Socket s = new Socket(addr, port);
/*  78 */     return s;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  83 */     boolean equals = obj instanceof DefaultClientSocketFactory;
/*  84 */     if ((equals) && (this.bindAddress != null))
/*     */     {
/*  86 */       DefaultClientSocketFactory dcsf = (DefaultClientSocketFactory)obj;
/*  87 */       InetAddress dcsfa = dcsf.bindAddress;
/*  88 */       if (dcsfa != null)
/*  89 */         equals = this.bindAddress.equals(dcsfa);
/*     */       else
/*  91 */         equals = false;
/*     */     }
/*  93 */     return equals;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/*  97 */     int hashCode = getClass().getName().hashCode();
/*  98 */     if (this.bindAddress != null)
/*  99 */       hashCode += this.bindAddress.toString().hashCode();
/* 100 */     return hashCode;
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 104 */     StringBuffer tmp = new StringBuffer(super.toString());
/* 105 */     tmp.append('[');
/* 106 */     tmp.append("bindAddress=");
/* 107 */     tmp.append(this.bindAddress);
/* 108 */     tmp.append(']');
/* 109 */     return tmp.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.sockets.DefaultClientSocketFactory
 * JD-Core Version:    0.6.0
 */