/*    */ package org.jboss.net.protocol.resource;
/*    */ 
/*    */ import java.io.FileNotFoundException;
/*    */ import java.io.IOException;
/*    */ import java.net.MalformedURLException;
/*    */ import java.net.URL;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.net.protocol.DelegatingURLConnection;
/*    */ 
/*    */ public class ResourceURLConnection extends DelegatingURLConnection
/*    */ {
/* 44 */   private static final Logger log = Logger.getLogger(ResourceURLConnection.class);
/*    */ 
/*    */   public ResourceURLConnection(URL url)
/*    */     throws MalformedURLException, IOException
/*    */   {
/* 49 */     super(url);
/*    */   }
/*    */ 
/*    */   protected URL makeDelegateUrl(URL url)
/*    */     throws MalformedURLException, IOException
/*    */   {
/* 55 */     String name = url.getHost();
/* 56 */     String file = url.getFile();
/* 57 */     if ((file != null) && (!file.equals("")))
/*    */     {
/* 59 */       name = name + file;
/*    */     }
/*    */ 
/* 64 */     ClassLoader cl = Thread.currentThread().getContextClassLoader();
/* 65 */     URL target = cl.getResource(name);
/*    */ 
/* 67 */     if (target == null)
/*    */     {
/* 69 */       cl = ClassLoader.getSystemClassLoader();
/* 70 */       target = cl.getResource(name);
/*    */     }
/*    */ 
/* 73 */     if (target == null) {
/* 74 */       throw new FileNotFoundException("Could not locate resource: " + name);
/*    */     }
/* 76 */     if (log.isTraceEnabled())
/*    */     {
/* 78 */       log.trace("Target resource URL: " + target);
/*    */       try
/*    */       {
/* 81 */         log.trace("Target resource URL connection: " + target.openConnection());
/*    */       }
/*    */       catch (Exception ignore)
/*    */       {
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 89 */     return new URL(target.toExternalForm());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.resource.ResourceURLConnection
 * JD-Core Version:    0.6.0
 */