/*     */ package org.jboss.net.protocol.njar;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.net.URLStreamHandler;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.util.ThrowableHandler;
/*     */ import org.jboss.util.stream.Streams;
/*     */ 
/*     */ public class Handler extends URLStreamHandler
/*     */ {
/*     */   public static final String PROTOCOL = "njar";
/*     */   public static final String NJAR_SEPARATOR = "^/";
/*     */   public static final String JAR_SEPARATOR = "!/";
/*  77 */   private static final Logger log = Logger.getLogger(Handler.class);
/*     */ 
/*  79 */   protected Map savedJars = new HashMap();
/*     */ 
/*     */   public URLConnection openConnection(URL url)
/*     */     throws IOException
/*     */   {
/*  84 */     String file = url.getFile();
/*  85 */     String embeddedURL = file;
/*  86 */     String jarPath = "";
/*     */ 
/*  88 */     boolean trace = log.isTraceEnabled();
/*     */ 
/*  90 */     int pos = file.lastIndexOf("^/");
/*  91 */     if (pos >= 0)
/*     */     {
/*  93 */       embeddedURL = file.substring(0, pos);
/*  94 */       if (file.length() > pos + "^/".length()) {
/*  95 */         jarPath = file.substring(pos + "^/".length());
/*     */       }
/*     */     }
/*  98 */     if (embeddedURL.startsWith("njar"))
/*     */     {
/* 100 */       if (trace) log.trace("Opening next  nested jar: " + embeddedURL);
/* 101 */       File tempJar = (File)this.savedJars.get(embeddedURL);
/* 102 */       if (tempJar == null)
/*     */       {
/* 104 */         URLConnection embededDataConnection = new URL(embeddedURL).openConnection();
/* 105 */         if (trace) log.trace("Content length: " + embededDataConnection.getContentLength());
/*     */ 
/* 107 */         InputStream embededData = embededDataConnection.getInputStream();
/* 108 */         tempJar = File.createTempFile("nested-", ".jar");
/* 109 */         tempJar.deleteOnExit();
/*     */ 
/* 111 */         if (trace) log.trace("temp file location : " + tempJar);
/* 112 */         OutputStream output = new FileOutputStream(tempJar);
/*     */         try
/*     */         {
/* 116 */           long bytes = Streams.copyb(embededData, output);
/* 117 */           if (trace) log.trace("copied " + bytes + " bytes"); 
/*     */         }
/*     */         finally
/*     */         {
/* 120 */           Streams.flush(output);
/*     */ 
/* 123 */           Streams.close(embededData);
/* 124 */           Streams.close(output);
/*     */         }
/*     */ 
/* 127 */         this.savedJars.put(embeddedURL, tempJar);
/*     */       }
/*     */ 
/* 130 */       String t = tempJar.getCanonicalFile().toURL().toExternalForm();
/* 131 */       if (trace) log.trace("file URL : " + t);
/*     */ 
/* 133 */       t = "njar:" + t + "^/" + jarPath;
/* 134 */       if (trace) log.trace("Opening saved jar: " + t);
/*     */ 
/* 136 */       URL u = new URL(t);
/* 137 */       if (trace) log.trace("Using URL: " + u);
/*     */ 
/* 139 */       return u.openConnection();
/*     */     }
/*     */ 
/* 143 */     if (trace) log.trace("Opening final nested jar: " + embeddedURL);
/*     */ 
/* 145 */     URL u = new URL("jar:" + embeddedURL + "!/" + jarPath);
/* 146 */     if (trace) log.trace("Using URL: " + u);
/*     */ 
/* 148 */     return u.openConnection();
/*     */   }
/*     */ 
/*     */   public static URL njarToFile(URL url)
/*     */   {
/* 154 */     if (url.getProtocol().equals("njar"))
/*     */     {
/*     */       try
/*     */       {
/* 160 */         URL dummy = new URL("njar:" + url.toString() + "^/" + "dummy.jar");
/* 161 */         String tmp = dummy.openConnection().getURL().toString();
/* 162 */         tmp = tmp.substring("jar:".length());
/* 163 */         tmp = tmp.substring(0, tmp.length() - "!/dummy.jar".length());
/* 164 */         return new URL(tmp);
/*     */       }
/*     */       catch (Exception ignore)
/*     */       {
/* 168 */         ThrowableHandler.addWarning(ignore);
/*     */       }
/*     */     }
/*     */ 
/* 172 */     return url;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.njar.Handler
 * JD-Core Version:    0.6.0
 */