/*     */ package org.jboss.net.protocol;
/*     */ 
/*     */ import java.net.URL;
/*     */ import java.net.URLStreamHandler;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class URLStreamHandlerFactory
/*     */   implements java.net.URLStreamHandlerFactory
/*     */ {
/*  59 */   private static final Logger log = Logger.getLogger(URLStreamHandlerFactory.class);
/*     */   public static final String PACKAGE_PREFIX = "org.jboss.net.protocol";
/*  67 */   private static Map handlerMap = Collections.synchronizedMap(new HashMap());
/*     */ 
/*  98 */   private static ThreadLocal createURLStreamHandlerProtocol = new ThreadLocal();
/*     */ 
/* 103 */   private String[] handlerPkgs = { "org.jboss.net.protocol" };
/*     */ 
/* 108 */   private String lastHandlerPkgs = "org.jboss.net.protocol";
/*     */ 
/* 111 */   public static final String[] PROTOCOLS = { "resource", "file" };
/*     */ 
/*     */   public static void preload()
/*     */   {
/* 122 */     for (int i = 0; i < PROTOCOLS.length; i++)
/*     */     {
/*     */       try
/*     */       {
/* 126 */         URL url = new URL(PROTOCOLS[i], "", -1, "");
/* 127 */         log.trace("Loaded protocol: " + PROTOCOLS[i]);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 131 */         log.warn("Failed to load protocol: " + PROTOCOLS[i], e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void clear()
/*     */   {
/* 141 */     handlerMap.clear();
/*     */   }
/*     */ 
/*     */   public URLStreamHandler createURLStreamHandler(String protocol)
/*     */   {
/* 154 */     URLStreamHandler handler = (URLStreamHandler)handlerMap.get(protocol);
/* 155 */     if (handler != null) {
/* 156 */       return handler;
/*     */     }
/*     */ 
/* 159 */     String prevProtocol = (String)createURLStreamHandlerProtocol.get();
/* 160 */     if ((prevProtocol != null) && (prevProtocol.equals(protocol)))
/* 161 */       return null;
/* 162 */     createURLStreamHandlerProtocol.set(protocol);
/*     */ 
/* 165 */     checkHandlerPkgs();
/*     */ 
/* 168 */     ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
/* 169 */     for (int p = 0; p < this.handlerPkgs.length; p++)
/*     */     {
/*     */       try
/*     */       {
/* 174 */         String classname = this.handlerPkgs[p] + "." + protocol + ".Handler";
/* 175 */         Class type = null;
/*     */         try
/*     */         {
/* 179 */           type = ctxLoader.loadClass(classname);
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/* 184 */           type = Class.forName(classname);
/*     */         }
/*     */ 
/* 187 */         if (type != null)
/*     */         {
/* 189 */           handler = (URLStreamHandler)type.newInstance();
/* 190 */           handlerMap.put(protocol, handler);
/* 191 */           log.trace("Found protocol:" + protocol + " handler:" + handler);
/*     */         }
/*     */       }
/*     */       catch (Throwable ignore)
/*     */       {
/*     */       }
/*     */     }
/*     */ 
/* 199 */     createURLStreamHandlerProtocol.set(null);
/* 200 */     return handler;
/*     */   }
/*     */ 
/*     */   private synchronized void checkHandlerPkgs()
/*     */   {
/* 208 */     String handlerPkgsProp = System.getProperty("java.protocol.handler.pkgs");
/* 209 */     if ((handlerPkgsProp != null) && (!handlerPkgsProp.equals(this.lastHandlerPkgs)))
/*     */     {
/* 212 */       StringTokenizer tokeninzer = new StringTokenizer(handlerPkgsProp, "|");
/* 213 */       ArrayList tmp = new ArrayList();
/* 214 */       while (tokeninzer.hasMoreTokens())
/*     */       {
/* 216 */         String pkg = tokeninzer.nextToken().intern();
/* 217 */         if (!tmp.contains(pkg)) {
/* 218 */           tmp.add(pkg);
/*     */         }
/*     */       }
/* 221 */       if (!tmp.contains("org.jboss.net.protocol"))
/* 222 */         tmp.add("org.jboss.net.protocol");
/* 223 */       this.handlerPkgs = new String[tmp.size()];
/* 224 */       tmp.toArray(this.handlerPkgs);
/* 225 */       this.lastHandlerPkgs = handlerPkgsProp;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.URLStreamHandlerFactory
 * JD-Core Version:    0.6.0
 */