/*    */ package org.jboss.net.protocol;
/*    */ 
/*    */ import java.net.MalformedURLException;
/*    */ import java.net.URL;
/*    */ import java.util.HashMap;
/*    */ 
/*    */ public class URLListerFactory
/*    */ {
/* 29 */   private static HashMap defaultClasses = new HashMap();
/*    */   private HashMap classes;
/*    */ 
/*    */   public URLListerFactory()
/*    */   {
/* 43 */     this.classes = ((HashMap)defaultClasses.clone());
/*    */   }
/*    */ 
/*    */   public URLLister createURLLister(URL url)
/*    */     throws MalformedURLException
/*    */   {
/* 53 */     return createURLLister(url.getProtocol());
/*    */   }
/*    */ 
/*    */   public URLLister createURLLister(String protocol)
/*    */     throws MalformedURLException
/*    */   {
/*    */     try
/*    */     {
/* 64 */       String className = (String)this.classes.get(protocol);
/* 65 */       if (className == null) {
/* 66 */         throw new MalformedURLException("No lister class defined for protocol " + protocol);
/*    */       }
/*    */ 
/* 69 */       Class clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
/* 70 */       return (URLLister)clazz.newInstance();
/*    */     } catch (ClassNotFoundException e) {
/* 72 */       throw new MalformedURLException(e.getMessage());
/*    */     } catch (InstantiationException e) {
/* 74 */       throw new MalformedURLException(e.getMessage()); } catch (IllegalAccessException e) {
/*    */     }
/* 76 */     throw new MalformedURLException(e.getMessage());
/*    */   }
/*    */ 
/*    */   public void registerListener(String protocol, String className)
/*    */   {
/* 86 */     this.classes.put(protocol, className);
/*    */   }
/*    */ 
/*    */   static
/*    */   {
/* 31 */     defaultClasses.put("file", "org.jboss.net.protocol.file.FileURLLister");
/* 32 */     defaultClasses.put("http", "org.jboss.net.protocol.http.DavURLLister");
/* 33 */     defaultClasses.put("https", "org.jboss.net.protocol.http.DavURLLister");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.URLListerFactory
 * JD-Core Version:    0.6.0
 */