/*    */ package org.jboss.net.protocol;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.net.URL;
/*    */ import java.util.Arrays;
/*    */ import java.util.Collection;
/*    */ import java.util.HashSet;
/*    */ import java.util.StringTokenizer;
/*    */ 
/*    */ public abstract class URLListerBase
/*    */   implements URLLister
/*    */ {
/* 89 */   protected static final URLLister.URLFilter acceptAllFilter = new URLLister.URLFilter()
/*    */   {
/*    */     public boolean accept(URL baseURL, String memberName)
/*    */     {
/* 93 */       return true;
/*    */     }
/* 89 */   };
/*    */ 
/*    */   public Collection listMembers(URL baseUrl, String patterns, boolean scanNonDottedSubDirs)
/*    */     throws IOException
/*    */   {
/* 43 */     StringTokenizer tokens = new StringTokenizer(patterns, ",");
/* 44 */     String[] members = new String[tokens.countTokens()];
/* 45 */     for (int i = 0; tokens.hasMoreTokens(); i++)
/*    */     {
/* 47 */       String token = tokens.nextToken();
/*    */ 
/* 49 */       members[i] = token.trim();
/*    */     }
/* 51 */     URLLister.URLFilter filter = new URLFilterImpl(members);
/* 52 */     return listMembers(baseUrl, filter, scanNonDottedSubDirs);
/*    */   }
/*    */ 
/*    */   public Collection listMembers(URL baseUrl, String patterns) throws IOException
/*    */   {
/* 57 */     return listMembers(baseUrl, patterns, false);
/*    */   }
/*    */ 
/*    */   public static class URLFilterImpl
/*    */     implements URLLister.URLFilter
/*    */   {
/*    */     protected boolean allowAll;
/*    */     protected HashSet constants;
/*    */ 
/*    */     public URLFilterImpl(String[] patterns)
/*    */     {
/* 71 */       this.constants = new HashSet(Arrays.asList(patterns));
/* 72 */       this.allowAll = this.constants.contains("*");
/*    */     }
/*    */ 
/*    */     public boolean accept(URL baseUrl, String name)
/*    */     {
/* 77 */       if (this.allowAll)
/*    */       {
/* 79 */         return true;
/*    */       }
/*    */ 
/* 83 */       return this.constants.contains(name);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.URLListerBase
 * JD-Core Version:    0.6.0
 */