/*     */ package org.jboss.net.protocol;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.OutputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLConnection;
/*     */ import java.security.Permission;
/*     */ 
/*     */ public class DelegatingURLConnection extends URLConnection
/*     */ {
/*     */   protected URL delegateUrl;
/*     */   protected URLConnection delegateConnection;
/*     */ 
/*     */   public DelegatingURLConnection(URL url)
/*     */     throws MalformedURLException, IOException
/*     */   {
/*  51 */     super(url);
/*     */ 
/*  53 */     this.delegateUrl = makeDelegateUrl(url);
/*  54 */     this.delegateConnection = makeDelegateUrlConnection(this.delegateUrl);
/*     */   }
/*     */ 
/*     */   protected URL makeDelegateUrl(URL url)
/*     */     throws MalformedURLException, IOException
/*     */   {
/*  60 */     return url;
/*     */   }
/*     */ 
/*     */   protected URLConnection makeDelegateUrlConnection(URL url)
/*     */     throws IOException
/*     */   {
/*  66 */     return url.openConnection();
/*     */   }
/*     */ 
/*     */   public void connect() throws IOException
/*     */   {
/*  71 */     this.delegateConnection.connect();
/*     */   }
/*     */ 
/*     */   public URL getURL() {
/*  75 */     return this.delegateConnection.getURL();
/*     */   }
/*     */ 
/*     */   public int getContentLength() {
/*  79 */     return this.delegateConnection.getContentLength();
/*     */   }
/*     */ 
/*     */   public String getContentType() {
/*  83 */     return this.delegateConnection.getContentType();
/*     */   }
/*     */ 
/*     */   public String getContentEncoding() {
/*  87 */     return this.delegateConnection.getContentEncoding();
/*     */   }
/*     */ 
/*     */   public long getExpiration() {
/*  91 */     return this.delegateConnection.getExpiration();
/*     */   }
/*     */ 
/*     */   public long getDate() {
/*  95 */     return this.delegateConnection.getDate();
/*     */   }
/*     */ 
/*     */   public long getLastModified() {
/*  99 */     return this.delegateConnection.getLastModified();
/*     */   }
/*     */ 
/*     */   public String getHeaderField(String name) {
/* 103 */     return this.delegateConnection.getHeaderField(name);
/*     */   }
/*     */ 
/*     */   public int getHeaderFieldInt(String name, int _default)
/*     */   {
/* 113 */     return this.delegateConnection.getHeaderFieldInt(name, _default);
/*     */   }
/*     */ 
/*     */   public long getHeaderFieldDate(String name, long _default) {
/* 117 */     return this.delegateConnection.getHeaderFieldDate(name, _default);
/*     */   }
/*     */ 
/*     */   public String getHeaderFieldKey(int n) {
/* 121 */     return this.delegateConnection.getHeaderFieldKey(n);
/*     */   }
/*     */ 
/*     */   public String getHeaderField(int n) {
/* 125 */     return this.delegateConnection.getHeaderField(n);
/*     */   }
/*     */ 
/*     */   public Object getContent() throws IOException {
/* 129 */     return this.delegateConnection.getContent();
/*     */   }
/*     */ 
/*     */   public Object getContent(Class[] classes) throws IOException {
/* 133 */     return this.delegateConnection.getContent(classes);
/*     */   }
/*     */ 
/*     */   public Permission getPermission() throws IOException {
/* 137 */     return this.delegateConnection.getPermission();
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream() throws IOException {
/* 141 */     return this.delegateConnection.getInputStream();
/*     */   }
/*     */ 
/*     */   public OutputStream getOutputStream() throws IOException {
/* 145 */     return this.delegateConnection.getOutputStream();
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 149 */     return super.toString() + "{ " + this.delegateConnection + " }";
/*     */   }
/*     */ 
/*     */   public void setDoInput(boolean doinput) {
/* 153 */     this.delegateConnection.setDoInput(doinput);
/*     */   }
/*     */ 
/*     */   public boolean getDoInput() {
/* 157 */     return this.delegateConnection.getDoInput();
/*     */   }
/*     */ 
/*     */   public void setDoOutput(boolean dooutput) {
/* 161 */     this.delegateConnection.setDoOutput(dooutput);
/*     */   }
/*     */ 
/*     */   public boolean getDoOutput() {
/* 165 */     return this.delegateConnection.getDoOutput();
/*     */   }
/*     */ 
/*     */   public void setAllowUserInteraction(boolean allowuserinteraction) {
/* 169 */     this.delegateConnection.setAllowUserInteraction(allowuserinteraction);
/*     */   }
/*     */ 
/*     */   public boolean getAllowUserInteraction() {
/* 173 */     return this.delegateConnection.getAllowUserInteraction();
/*     */   }
/*     */ 
/*     */   public void setUseCaches(boolean usecaches) {
/* 177 */     this.delegateConnection.setUseCaches(usecaches);
/*     */   }
/*     */ 
/*     */   public boolean getUseCaches() {
/* 181 */     return this.delegateConnection.getUseCaches();
/*     */   }
/*     */ 
/*     */   public void setIfModifiedSince(long ifmodifiedsince) {
/* 185 */     this.delegateConnection.setIfModifiedSince(ifmodifiedsince);
/*     */   }
/*     */ 
/*     */   public long getIfModifiedSince() {
/* 189 */     return this.delegateConnection.getIfModifiedSince();
/*     */   }
/*     */ 
/*     */   public boolean getDefaultUseCaches() {
/* 193 */     return this.delegateConnection.getDefaultUseCaches();
/*     */   }
/*     */ 
/*     */   public void setDefaultUseCaches(boolean defaultusecaches) {
/* 197 */     this.delegateConnection.setDefaultUseCaches(defaultusecaches);
/*     */   }
/*     */ 
/*     */   public void setRequestProperty(String key, String value) {
/* 201 */     this.delegateConnection.setRequestProperty(key, value);
/*     */   }
/*     */ 
/*     */   public String getRequestProperty(String key)
/*     */   {
/* 211 */     return this.delegateConnection.getRequestProperty(key);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.net.protocol.DelegatingURLConnection
 * JD-Core Version:    0.6.0
 */