/*    */ package org.jboss.naming.interceptors;
/*    */ 
/*    */ import javax.management.MBeanServer;
/*    */ import javax.management.ObjectName;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.mx.interceptor.AbstractInterceptor;
/*    */ import org.jboss.mx.server.Invocation;
/*    */ import org.jboss.mx.util.MBeanServerLocator;
/*    */ import org.jnp.interfaces.Naming;
/*    */ import org.jnp.interfaces.NamingContext;
/*    */ 
/*    */ public class ProxyFactoryInterceptor extends AbstractInterceptor
/*    */ {
/* 43 */   private static Logger log = Logger.getLogger(ProxyFactoryInterceptor.class);
/*    */   private String proxyName;
/*    */   private Naming proxy;
/*    */ 
/*    */   public void setProxyName(String proxyName)
/*    */   {
/* 49 */     this.proxyName = proxyName;
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation)
/*    */     throws Throwable
/*    */   {
/* 55 */     Object value = invocation.nextInterceptor().invoke(invocation);
/* 56 */     if ((value instanceof NamingContext))
/*    */     {
/* 58 */       initNamingProxy();
/* 59 */       NamingContext ctx = (NamingContext)value;
/* 60 */       ctx.setNaming(this.proxy);
/*    */     }
/* 62 */     return value;
/*    */   }
/*    */ 
/*    */   private void initNamingProxy()
/*    */     throws Exception
/*    */   {
/* 72 */     if (this.proxy != null) {
/* 73 */       return;
/*    */     }
/* 75 */     ObjectName proxyFactory = new ObjectName(this.proxyName);
/* 76 */     MBeanServer server = MBeanServerLocator.locateJBoss();
/* 77 */     this.proxy = ((Naming)server.getAttribute(proxyFactory, "Proxy"));
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.interceptors.ProxyFactoryInterceptor
 * JD-Core Version:    0.6.0
 */