/*    */ package org.jboss.naming;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.Principal;
/*    */ import java.security.PrivilegedAction;
/*    */ import org.jboss.security.SecurityAssociation;
/*    */ 
/*    */ class SecurityAssociationActions
/*    */ {
/*    */   static void setPrincipalInfo(Principal principal, Object credential)
/*    */   {
/* 59 */     SetPrincipalInfoAction action = new SetPrincipalInfoAction(principal, credential);
/* 60 */     AccessController.doPrivileged(action);
/*    */   }
/*    */ 
/*    */   private static class SetPrincipalInfoAction
/*    */     implements PrivilegedAction
/*    */   {
/*    */     Principal principal;
/*    */     Object credential;
/*    */ 
/*    */     SetPrincipalInfoAction(Principal principal, Object credential)
/*    */     {
/* 44 */       this.principal = principal;
/* 45 */       this.credential = credential;
/*    */     }
/*    */ 
/*    */     public Object run() {
/* 49 */       SecurityAssociation.setCredential(this.credential);
/* 50 */       this.credential = null;
/* 51 */       SecurityAssociation.setPrincipal(this.principal);
/* 52 */       this.principal = null;
/* 53 */       return null;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.SecurityAssociationActions
 * JD-Core Version:    0.6.0
 */