/*     */ package org.jboss.naming;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.net.UnknownHostException;
/*     */ import java.rmi.server.RMIClientSocketFactory;
/*     */ import java.rmi.server.RMIServerSocketFactory;
/*     */ import java.util.Collections;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Properties;
/*     */ import javax.net.ServerSocketFactory;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.invocation.jrmp.server.JRMPProxyFactoryMBean;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.util.threadpool.BasicThreadPoolMBean;
/*     */ import org.jboss.util.threadpool.ThreadPool;
/*     */ import org.jnp.interfaces.MarshalledValuePair;
/*     */ import org.jnp.interfaces.Naming;
/*     */ import org.jnp.server.Main;
/*     */ import org.jnp.server.NamingBean;
/*     */ 
/*     */ public class NamingService extends ServiceMBeanSupport
/*     */   implements NamingServiceMBean
/*     */ {
/*     */   private NamingBean namingBean;
/*  67 */   private Main namingMain = new Main();
/*     */ 
/*  69 */   private Map marshalledInvocationMapping = new HashMap();
/*     */   private JRMPProxyFactoryMBean proxyFactory;
/*     */ 
/*     */   public NamingBean getNaming()
/*     */   {
/*  79 */     return this.namingBean;
/*     */   }
/*     */ 
/*     */   public void setNaming(NamingBean bean) {
/*  83 */     this.namingBean = bean;
/*  84 */     this.namingMain.setNamingInfo(bean);
/*     */   }
/*     */ 
/*     */   public Naming getNamingInstance()
/*     */   {
/*  89 */     return this.namingBean.getNamingInstance();
/*     */   }
/*     */ 
/*     */   public void setLookupPool(BasicThreadPoolMBean poolMBean)
/*     */   {
/* 100 */     ThreadPool lookupPool = poolMBean.getInstance();
/* 101 */     this.namingMain.setLookupPool(lookupPool);
/*     */   }
/*     */ 
/*     */   public boolean getCallByValue()
/*     */   {
/* 112 */     return !MarshalledValuePair.getEnableCallByReference();
/*     */   }
/*     */ 
/*     */   public void setCallByValue(boolean flag)
/*     */   {
/* 122 */     boolean callByValue = !flag;
/* 123 */     MarshalledValuePair.setEnableCallByReference(callByValue);
/*     */   }
/*     */ 
/*     */   public void setPort(int port)
/*     */   {
/* 128 */     this.namingMain.setPort(port);
/*     */   }
/*     */ 
/*     */   public int getPort()
/*     */   {
/* 133 */     return this.namingMain.getPort();
/*     */   }
/*     */ 
/*     */   public void setRmiPort(int port)
/*     */   {
/* 138 */     this.namingMain.setRmiPort(port);
/*     */   }
/*     */ 
/*     */   public int getRmiPort()
/*     */   {
/* 143 */     return this.namingMain.getRmiPort();
/*     */   }
/*     */ 
/*     */   public String getBindAddress()
/*     */   {
/* 148 */     return this.namingMain.getBindAddress();
/*     */   }
/*     */ 
/*     */   public void setBindAddress(String host) throws UnknownHostException
/*     */   {
/* 153 */     this.namingMain.setBindAddress(host);
/*     */   }
/*     */ 
/*     */   public String getRmiBindAddress()
/*     */   {
/* 158 */     return this.namingMain.getRmiBindAddress();
/*     */   }
/*     */ 
/*     */   public void setRmiBindAddress(String host) throws UnknownHostException
/*     */   {
/* 163 */     this.namingMain.setRmiBindAddress(host);
/*     */   }
/*     */ 
/*     */   public int getBacklog()
/*     */   {
/* 168 */     return this.namingMain.getBacklog();
/*     */   }
/*     */ 
/*     */   public void setBacklog(int backlog)
/*     */   {
/* 173 */     this.namingMain.setBacklog(backlog);
/*     */   }
/*     */ 
/*     */   public boolean getInstallGlobalService()
/*     */   {
/* 178 */     return this.namingMain.getInstallGlobalService();
/*     */   }
/*     */ 
/*     */   public void setInstallGlobalService(boolean flag) {
/* 182 */     this.namingMain.setInstallGlobalService(flag);
/*     */   }
/*     */ 
/*     */   public boolean getUseGlobalService() {
/* 186 */     return this.namingMain.getUseGlobalService();
/*     */   }
/*     */ 
/*     */   public void setUseGlobalService(boolean flag) {
/* 190 */     this.namingMain.setUseGlobalService(flag);
/*     */   }
/*     */ 
/*     */   public String getClientSocketFactory() {
/* 194 */     return this.namingMain.getClientSocketFactory();
/*     */   }
/*     */ 
/*     */   public void setClientSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*     */   {
/* 199 */     this.namingMain.setClientSocketFactory(factoryClassName);
/*     */   }
/*     */ 
/*     */   public RMIClientSocketFactory getClientSocketFactoryBean()
/*     */   {
/* 204 */     return this.namingMain.getClientSocketFactoryBean();
/*     */   }
/*     */ 
/*     */   public void setClientSocketFactoryBean(RMIClientSocketFactory factory) {
/* 208 */     this.namingMain.setClientSocketFactoryBean(factory);
/*     */   }
/*     */ 
/*     */   public String getServerSocketFactory()
/*     */   {
/* 213 */     return this.namingMain.getServerSocketFactory();
/*     */   }
/*     */ 
/*     */   public void setServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*     */   {
/* 218 */     this.namingMain.setServerSocketFactory(factoryClassName);
/*     */   }
/*     */ 
/*     */   public RMIServerSocketFactory getServerSocketFactoryBean() {
/* 222 */     return this.namingMain.getServerSocketFactoryBean();
/*     */   }
/*     */ 
/*     */   public void setServerSocketFactoryBean(RMIServerSocketFactory factory) {
/* 226 */     this.namingMain.setServerSocketFactoryBean(factory);
/*     */   }
/*     */ 
/*     */   public String getJNPServerSocketFactory()
/*     */   {
/* 231 */     return this.namingMain.getJNPServerSocketFactory();
/*     */   }
/*     */ 
/*     */   public void setJNPServerSocketFactory(String factoryClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException
/*     */   {
/* 236 */     this.namingMain.setJNPServerSocketFactory(factoryClassName);
/*     */   }
/*     */ 
/*     */   public ServerSocketFactory getJNPServerSocketFactoryBean() {
/* 240 */     return this.namingMain.getJNPServerSocketFactoryBean();
/*     */   }
/*     */ 
/*     */   public void setJNPServerSocketFactoryBean(ServerSocketFactory factory) {
/* 244 */     this.namingMain.setJNPServerSocketFactoryBean(factory);
/*     */   }
/*     */ 
/*     */   public void setInvokerProxyFactory(JRMPProxyFactoryMBean proxyFactory)
/*     */   {
/* 249 */     this.proxyFactory = proxyFactory;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 255 */     boolean debug = this.log.isDebugEnabled();
/*     */ 
/* 258 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 259 */     InputStream is = loader.getResourceAsStream("jndi.properties");
/* 260 */     if (is == null)
/* 261 */       throw new RuntimeException("Cannot find jndi.properties, it should be at conf/jndi.properties by default.");
/* 262 */     Properties props = new Properties();
/*     */     try
/*     */     {
/* 265 */       props.load(is);
/*     */     }
/*     */     finally
/*     */     {
/* 269 */       is.close();
/*     */     }
/*     */ 
/* 272 */     for (Enumeration keys = props.propertyNames(); keys.hasMoreElements(); )
/*     */     {
/* 274 */       String key = (String)keys.nextElement();
/* 275 */       String value = props.getProperty(key);
/* 276 */       if (debug)
/*     */       {
/* 278 */         this.log.debug("System.setProperty, key=" + key + ", value=" + value);
/*     */       }
/* 280 */       System.setProperty(key, value);
/*     */     }
/* 282 */     if (this.proxyFactory != null)
/* 283 */       this.namingMain.setNamingProxy(this.proxyFactory.getProxy());
/* 284 */     this.namingMain.start();
/*     */ 
/* 287 */     HashMap tmpMap = new HashMap(13);
/* 288 */     Method[] methods = Naming.class.getMethods();
/* 289 */     for (int m = 0; m < methods.length; m++)
/*     */     {
/* 291 */       Method method = methods[m];
/* 292 */       Long hash = new Long(MarshalledInvocation.calculateHash(method));
/* 293 */       tmpMap.put(hash, method);
/*     */     }
/* 295 */     this.marshalledInvocationMapping = Collections.unmodifiableMap(tmpMap);
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */     throws Exception
/*     */   {
/* 301 */     this.namingMain.stop();
/* 302 */     this.log.debug("JNP server stopped");
/*     */   }
/*     */ 
/*     */   protected Main getNamingServer()
/*     */   {
/* 316 */     return this.namingMain;
/*     */   }
/*     */ 
/*     */   public Map getMethodMap()
/*     */   {
/* 328 */     return this.marshalledInvocationMapping;
/*     */   }
/*     */ 
/*     */   public void createAlias(String fromName, String toName) throws Exception
/*     */   {
/* 333 */     Util.createLinkRef(fromName, toName);
/* 334 */     this.log.info("Created alias " + fromName + "->" + toName);
/*     */   }
/*     */ 
/*     */   public void removeAlias(String name) throws Exception
/*     */   {
/* 339 */     this.log.info("Removing alias " + name);
/* 340 */     Util.removeLinkRef(name);
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 354 */     Naming theServer = this.namingMain.getNamingInstance();
/*     */ 
/* 356 */     if ((invocation instanceof MarshalledInvocation))
/*     */     {
/* 358 */       MarshalledInvocation mi = (MarshalledInvocation)invocation;
/* 359 */       mi.setMethodMap(this.marshalledInvocationMapping);
/*     */     }
/*     */ 
/* 362 */     Method method = invocation.getMethod();
/* 363 */     Object[] args = invocation.getArguments();
/* 364 */     Object value = null;
/*     */     try
/*     */     {
/* 367 */       value = method.invoke(theServer, args);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 371 */       Throwable t = e.getTargetException();
/* 372 */       if ((t instanceof Exception)) {
/* 373 */         throw ((Exception)t);
/*     */       }
/* 375 */       throw new UndeclaredThrowableException(t, method.toString());
/*     */     }
/*     */ 
/* 378 */     return value;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.NamingService
 * JD-Core Version:    0.6.0
 */