/*     */ package org.jboss.naming;
/*     */ 
/*     */ import javax.naming.InitialContext;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class LinkRefPairService extends ServiceMBeanSupport
/*     */   implements LinkRefPairServiceMBean
/*     */ {
/*  40 */   protected static final Class HACK = LinkRefPairObjectFactory.class;
/*     */   private String jndiName;
/*     */   private String remoteJndiName;
/*     */   private String localJndiName;
/*     */ 
/*     */   public String getJndiName()
/*     */   {
/*  71 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public String getLocalJndiName()
/*     */   {
/*  76 */     return this.localJndiName;
/*     */   }
/*     */ 
/*     */   public String getRemoteJndiName()
/*     */   {
/*  81 */     return this.remoteJndiName;
/*     */   }
/*     */ 
/*     */   public void setJndiName(String jndiName)
/*     */   {
/*  86 */     this.jndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public void setLocalJndiName(String jndiName)
/*     */   {
/*  91 */     this.localJndiName = jndiName;
/*     */   }
/*     */ 
/*     */   public void setRemoteJndiName(String jndiName)
/*     */   {
/*  96 */     this.remoteJndiName = jndiName;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 103 */     if (this.jndiName == null)
/* 104 */       throw new DeploymentException("The jndiName is null for LinkRefPair " + getServiceName());
/* 105 */     if (this.remoteJndiName == null)
/* 106 */       throw new DeploymentException("The remoteJndiName is null for LinkRefPair " + getServiceName());
/* 107 */     if (this.localJndiName == null) {
/* 108 */       throw new DeploymentException("The localJndiName is null for LinkRefPair " + getServiceName());
/*     */     }
/* 110 */     LinkRefPair pair = new LinkRefPair(this.remoteJndiName, this.localJndiName);
/* 111 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 114 */       Util.bind(ctx, this.jndiName, pair);
/*     */     }
/*     */     finally
/*     */     {
/* 118 */       ctx.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 124 */     LinkRefPair pair = new LinkRefPair(this.remoteJndiName, this.localJndiName);
/* 125 */     InitialContext ctx = new InitialContext();
/*     */     try
/*     */     {
/* 128 */       Util.unbind(ctx, this.jndiName);
/*     */     }
/*     */     finally
/*     */     {
/* 132 */       ctx.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  45 */     Logger.getLogger(LinkRefPairService.class).debug("LinkRefPair guid=" + LinkRefPairObjectFactory.guid);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.LinkRefPairService
 * JD-Core Version:    0.6.0
 */