/*    */ package org.jboss.naming;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.RefAddr;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.StringRefAddr;
/*    */ 
/*    */ public class JavaCompInitializer
/*    */ {
/*    */   private InitialContext iniCtx;
/*    */   private Hashtable initialContextProperties;
/*    */ 
/*    */   public Hashtable getInitialContextProperties()
/*    */   {
/* 45 */     return this.initialContextProperties;
/*    */   }
/*    */ 
/*    */   public void setInitialContextProperties(Hashtable initialContextProperties)
/*    */   {
/* 50 */     this.initialContextProperties = initialContextProperties;
/*    */   }
/*    */ 
/*    */   public InitialContext getIniCtx()
/*    */   {
/* 55 */     return this.iniCtx;
/*    */   }
/*    */ 
/*    */   public void setIniCtx(InitialContext iniCtx)
/*    */   {
/* 60 */     this.iniCtx = iniCtx;
/*    */   }
/*    */ 
/*    */   protected void initialContext() throws Exception
/*    */   {
/* 65 */     if (this.iniCtx != null) return;
/* 66 */     if (this.initialContextProperties == null)
/*    */     {
/* 68 */       this.iniCtx = new InitialContext();
/*    */     }
/*    */     else
/*    */     {
/* 72 */       this.iniCtx = new InitialContext(this.initialContextProperties);
/*    */     }
/*    */   }
/*    */ 
/*    */   public void start() throws Exception
/*    */   {
/* 78 */     initialContext();
/* 79 */     ClassLoader topLoader = Thread.currentThread().getContextClassLoader();
/* 80 */     ENCFactory.setTopClassLoader(topLoader);
/* 81 */     RefAddr refAddr = new StringRefAddr("nns", "ENC");
/* 82 */     Reference envRef = new Reference("javax.naming.Context", refAddr, ENCFactory.class.getName(), null);
/* 83 */     Context ctx = (Context)this.iniCtx.lookup("java:");
/* 84 */     ctx.rebind("comp", envRef);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.JavaCompInitializer
 * JD-Core Version:    0.6.0
 */