/*     */ package org.jboss.naming;
/*     */ 
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ 
/*     */ public class JNDIBindingService
/*     */ {
/*     */   private JNDIBindings bindings;
/*     */   private String rootName;
/*     */ 
/*     */   public JNDIBindings getBindings()
/*     */   {
/*  44 */     return this.bindings;
/*     */   }
/*     */ 
/*     */   public void setBindings(JNDIBindings bindings) {
/*  48 */     this.bindings = bindings;
/*     */   }
/*     */ 
/*     */   public String getRootName()
/*     */   {
/*  53 */     return this.rootName;
/*     */   }
/*     */ 
/*     */   public void setRootName(String rootName) {
/*  57 */     this.rootName = rootName;
/*     */   }
/*     */ 
/*     */   public void addBindings() throws NamingException
/*     */   {
/*  62 */     Context ctx = new InitialContext();
/*  63 */     if (this.rootName != null) {
/*  64 */       ctx = (Context)ctx.lookup(this.rootName);
/*     */     }
/*  66 */     JNDIBinding[] values = this.bindings.getBindings();
/*  67 */     for (int n = 0; n < values.length; n++) {
/*  69 */       String name = values[n].getName();
/*     */       Object value;
/*     */       try {
/*  73 */         value = values[n].getValue();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*  77 */         NamingException ne = new NamingException("Failed to obtain value from binding: " + name);
/*  78 */         ne.setRootCause(e);
/*  79 */         throw ne;
/*     */       }
/*  81 */       Util.bind(ctx, name, value);
/*     */     }
/*  83 */     ctx.close();
/*     */   }
/*     */ 
/*     */   public void removeBindings() throws NamingException {
/*  87 */     Context ctx = new InitialContext();
/*  88 */     if (this.rootName != null) {
/*  89 */       ctx = (Context)ctx.lookup(this.rootName);
/*     */     }
/*  91 */     JNDIBinding[] values = this.bindings.getBindings();
/*  92 */     for (int n = 0; n < values.length; n++)
/*     */     {
/*  94 */       String name = values[n].getName();
/*  95 */       Util.unbind(ctx, name);
/*     */     }
/*  97 */     ctx.close();
/*     */   }
/*     */ 
/*     */   public void start() throws Exception
/*     */   {
/* 102 */     addBindings();
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception {
/* 106 */     removeBindings();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.JNDIBindingService
 * JD-Core Version:    0.6.0
 */