/*     */ package org.jboss.naming;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.net.HttpURLConnection;
/*     */ import java.net.URL;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NamingException;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.spi.InitialContextFactory;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import org.jboss.invocation.InvocationException;
/*     */ import org.jboss.invocation.MarshalledValue;
/*     */ import org.jboss.invocation.http.interfaces.Util;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jnp.interfaces.Naming;
/*     */ import org.jnp.interfaces.NamingContext;
/*     */ 
/*     */ public class HttpNamingContextFactory
/*     */   implements InitialContextFactory, ObjectFactory
/*     */ {
/*  57 */   private static Logger log = Logger.getLogger(HttpNamingContextFactory.class);
/*     */ 
/*     */   public Context getInitialContext(Hashtable env)
/*     */     throws NamingException
/*     */   {
/*  64 */     String provider = (String)env.get("java.naming.provider.url");
/*  65 */     if (provider.startsWith("jnp:") == true)
/*  66 */       provider = "http:" + provider.substring(4);
/*  67 */     else if (provider.startsWith("jnps:") == true)
/*  68 */       provider = "https:" + provider.substring(5);
/*  69 */     else if (provider.startsWith("jnp-http:") == true)
/*  70 */       provider = "http:" + provider.substring(9);
/*  71 */     else if (provider.startsWith("jnp-https:") == true) {
/*  72 */       provider = "https:" + provider.substring(10);
/*     */     }
/*  74 */     URL providerURL = null;
/*  75 */     Naming namingServer = null;
/*     */     try
/*     */     {
/*  78 */       providerURL = new URL(provider);
/*     */ 
/*  80 */       namingServer = getNamingServer(providerURL);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  84 */       NamingException ex = new NamingException("Failed to retrieve Naming interface for provider " + provider);
/*  85 */       ex.setRootCause(e);
/*  86 */       throw ex;
/*     */     }
/*     */ 
/*  90 */     env = (Hashtable)env.clone();
/*  91 */     return new NamingContext(env, null, namingServer);
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env)
/*     */     throws Exception
/*     */   {
/*  99 */     Context ctx = getInitialContext(env);
/* 100 */     Reference ref = (Reference)obj;
/* 101 */     RefAddr addr = ref.get("URL");
/* 102 */     String path = (String)addr.getContent();
/* 103 */     return ctx.lookup(path);
/*     */   }
/*     */ 
/*     */   private Naming getNamingServer(URL providerURL)
/*     */     throws ClassNotFoundException, IOException, InvocationTargetException, IllegalAccessException
/*     */   {
/* 121 */     Util.init();
/* 122 */     if (log.isTraceEnabled()) {
/* 123 */       log.trace("Retrieving content from : " + providerURL);
/*     */     }
/* 125 */     HttpURLConnection conn = (HttpURLConnection)providerURL.openConnection();
/* 126 */     Util.configureHttpsHostVerifier(conn);
/* 127 */     Util.configureSSLSocketFactory(conn);
/* 128 */     int length = conn.getContentLength();
/* 129 */     String type = conn.getContentType();
/* 130 */     if (log.isTraceEnabled()) {
/* 131 */       log.trace("ContentLength: " + length + "\nContentType: " + type);
/*     */     }
/* 133 */     InputStream is = conn.getInputStream();
/* 134 */     ObjectInputStream ois = new ObjectInputStream(is);
/* 135 */     MarshalledValue mv = (MarshalledValue)ois.readObject();
/* 136 */     ois.close();
/*     */ 
/* 138 */     Object obj = mv.get();
/* 139 */     if (!(obj instanceof Naming))
/*     */     {
/* 141 */       String msg = "Invalid reply content seen: " + obj.getClass();
/* 142 */       Throwable t = null;
/* 143 */       if ((obj instanceof Throwable))
/*     */       {
/* 145 */         t = (Throwable)obj;
/* 146 */         if ((t instanceof InvocationException))
/* 147 */           t = ((InvocationException)t).getTargetException();
/*     */       }
/* 149 */       if (t != null)
/* 150 */         log.warn(msg, t);
/*     */       else
/* 152 */         log.warn(msg);
/* 153 */       IOException e = new IOException(msg);
/* 154 */       throw e;
/*     */     }
/* 156 */     Naming namingServer = (Naming)obj;
/* 157 */     return namingServer;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.naming.HttpNamingContextFactory
 * JD-Core Version:    0.6.0
 */