/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public final class TimeFormat
/*     */   implements Serializable
/*     */ {
/*     */   public static final boolean DEBUG = false;
/*     */   public static final long ONE_MILLISECOND = 1L;
/*     */   public static final long ONE_SECOND = 1000L;
/*     */   public static final long ONE_MINUTE = 60000L;
/*     */   public static final long ONE_HOUR = 3600000L;
/*     */   public static final long ONE_DAY = 86400000L;
/*     */   public static final int ROUND_TO_MILLISECOND = 5;
/*     */   public static final int ROUND_TO_SECOND = 4;
/*     */   public static final int ROUND_TO_MINUTE = 3;
/*     */   public static final int ROUND_TO_HOUR = 2;
/*     */   public static final int ROUND_TO_DAY = 1;
/*  61 */   private long original = 0L;
/*  62 */   private long time = 0L;
/*  63 */   private long remainder = 0L;
/*  64 */   private long days = 0L;
/*  65 */   private long hours = 0L;
/*  66 */   private long minutes = 0L;
/*  67 */   private long seconds = 0L;
/*  68 */   private long milliseconds = 0L;
/*  69 */   private boolean micro = false;
/*  70 */   private int rounding = 4;
/*     */ 
/*     */   private TimeFormat(long milliseconds, int round)
/*     */   {
/*  80 */     this.rounding = round;
/*  81 */     this.original = milliseconds;
/*     */ 
/*  83 */     if (milliseconds >= 1000L)
/*     */     {
/*  85 */       this.remainder = milliseconds;
/*     */ 
/*  87 */       getTime();
/*     */     }
/*     */     else
/*     */     {
/*  91 */       this.micro = true;
/*     */ 
/*  95 */       this.time = milliseconds;
/*     */     }
/*     */   }
/*     */ 
/*     */   private TimeFormat(long milliseconds)
/*     */   {
/* 107 */     this(milliseconds, 5);
/*     */   }
/*     */ 
/*     */   public long getDays()
/*     */   {
/* 117 */     return this.days;
/*     */   }
/*     */ 
/*     */   public long getMinutes()
/*     */   {
/* 127 */     return this.minutes;
/*     */   }
/*     */ 
/*     */   public long getHours()
/*     */   {
/* 137 */     return this.hours;
/*     */   }
/*     */ 
/*     */   public long getSeconds()
/*     */   {
/* 147 */     return this.seconds;
/*     */   }
/*     */ 
/*     */   public void add(TimeFormat t)
/*     */   {
/* 158 */     this.days += t.days;
/* 159 */     this.hours += t.hours;
/* 160 */     this.minutes += t.minutes;
/* 161 */     this.seconds += t.seconds;
/*     */   }
/*     */ 
/*     */   public void getDays(TimeFormat t)
/*     */   {
/* 172 */     if (t.remainder >= 86400000L)
/*     */     {
/* 174 */       t.days = (t.remainder / 86400000L);
/* 175 */       t.remainder -= t.days * 86400000L;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void getHours(TimeFormat t)
/*     */   {
/* 187 */     if ((t.remainder >= 3600000L) && (t.remainder < 86400000L))
/*     */     {
/* 189 */       t.hours = (t.remainder / 3600000L);
/* 190 */       t.remainder -= t.hours * 3600000L;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void getMinutes(TimeFormat t)
/*     */   {
/* 202 */     if ((t.remainder >= 60000L) && (t.remainder < 3600000L))
/*     */     {
/* 204 */       t.minutes = (t.remainder / 60000L);
/* 205 */       t.remainder -= t.minutes * 60000L;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void getSeconds(TimeFormat t)
/*     */   {
/* 217 */     if ((t.remainder >= 1000L) && (t.remainder < 60000L))
/*     */     {
/* 219 */       t.seconds = (t.remainder / 1000L);
/* 220 */       t.milliseconds = (t.remainder -= t.seconds * 1000L);
/*     */     }
/*     */     else
/*     */     {
/* 224 */       t.seconds = 0L;
/* 225 */       t.milliseconds = t.remainder;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void getTime(TimeFormat t)
/*     */   {
/* 237 */     t.getTime();
/*     */   }
/*     */ 
/*     */   private void getTime()
/*     */   {
/* 246 */     getDays(this);
/* 247 */     getHours(this);
/* 248 */     getMinutes(this);
/* 249 */     getSeconds(this);
/*     */   }
/*     */ 
/*     */   public long getMilliseconds()
/*     */   {
/* 257 */     return this.micro ? this.time : this.milliseconds;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 265 */     return format(this.rounding);
/*     */   }
/*     */ 
/*     */   public void setRounding(int r)
/*     */   {
/* 273 */     this.rounding = r;
/*     */   }
/*     */ 
/*     */   public int getRouding()
/*     */   {
/* 281 */     return this.rounding;
/*     */   }
/*     */ 
/*     */   public String format(int round)
/*     */   {
/* 303 */     switch (round)
/*     */     {
/*     */     case 1:
/* 308 */       return formatDays(false);
/*     */     case 2:
/* 313 */       return formatDays(true) + formatHours(false);
/*     */     case 3:
/* 318 */       return formatDays(true) + formatHours(true) + formatMinutes(false);
/*     */     case 4:
/* 323 */       return formatDays(true) + formatHours(true) + formatMinutes(true) + formatSeconds(false);
/*     */     case 5:
/* 328 */       return formatDays(true) + formatHours(true) + formatMinutes(true) + formatSeconds(true) + (this.micro ? this.time : this.milliseconds) + " ms";
/*     */     }
/*     */ 
/* 333 */     return this.original + " ms";
/*     */   }
/*     */ 
/*     */   private String formatDays(boolean empty)
/*     */   {
/* 345 */     if (this.days <= 0L)
/*     */     {
/* 347 */       return empty ? "" : "0 days";
/*     */     }
/*     */ 
/* 350 */     return format("day", "days", this.days);
/*     */   }
/*     */ 
/*     */   private String formatHours(boolean empty)
/*     */   {
/* 362 */     if (this.hours <= 0L)
/*     */     {
/* 364 */       return empty ? "" : "0 hours";
/*     */     }
/*     */ 
/* 367 */     return format("hour", "hours", this.hours);
/*     */   }
/*     */ 
/*     */   private String formatMinutes(boolean empty)
/*     */   {
/* 379 */     if (this.minutes <= 0L)
/*     */     {
/* 381 */       return empty ? "" : "0 minutes";
/*     */     }
/*     */ 
/* 384 */     return format("minute", "minutes", this.minutes);
/*     */   }
/*     */ 
/*     */   private String formatSeconds(boolean empty)
/*     */   {
/* 396 */     if (this.seconds <= 0L)
/*     */     {
/* 398 */       return empty ? "" : "0 seconds";
/*     */     }
/*     */ 
/* 401 */     return format("second", "seconds", this.seconds);
/*     */   }
/*     */ 
/*     */   private String format(String single, String plural, long amt)
/*     */   {
/* 409 */     if (amt > 0L)
/*     */     {
/* 411 */       return amt + " " + (amt > 1L ? plural : single) + " ";
/*     */     }
/*     */ 
/* 414 */     return "";
/*     */   }
/*     */ 
/*     */   public static String valueOf(long t, int round)
/*     */   {
/* 427 */     TimeFormat f = new TimeFormat(t, round);
/*     */ 
/* 429 */     return f.toString();
/*     */   }
/*     */ 
/*     */   public static String valueOf(long t)
/*     */   {
/* 442 */     return valueOf(t, 5);
/*     */   }
/*     */ 
/*     */   public static String format(String format, long time)
/*     */   {
/* 450 */     TimeFormat f = new TimeFormat(time);
/*     */ 
/* 452 */     return f.parse(format, f.getDays(), f.getHours(), f.getMinutes(), f.getSeconds(), f.getMilliseconds());
/*     */   }
/*     */ 
/*     */   private String parse(String format, long day, long hour, long minute, long second, long millis)
/*     */   {
/* 461 */     String s = "";
/* 462 */     int start = 0;
/* 463 */     int len = format.length();
/*     */ 
/* 465 */     for (int c = 0; c < len; c++)
/*     */     {
/* 467 */       char tc = format.charAt(c);
/* 468 */       int sc = c;
/* 469 */       int l = 0;
/*     */ 
/* 471 */       switch (tc)
/*     */       {
/*     */       case ' ':
/* 476 */         s = s + " ";
/*     */ 
/* 478 */         break;
/*     */       case '\'':
/*     */         do
/*     */         {
/* 483 */           c++; } while ((c < len) && (format.charAt(c) != '\''));
/*     */ 
/* 485 */         s = s + format.substring(sc + 1, c);
/*     */ 
/* 487 */         break;
/*     */       case 'D':
/*     */       case 'd':
/*     */         do
/*     */         {
/* 493 */           c++; } while ((c < len) && ((format.charAt(c) == 'd') || (format.charAt(c) == 'D')));
/*     */ 
/* 495 */         l = c - sc;
/* 496 */         s = s + ((sc <= 0) || (start < 0) ? "" : format.substring(start, sc));
/* 497 */         s = s + zeroPad(day, l - 1);
/* 498 */         c--;
/*     */ 
/* 500 */         break;
/*     */       case 'H':
/*     */       case 'h':
/*     */         do
/*     */         {
/* 505 */           c++; } while ((c < len) && ((format.charAt(c) == 'h') || (format.charAt(c) == 'H')));
/*     */ 
/* 507 */         l = c - sc;
/* 508 */         s = s + ((sc <= 0) || (start < 0) ? "" : format.substring(start, sc));
/* 509 */         s = s + zeroPad(hour, l - 1);
/* 510 */         c--;
/*     */ 
/* 512 */         break;
/*     */       case 'M':
/*     */       case 'm':
/*     */         do
/*     */         {
/* 517 */           c++; } while ((c < len) && ((format.charAt(c) == 'm') || (format.charAt(c) == 'M')));
/*     */ 
/* 519 */         l = c - sc;
/* 520 */         s = s + ((sc <= 0) || (start < 0) ? "" : format.substring(start, sc));
/* 521 */         s = s + zeroPad(minute, l - 1);
/* 522 */         c--;
/*     */ 
/* 524 */         break;
/*     */       case 'S':
/*     */       case 's':
/*     */         do
/*     */         {
/* 529 */           c++; } while ((c < len) && ((format.charAt(c) == 's') || (format.charAt(c) == 'S')));
/*     */ 
/* 531 */         l = c - sc;
/* 532 */         s = s + ((sc <= 0) || (start < 0) ? "" : format.substring(start, sc));
/* 533 */         s = s + zeroPad(second, l - 1);
/* 534 */         c--;
/*     */ 
/* 536 */         break;
/*     */       case 'Z':
/*     */       case 'z':
/*     */         do
/*     */         {
/* 541 */           c++; } while ((c < len) && ((format.charAt(c) == 'z') || (format.charAt(c) == 'Z')));
/*     */ 
/* 543 */         l = c - sc;
/* 544 */         s = s + ((sc <= 0) || (start < 0) ? "" : format.substring(start, sc));
/* 545 */         s = s + zeroPad(millis, l - 1);
/* 546 */         c--;
/*     */       }
/*     */ 
/* 551 */       start = c + 1;
/*     */     }
/*     */ 
/* 554 */     return s;
/*     */   }
/*     */ 
/*     */   private String zeroPad(long value, int len)
/*     */   {
/* 562 */     String s = String.valueOf(value);
/* 563 */     int l = s.length();
/* 564 */     String r = "";
/*     */ 
/* 566 */     for (int c = l; c <= len; c++)
/*     */     {
/* 568 */       r = r + "0";
/*     */     }
/*     */ 
/* 571 */     return r + s;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 582 */     String FORMAT = "D 'days,' HH 'hours,' mm 'minutes and ' ss 'seconds, 'zz 'milliseconds'";
/*     */ 
/* 584 */     System.out.println(format(FORMAT, 1000L));
/* 585 */     System.out.println("ONE SECOND: 1000");
/* 586 */     System.out.println("ONE MINUTE: 60000");
/* 587 */     System.out.println("ONE HOUR:   3600000");
/* 588 */     System.out.println("ONE DAY:    86400000");
/*     */ 
/* 590 */     for (int c = 0; c <= 5; c++)
/*     */     {
/* 592 */       System.out.println("============ Round to: " + c + " ==================");
/* 593 */       System.out.println("Time: " + valueOf(9223372036854775807L, c));
/* 594 */       System.out.println("Time: " + valueOf(1236371400L, c));
/* 595 */       System.out.println("Time: " + format(FORMAT, 1236371400L));
/* 596 */       System.out.println("Time: " + valueOf(123613700L, c));
/* 597 */       System.out.println("Time: " + valueOf(700L, c));
/* 598 */       System.out.println("Time: " + valueOf(2001L, c));
/* 599 */       System.out.println("Time: " + valueOf(2101L, c));
/* 600 */       System.out.println("Time: " + valueOf(15L, c));
/* 601 */       System.out.println("Time: " + valueOf(999L, c));
/* 602 */       System.out.println("Time: " + valueOf(10000L, c));
/* 603 */       System.out.println("Time: " + valueOf(600000L, c));
/* 604 */       System.out.println("Time: " + valueOf(864000101L, c));
/* 605 */       System.out.println("Time: " + valueOf(36000000L, c));
/* 606 */       System.out.println("Time: " + valueOf(90120000L, c));
/* 607 */       System.out.println("Time: " + format(FORMAT, 90120000L));
/* 608 */       System.out.println("================================================");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.TimeFormat
 * JD-Core Version:    0.6.0
 */