/*    */ package org.jboss.mx.util;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import java.io.OptionalDataException;
/*    */ import org.jboss.mx.server.ObjectInputStreamWithClassLoader;
/*    */ 
/*    */ public class SerializationHelper
/*    */ {
/*    */   public static Object deserialize(byte[] byteArray)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 46 */     return deserialize(byteArray, Thread.currentThread().getContextClassLoader());
/*    */   }
/*    */ 
/*    */   public static Object deserialize(byte[] byteArray, ClassLoader cl)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 60 */     if (byteArray == null)
/*    */     {
/* 62 */       return null;
/*    */     }
/* 64 */     if (byteArray.length == 0)
/*    */     {
/* 66 */       return null;
/*    */     }
/*    */     try
/*    */     {
/* 70 */       if (cl == null)
/*    */       {
/* 73 */         cl = SerializationHelper.class.getClassLoader();
/*    */       }
/* 75 */       ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(byteArray);
/* 76 */       ObjectInputStream objectinputstream = new ObjectInputStreamWithClassLoader(bytearrayinputstream, cl);
/* 77 */       Object obj = objectinputstream.readObject();
/* 78 */       return obj;
/*    */     }
/*    */     catch (OptionalDataException optionaldataexception) {
/*    */     }
/* 82 */     throw new IOException(optionaldataexception.getMessage());
/*    */   }
/*    */ 
/*    */   public static byte[] serialize(Object obj)
/*    */     throws IOException
/*    */   {
/* 96 */     ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
/* 97 */     ObjectOutputStream objectoutputstream = new ObjectOutputStream(bytearrayoutputstream);
/* 98 */     objectoutputstream.writeObject(obj);
/* 99 */     return bytearrayoutputstream.toByteArray();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.SerializationHelper
 * JD-Core Version:    0.6.0
 */