/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
/*     */ import org.jboss.util.timeout.Timeout;
/*     */ 
/*     */ public abstract class SchedulableRunnable
/*     */   implements Runnable
/*     */ {
/*  50 */   private SynchronizedLong nextRun = new SynchronizedLong(0L);
/*     */   private RunnableScheduler scheduler;
/*     */   private boolean running;
/*     */   private boolean reschedule;
/*     */   private Timeout timeout;
/*     */ 
/*     */   public long getNextRun()
/*     */   {
/*  92 */     return this.nextRun.get();
/*     */   }
/*     */ 
/*     */   public synchronized void setNextRun(long nextRun)
/*     */   {
/* 106 */     if (this.timeout != null) {
/* 107 */       this.timeout.cancel();
/*     */     }
/*     */ 
/* 110 */     this.nextRun.set(nextRun);
/*     */ 
/* 114 */     if ((!this.running) && (this.scheduler != null))
/*     */     {
/* 117 */       this.timeout = this.scheduler.add(this);
/*     */     }
/*     */     else
/*     */     {
/* 122 */       this.reschedule = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized RunnableScheduler setScheduler(RunnableScheduler scheduler)
/*     */   {
/* 135 */     if (this.scheduler == scheduler) {
/* 136 */       return this.scheduler;
/*     */     }
/*     */ 
/* 139 */     RunnableScheduler result = this.scheduler;
/*     */ 
/* 142 */     if (this.timeout != null) {
/* 143 */       this.timeout.cancel();
/*     */     }
/*     */ 
/* 146 */     this.scheduler = scheduler;
/*     */ 
/* 149 */     if (scheduler == null) {
/* 150 */       this.reschedule = false;
/*     */     }
/* 154 */     else if (!this.running)
/* 155 */       this.timeout = scheduler.add(this);
/*     */     else {
/* 157 */       this.reschedule = true;
/*     */     }
/*     */ 
/* 160 */     return result;
/*     */   }
/*     */ 
/*     */   public abstract void doRun();
/*     */ 
/*     */   public final void run()
/*     */   {
/* 178 */     startRun();
/*     */     try
/*     */     {
/* 181 */       doRun();
/*     */     }
/*     */     finally
/*     */     {
/* 185 */       endRun();
/*     */     }
/*     */   }
/*     */ 
/*     */   private synchronized void startRun()
/*     */   {
/* 202 */     this.running = true;
/*     */   }
/*     */ 
/*     */   private synchronized void endRun()
/*     */   {
/* 210 */     this.running = false;
/* 211 */     if (this.reschedule == true)
/* 212 */       this.timeout = this.scheduler.add(this);
/* 213 */     this.reschedule = false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.SchedulableRunnable
 * JD-Core Version:    0.6.0
 */