/*    */ package org.jboss.mx.util;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ 
/*    */ public class PropertyAccess
/*    */ {
/*    */   public static String getProperty(String name)
/*    */   {
/* 68 */     return getProperty(name, null);
/*    */   }
/*    */ 
/*    */   public static String getProperty(String name, String defaultValue)
/*    */   {
/* 73 */     PrivilegedAction action = new PropertyReadAction(name, defaultValue);
/* 74 */     String property = (String)AccessController.doPrivileged(action);
/* 75 */     return property;
/*    */   }
/*    */ 
/*    */   public static String setProperty(String name, String value)
/*    */   {
/* 80 */     PrivilegedAction action = new PropertyWriteAction(name, value);
/* 81 */     String property = (String)AccessController.doPrivileged(action);
/* 82 */     return property;
/*    */   }
/*    */ 
/*    */   static class PropertyWriteAction
/*    */     implements PrivilegedAction
/*    */   {
/*    */     private String name;
/*    */     private String value;
/*    */ 
/*    */     PropertyWriteAction(String name, String value)
/*    */     {
/* 57 */       this.name = name;
/* 58 */       this.value = value;
/*    */     }
/*    */ 
/*    */     public Object run() {
/* 62 */       return System.setProperty(this.name, this.value);
/*    */     }
/*    */   }
/*    */ 
/*    */   static class PropertyReadAction
/*    */     implements PrivilegedAction
/*    */   {
/*    */     private String name;
/*    */     private String defaultValue;
/*    */ 
/*    */     PropertyReadAction(String name, String defaultValue)
/*    */     {
/* 43 */       this.name = name;
/* 44 */       this.defaultValue = defaultValue;
/*    */     }
/*    */ 
/*    */     public Object run() {
/* 48 */       return System.getProperty(this.name, this.defaultValue);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.PropertyAccess
 * JD-Core Version:    0.6.0
 */