/*     */ package org.jboss.mx.util;
/*     */ 
/*     */ import javax.management.ObjectName;
/*     */ 
/*     */ public class ObservedObject
/*     */ {
/*     */   public static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
/*     */   public static final int RUNTIME_ERROR_NOTIFIED = 8;
/*     */   public static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
/*     */   public static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
/*     */   public static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
/*     */   private ObjectName objectName;
/*  67 */   private int alreadyNotified = 0;
/*     */   private Object derivedGauge;
/*     */   private Object lastValue;
/*     */   private long derivedGaugeTimeStamp;
/*     */   private Object threshold;
/*     */ 
/*     */   public ObservedObject(ObjectName objectName)
/*     */   {
/* 100 */     if (objectName == null)
/* 101 */       throw new IllegalArgumentException("Null object name");
/* 102 */     this.objectName = objectName;
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */   {
/* 109 */     return this.objectName;
/*     */   }
/*     */ 
/*     */   public int getAlreadyNotified()
/*     */   {
/* 114 */     return this.alreadyNotified;
/*     */   }
/*     */ 
/*     */   public boolean isAlreadyNotified(int mask)
/*     */   {
/* 119 */     return (this.alreadyNotified & mask) != 0;
/*     */   }
/*     */ 
/*     */   public boolean notAlreadyNotified(int mask)
/*     */   {
/* 124 */     if ((this.alreadyNotified & mask) == 0)
/*     */     {
/* 126 */       this.alreadyNotified |= mask;
/* 127 */       return true;
/*     */     }
/* 129 */     return false;
/*     */   }
/*     */ 
/*     */   public void setNotAlreadyNotified(int mask)
/*     */   {
/* 134 */     this.alreadyNotified &= (mask ^ 0xFFFFFFFF);
/*     */   }
/*     */ 
/*     */   public void setAlreadyNotified(int mask)
/*     */   {
/* 139 */     this.alreadyNotified |= mask;
/*     */   }
/*     */ 
/*     */   public void resetAlreadyNotified()
/*     */   {
/* 144 */     this.alreadyNotified = 0;
/*     */   }
/*     */ 
/*     */   public Object getDerivedGauge()
/*     */   {
/* 149 */     return this.derivedGauge;
/*     */   }
/*     */ 
/*     */   public void setDerivedGauge(Object gauge)
/*     */   {
/* 154 */     this.derivedGauge = gauge;
/*     */   }
/*     */ 
/*     */   public Object getLastValue()
/*     */   {
/* 159 */     return this.lastValue;
/*     */   }
/*     */ 
/*     */   public void setLastValue(Object last)
/*     */   {
/* 164 */     this.lastValue = last;
/*     */   }
/*     */ 
/*     */   public long getDerivedGaugeTimeStamp()
/*     */   {
/* 169 */     return this.derivedGaugeTimeStamp;
/*     */   }
/*     */ 
/*     */   public void setDerivedGaugeTimeStamp(long ts)
/*     */   {
/* 174 */     this.derivedGaugeTimeStamp = ts;
/*     */   }
/*     */ 
/*     */   public Object getThreshold()
/*     */   {
/* 179 */     return this.threshold;
/*     */   }
/*     */ 
/*     */   public void setThreshold(Object threshold)
/*     */   {
/* 184 */     this.threshold = threshold;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 192 */     StringBuffer buffer = new StringBuffer(100);
/* 193 */     buffer.append(getClass().getName()).append("@").append(System.identityHashCode(this)).append("{");
/* 194 */     buffer.append(" objectName=").append(getObjectName());
/* 195 */     buffer.append(" alreadyNotified=").append(getAlreadyNotified());
/* 196 */     buffer.append(" threshold=").append(getThreshold());
/* 197 */     buffer.append(" derivedGauge=").append(getDerivedGauge());
/* 198 */     buffer.append(" derivedGaugeTS=").append(getDerivedGaugeTimeStamp());
/* 199 */     buffer.append(" lastValue=").append(getLastValue());
/* 200 */     return "}";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.mx.util.ObservedObject
 * JD-Core Version:    0.6.0
 */